/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.plugin.auth.internal;

import com.atlassian.seraph.auth.AuthenticationContext;
import com.atlassian.seraph.config.SecurityConfig;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class AuthenticationContextCopyFilter
implements Filter {
    private final AuthenticationContext authenticationContext;
    private final ThreadLocal<Integer> entryCount = new ThreadLocal();
    private SecurityConfig securityConfig;

    public AuthenticationContextCopyFilter(AuthenticationContext authenticationContext) {
        this.authenticationContext = authenticationContext;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.securityConfig = (SecurityConfig)filterConfig.getServletContext().getAttribute("seraph_config");
        if (this.securityConfig == null) {
            throw new ServletException("No SecurityConfig found in servlet context!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.authenticationContext.setUser(this.securityConfig.getAuthenticationContext().getUser());
        this.entryCount.set(this.entryCount.get() == null ? 1 : this.entryCount.get() + 1);
        try {
            chain.doFilter(request, response);
        }
        finally {
            this.entryCount.set(this.entryCount.get() - 1);
            if (this.entryCount.get() == 0) {
                this.authenticationContext.clearUser();
            }
        }
    }

    public void destroy() {
    }
}

