/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.ws.util;

import java.util.function.Function;
import java.util.logging.Level;
import java.util.regex.Pattern;
import javax.ws.rs.core.FeatureContext;
import org.glassfish.jersey.logging.LoggingFeature;
import org.slf4j.Logger;

public class SLF4JLoggingFeature
extends LoggingFeature {
    private final Logger log;

    public SLF4JLoggingFeature(Logger log, String ... protectedHeaders) {
        super((java.util.logging.Logger)new Log(log, protectedHeaders.length > 0 ? new HeaderReplacer(protectedHeaders) : null));
        this.log = log;
    }

    public SLF4JLoggingFeature(Logger log, int maxEntitySize, String ... protectedHeaders) {
        super((java.util.logging.Logger)new Log(log, protectedHeaders.length > 0 ? new HeaderReplacer(protectedHeaders) : null), Integer.valueOf(maxEntitySize));
        this.log = log;
    }

    public SLF4JLoggingFeature(Logger log, Function<String, String> replacer) {
        super((java.util.logging.Logger)new Log(log, replacer));
        this.log = log;
    }

    public SLF4JLoggingFeature(Logger log, int maxEntitySize, Function<String, String> replacer) {
        super((java.util.logging.Logger)new Log(log, replacer), Integer.valueOf(maxEntitySize));
        this.log = log;
    }

    public boolean configure(FeatureContext context) {
        boolean enabled = false;
        if (this.log.isDebugEnabled()) {
            enabled = super.configure(context);
        }
        return enabled;
    }

    private static class HeaderReplacer
    implements Function<String, String> {
        private final Pattern pattern;

        public HeaderReplacer(String[] protectedHeaders) {
            StringBuilder builder = new StringBuilder();
            for (String header : protectedHeaders) {
                if (builder.length() > 0) {
                    builder.append("|");
                }
                builder.append("> (").append(header).append("):.*");
            }
            this.pattern = Pattern.compile(builder.toString());
        }

        @Override
        public String apply(String string) {
            return this.pattern.matcher(string).replaceAll("> $1: xxxxxxxx");
        }
    }

    private static final class Log
    extends java.util.logging.Logger {
        private final Logger log;
        private final Function<String, String> replacer;

        Log(Logger log, Function<String, String> replacer) {
            super("global", null);
            this.setLevel(Level.FINE);
            this.log = log;
            this.replacer = replacer;
        }

        @Override
        public void log(Level level, String msg) {
            if (msg != null && this.replacer != null) {
                msg = this.replacer.apply(msg);
            }
            this.log.debug(msg);
        }
    }
}

