/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.ws.util.filter;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.core.MediaType;
import org.openvpms.ws.util.MediaTypes;
import org.openvpms.ws.util.filter.AbstractSerialisedErrorMessageReader;

public class JSONErrorMessageReader<T>
extends AbstractSerialisedErrorMessageReader<T> {
    private final ObjectMapper mapper;

    public JSONErrorMessageReader(ObjectMapper mapper, Class<T> type) {
        super(type);
        this.mapper = mapper;
    }

    @Override
    public boolean canRead(ClientResponseContext response) {
        return MediaTypes.isA(this.getMediaType(response), MediaType.APPLICATION_JSON_TYPE);
    }

    @Override
    protected T deserialise(String value, Class<T> type) throws IOException {
        return (T)this.mapper.readValue(value, type);
    }
}

