/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.ws.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.ClientErrorException;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.NotAcceptableException;
import javax.ws.rs.NotAllowedException;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.NotSupportedException;
import javax.ws.rs.ServiceUnavailableException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.openvpms.ws.util.filter.ErrorMessageReader;
import org.openvpms.ws.util.filter.JSONErrorMessageReader;
import org.openvpms.ws.util.filter.PlainTextErrorMessageReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorResponseFilter
implements ClientResponseFilter {
    private final ErrorMessageReader reader;
    private static final ErrorMessageReader plainTextReader = new PlainTextErrorMessageReader();
    private static final Logger log = LoggerFactory.getLogger(ErrorResponseFilter.class);

    public ErrorResponseFilter() {
        this(null);
    }

    public <T> ErrorResponseFilter(ObjectMapper mapper, Class<T> errorType) {
        this(new JSONErrorMessageReader<T>(mapper, errorType));
    }

    public ErrorResponseFilter(ErrorMessageReader reader) {
        this.reader = reader;
    }

    public void filter(ClientRequestContext requestContext, ClientResponseContext responseContext) {
        Response.StatusType statusInfo = responseContext.getStatusInfo();
        if (statusInfo.getFamily() == Response.Status.Family.CLIENT_ERROR || statusInfo.getFamily() == Response.Status.Family.SERVER_ERROR) {
            MediaType mediaType = this.getMediaType(responseContext);
            if (responseContext.hasEntity() && mediaType != null) {
                WebApplicationException exception;
                String message = this.getErrorMessage(responseContext);
                int status = responseContext.getStatus();
                switch (status) {
                    case 400: {
                        exception = message == null ? new BadRequestException() : new BadRequestException(message);
                        break;
                    }
                    case 401: {
                        exception = this.createNotAuthorisedException(message, status);
                        break;
                    }
                    case 403: {
                        exception = message == null ? new ForbiddenException() : new ForbiddenException(message);
                        break;
                    }
                    case 404: {
                        exception = message == null ? new NotFoundException() : new NotFoundException(message);
                        break;
                    }
                    case 405: {
                        exception = this.createNotAllowedException(message, responseContext);
                        break;
                    }
                    case 406: {
                        exception = message == null ? new NotAcceptableException() : new NotAcceptableException(message);
                        break;
                    }
                    case 415: {
                        exception = message == null ? new NotSupportedException() : new NotSupportedException(message);
                        break;
                    }
                    case 500: {
                        exception = message == null ? new InternalServerErrorException() : new InternalServerErrorException(message);
                        break;
                    }
                    case 503: {
                        exception = message == null ? new ServiceUnavailableException() : new ServiceUnavailableException(message);
                        break;
                    }
                    default: {
                        exception = message == null ? new WebApplicationException(status) : new WebApplicationException(message, status);
                    }
                }
                throw exception;
            }
        }
    }

    protected MediaType getMediaType(ClientResponseContext response) {
        try {
            return response.getMediaType();
        }
        catch (Throwable exception) {
            return null;
        }
    }

    private String getErrorMessage(ClientResponseContext response) {
        String message = null;
        try {
            if (this.reader != null && this.reader.canRead(response)) {
                message = this.reader.read(response);
            } else if (plainTextReader.canRead(response)) {
                message = plainTextReader.read(response);
            }
        }
        catch (Throwable exception) {
            log.error("Failed to deserialise message from response: " + exception.getMessage(), exception);
        }
        return message;
    }

    private WebApplicationException createNotAuthorisedException(String message, int status) {
        Response response = Response.status((int)status).build();
        return message == null ? new NotAuthorizedException(response) : new NotAuthorizedException(message, response);
    }

    private WebApplicationException createNotAllowedException(String message, ClientResponseContext responseContext) {
        NotAllowedException result = null;
        try {
            String allowed = responseContext.getHeaderString("Allow");
            Response response = Response.status((int)405).header("Allow", (Object)allowed).build();
            result = message == null ? new NotAllowedException(response) : new NotAllowedException(message, response);
        }
        catch (Throwable exception) {
            log.error("Failed to create NotAllowedException: " + exception.getMessage(), exception);
        }
        if (result == null) {
            return new ClientErrorException(message, 405);
        }
        return result;
    }
}

