/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.ws.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import javax.ws.rs.Produces;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Provider;

@Provider
@Produces(value={"application/json"})
public class ObjectMapperContextResolver
implements ContextResolver<ObjectMapper> {
    public static final String ISO_8601_MILLSECOND_TIMEZONE = "yyyy-MM-dd'T'HH:mm:ss.SSSXXX";
    public static final String ISO_8601_SECOND_TIMEZONE = "yyyy-MM-dd'T'HH:mm:ssXXX";
    private final ObjectMapper mapper = new ObjectMapper();

    public ObjectMapperContextResolver(TimeZone timeZone) {
        SimpleDateFormat format = new SimpleDateFormat(ISO_8601_MILLSECOND_TIMEZONE);
        format.setTimeZone(timeZone);
        this.mapper.setDateFormat((DateFormat)format);
        this.mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
    }

    public ObjectMapperContextResolver(TimeZone timeZone, String pattern) {
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        format.setTimeZone(timeZone);
        this.mapper.setDateFormat((DateFormat)format);
        this.mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
    }

    public ObjectMapper getContext(Class<?> type) {
        return this.mapper;
    }
}

