/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.webdav.resource;

import io.milton.http.Auth;
import io.milton.http.LockManager;
import io.milton.http.Request;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.ConflictException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.resource.CollectionResource;
import io.milton.resource.PropFindableResource;
import io.milton.resource.PutableResource;
import io.milton.resource.Resource;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.joda.time.DateTime;
import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.object.Reference;
import org.openvpms.web.webdav.resource.DocumentResource;
import org.openvpms.web.webdav.resource.IMObjectResource;
import org.openvpms.web.webdav.session.Session;

public class DocumentActResource
implements CollectionResource,
PropFindableResource,
PutableResource,
IMObjectResource {
    private final DocumentAct act;
    private final Session session;
    private final String name;
    private final IArchetypeService service;
    private final DocumentHandlers handlers;
    private final LockManager lockManager;
    private final Date baseDate;
    private final String documentName;
    private DocumentResource resource;

    public DocumentActResource(DocumentAct act, Session session, IArchetypeService service, DocumentHandlers handlers, LockManager lockManager, Date baseDate) {
        this.act = act;
        this.session = session;
        this.name = Long.toString(act.getId());
        this.documentName = DocumentActResource.encode(act.getFileName());
        this.service = service;
        this.handlers = handlers;
        this.lockManager = lockManager;
        this.baseDate = baseDate;
    }

    public Resource child(String childName) {
        return Objects.equals(this.documentName, childName) ? this.getDocument() : null;
    }

    public List<? extends Resource> getChildren() throws NotAuthorizedException, BadRequestException {
        Resource document = this.getDocument();
        return document != null ? Collections.singletonList(document) : Collections.emptyList();
    }

    public String getUniqueId() {
        return this.act.getArchetype() + "-" + this.act.getId();
    }

    public String getName() {
        return this.name;
    }

    public Object authenticate(String user, String password) {
        return user;
    }

    public boolean authorise(Request request, Request.Method method, Auth auth) {
        return true;
    }

    public String getRealm() {
        return "WebDAV";
    }

    public Date getModifiedDate() {
        return new DateTime((Object)this.baseDate).plusSeconds((int)this.act.getVersion()).toDate();
    }

    public String checkRedirect(Request request) throws NotAuthorizedException, BadRequestException {
        return null;
    }

    public Date getCreateDate() {
        return this.act.getActivityStartTime();
    }

    public Resource createNew(String newName, InputStream inputStream, Long length, String contentType) throws IOException, ConflictException, NotAuthorizedException, BadRequestException {
        throw new NotAuthorizedException();
    }

    @Override
    public Reference getReference() {
        return this.act.getObjectReference();
    }

    @Override
    public long getVersion() {
        return this.act.getVersion();
    }

    public static String encode(String fileName) {
        return fileName != null ? fileName.replaceAll("[:/?#\\[\\]@!$&'()*+,;={}|^~`]", "") : null;
    }

    private synchronized Resource getDocument() {
        if (this.resource == null && this.act.getDocument() != null) {
            this.resource = new DocumentResource(this.documentName, this.session, this.act.getDocument(), this.service, this.handlers, this.lockManager);
        }
        return this.resource;
    }
}

