/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.webdav.milton;

import io.milton.http.HttpManager;
import io.milton.http.LockInfo;
import io.milton.http.LockResult;
import io.milton.http.LockTimeout;
import io.milton.http.LockToken;
import io.milton.http.Request;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.resource.LockableResource;
import io.milton.resource.Resource;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.collections4.map.PassiveExpiringMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openvpms.web.webdav.resource.ResourceLock;
import org.openvpms.web.webdav.resource.ResourceLockManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public class ResourceLockManagerImpl
implements ResourceLockManager {
    private final Map<String, ResourceLock> locksByUniqueId;
    private final Map<String, ResourceLock> locksByToken;
    private static final Log log = LogFactory.getLog(ResourceLockManagerImpl.class);

    public ResourceLockManagerImpl() {
        PassiveExpiringMap.ExpirationPolicy & Serializable policy = (PassiveExpiringMap.ExpirationPolicy & Serializable)(key, value) -> value.getExpirationTime();
        this.locksByUniqueId = new PassiveExpiringMap((PassiveExpiringMap.ExpirationPolicy)policy);
        this.locksByToken = new PassiveExpiringMap((PassiveExpiringMap.ExpirationPolicy)policy);
    }

    public synchronized LockResult lock(LockTimeout timeout, LockInfo lockInfo, LockableResource resource) {
        String token = UUID.randomUUID().toString();
        LockResult lock = this.lock(timeout, lockInfo, resource, token);
        if (log.isDebugEnabled()) {
            log.debug((Object)("lock: resource=" + this.toString(resource) + ", timeout=" + timeout + ", info=[" + lockInfo + "], lock=[" + this.toString(lock) + "]"));
        }
        return lock;
    }

    public synchronized LockResult refresh(String tokenId, LockableResource resource) {
        LockResult result;
        ResourceLock lock = this.locksByToken.get(tokenId);
        String uniqueId = resource.getUniqueId();
        if (lock == null) {
            lock = this.locksByUniqueId.get(uniqueId);
        }
        if (lock == null) {
            log.warn((Object)("refresh: missing token/etag=" + tokenId + " on resource=" + this.toString(resource) + ". Will create a new lock"));
            LockTimeout timeout = new LockTimeout(Long.valueOf(3600L));
            String lockedByUser = this.getCurrentUser();
            if (lockedByUser == null) {
                log.warn((Object)"No user in context, lock wont be very effective");
            }
            LockInfo lockInfo = new LockInfo(LockInfo.LockScope.EXCLUSIVE, LockInfo.LockType.WRITE, lockedByUser, LockInfo.LockDepth.ZERO);
            result = this.lock(timeout, lockInfo, resource, UUID.randomUUID().toString());
        } else {
            LockToken token = lock.getToken();
            token.setFrom(new Date());
            this.addLock(tokenId, uniqueId, lock);
            result = LockResult.success((LockToken)token);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("refresh: resource=" + this.toString(resource) + ", lock=" + this.toString(result)));
        }
        return result;
    }

    public synchronized void unlock(String tokenId, LockableResource resource) throws NotAuthorizedException {
        LockToken lockToken = this.getCurrentLock(resource.getUniqueId());
        if (lockToken == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("unlock: not locked, tokenId=" + tokenId + ", resource=" + this.toString(resource)));
            }
        } else if (lockToken.tokenId.equals(tokenId)) {
            ResourceLock lock = this.removeLock(lockToken);
            if (log.isDebugEnabled()) {
                if (lock != null) {
                    log.debug((Object)("unlock: tokenId=" + tokenId + ", resource=" + this.toString(resource) + ", user=" + lock.getUser()));
                } else {
                    log.debug((Object)("unlock: lock not found, tokenId=" + tokenId + ", resource=" + this.toString(resource)));
                }
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("unlock: non matching tokens, requested=" + tokenId + ", actual=" + this.toString(lockToken)));
            }
            throw new NotAuthorizedException("Non-matching tokens: " + tokenId, (Resource)resource);
        }
    }

    public synchronized LockToken getCurrentToken(LockableResource resource) {
        LockToken result = null;
        if (resource.getUniqueId() == null) {
            log.warn((Object)("No uniqueID for resource= " + this.toString(resource) + " : " + resource.getClass()));
        } else {
            ResourceLock lock = this.locksByUniqueId.get(resource.getUniqueId());
            if (lock != null && !lock.isExpired()) {
                LockInfo info = new LockInfo(LockInfo.LockScope.EXCLUSIVE, LockInfo.LockType.WRITE, lock.getUser(), LockInfo.LockDepth.ZERO);
                LockToken token = lock.getToken();
                result = new LockToken(token.tokenId, info, token.timeout);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("getCurrentToken: resource=" + this.toString(resource) + ", lock=" + this.toString(result)));
        }
        return result;
    }

    @Override
    public synchronized List<ResourceLock> getLocked() {
        HashSet<ResourceLock> result = new HashSet<ResourceLock>(this.locksByUniqueId.values());
        result.addAll(this.locksByToken.values());
        return new ArrayList<ResourceLock>(result);
    }

    @Override
    public synchronized boolean remove(ResourceLock lock) {
        int count = 0;
        if (this.locksByUniqueId.remove(lock.getUniqueId()) != null) {
            ++count;
        }
        if (this.locksByToken.remove(lock.getToken().tokenId) != null) {
            ++count;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("remove: id=" + lock.getUniqueId() + ", name=" + lock.getName() + ", user=" + lock.getUser() + ", token=" + this.toString(lock.getToken()) + ", count=" + count));
        }
        return count != 0;
    }

    private LockResult lock(LockTimeout timeout, LockInfo lockInfo, LockableResource resource, String token) {
        LockResult result;
        String uniqueId = resource.getUniqueId();
        if (uniqueId == null) {
            result = LockResult.failed((LockResult.FailureReason)LockResult.FailureReason.PRECONDITION_FAILED);
        } else {
            LockToken currentLock = this.getCurrentLock(uniqueId);
            if (currentLock != null) {
                result = LockResult.failed((LockResult.FailureReason)LockResult.FailureReason.ALREADY_LOCKED);
            } else {
                String currentUser;
                String lockedByUser = lockInfo.lockedByUser;
                Request req = HttpManager.request();
                if (req != null && (currentUser = this.getCurrentUser()) != null) {
                    lockedByUser = currentUser;
                    lockInfo = new LockInfo(lockInfo.scope, lockInfo.type, lockedByUser, lockInfo.depth);
                }
                LockToken newToken = new LockToken(token, lockInfo, timeout);
                ResourceLock lock = new ResourceLock(resource, newToken, lockedByUser);
                this.addLock(token, uniqueId, lock);
                result = LockResult.success((LockToken)newToken);
            }
        }
        return result;
    }

    private void addLock(String token, String uniqueId, ResourceLock lock) {
        this.locksByUniqueId.put(uniqueId, lock);
        this.locksByToken.put(token, lock);
    }

    private LockToken getCurrentLock(String uniqueId) {
        LockToken result = null;
        ResourceLock lock = this.locksByUniqueId.get(uniqueId);
        if (lock != null) {
            LockToken token = lock.getToken();
            if (token.isExpired()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Removing expired lock, id=" + lock.getUniqueId() + ", name=" + lock.getName() + ", user=" + lock.getUser()));
                }
                this.removeLock(token);
            } else {
                result = token;
            }
        }
        return result;
    }

    private synchronized ResourceLock removeLock(LockToken token) {
        ResourceLock lock = this.locksByToken.remove(token.tokenId);
        if (lock != null) {
            this.locksByUniqueId.remove(lock.getUniqueId());
        } else {
            log.warn((Object)("removeLock: lock not found=" + this.toString(token)));
        }
        return lock;
    }

    private String getCurrentUser() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        return authentication != null ? authentication.getName() : null;
    }

    private String toString(LockableResource resource) {
        return "[id=" + resource.getUniqueId() + ", name=" + resource.getName() + "]";
    }

    private String toString(LockResult result) {
        StringBuilder builder = new StringBuilder();
        if (result.isSuccessful()) {
            builder.append("success, token=").append(this.toString(result.getLockToken()));
        } else {
            builder.append("failure: ").append(result.getFailureReason());
        }
        return builder.toString();
    }

    private String toString(LockToken token) {
        StringBuilder builder = new StringBuilder();
        if (token != null) {
            builder.append("[tokenId=").append(token.tokenId).append(", info=[").append(token.info).append("]").append(", timeout=").append(token.timeout).append("]");
        } else {
            builder.append("null");
        }
        return builder.toString();
    }
}

