/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.webdav.milton;

import io.milton.config.HttpManagerBuilder;
import io.milton.http.HttpManager;
import io.milton.http.http11.ETagGenerator;
import io.milton.http.values.SupportedLocksValueWriter;
import java.util.List;
import javax.servlet.ServletContext;
import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.web.webdav.milton.IMObjectResourceETagGenerator;
import org.openvpms.web.webdav.milton.LockDiscoveryPropertyWriter;
import org.openvpms.web.webdav.milton.WebDAVProtocol;
import org.openvpms.web.webdav.resource.ResourceLockManager;
import org.openvpms.web.webdav.resource.WebDAVResourceFactory;
import org.openvpms.web.webdav.session.SessionManager;

public class HttpManagerFactory {
    private final SessionManager sessions;
    private final IArchetypeService service;
    private final DocumentHandlers handlers;
    private final ResourceLockManager lockManager;

    public HttpManagerFactory(SessionManager sessions, IArchetypeService service, DocumentHandlers handlers, ResourceLockManager lockManager) {
        this.sessions = sessions;
        this.service = service;
        this.handlers = handlers;
        this.lockManager = lockManager;
    }

    public HttpManager create(ServletContext context) {
        Builder builder = new Builder(context.getContextPath());
        return builder.buildHttpManager();
    }

    private class Builder
    extends HttpManagerBuilder {
        public Builder(String contextPath) {
            this.setEnableCookieAuth(false);
            this.setEnabledJson(false);
            this.setResourceFactory(new WebDAVResourceFactory(contextPath, HttpManagerFactory.this.sessions, HttpManagerFactory.this.service, HttpManagerFactory.this.handlers, HttpManagerFactory.this.lockManager));
            this.seteTagGenerator((ETagGenerator)new IMObjectResourceETagGenerator());
            List valueWriters = this.getValueWriters().getValueWriters();
            int size = valueWriters.size();
            valueWriters.add(size - 1, new LockDiscoveryPropertyWriter());
            valueWriters.add(size, new SupportedLocksValueWriter());
        }

        protected void initWebdavProtocol() {
            this.setWebDavProtocol(new WebDAVProtocol(this.handlerHelper, this.resourceTypeHelper, this.webdavResponseHandler, this.propertySources, this.quotaDataAccessor, this.buildPatchSetter(), this.initPropertyAuthoriser(), this.eTagGenerator, this.urlAdapter, this.resourceHandlerHelper, this.userAgentHelper(), this.propFindRequestFieldParser(), this.propFindPropertyBuilder(), this.displayNameFormatter, this.enableTextContentProperty));
        }
    }
}

