/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.webdav.servlet;

import com.github.isrsal.logging.RequestWrapper;
import com.github.isrsal.logging.ResponseWrapper;
import io.milton.http.HttpManager;
import io.milton.http.Request;
import io.milton.http.Response;
import io.milton.servlet.ServletRequest;
import io.milton.servlet.ServletResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openvpms.web.webdav.milton.HttpManagerFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class WebDAVServlet
extends HttpServlet {
    private HttpManager httpManager;
    private final AtomicLong id = new AtomicLong(1L);
    private static final Log log = LogFactory.getLog(WebDAVServlet.class);

    public void init() throws ServletException {
        super.init();
        WebApplicationContext context = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext());
        HttpManagerFactory factory = (HttpManagerFactory)context.getBean(HttpManagerFactory.class);
        this.httpManager = factory.create(this.getServletContext());
    }

    public String getServletInfo() {
        return "WebDAVServlet";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (log.isDebugEnabled()) {
            long requestId = this.id.incrementAndGet();
            request = new RequestWrapper(Long.valueOf(requestId), request);
            response = new ResponseWrapper(Long.valueOf(requestId), response);
            this.log((RequestWrapper)request);
        }
        try {
            this.httpManager.process((Request)new ServletRequest(request, this.getServletContext()), (Response)new ServletResponse(response));
        }
        finally {
            response.getOutputStream().flush();
            response.flushBuffer();
        }
        if (log.isDebugEnabled()) {
            this.log((RequestWrapper)request, (ResponseWrapper)response);
        }
    }

    private void log(RequestWrapper request) {
        StringBuilder builder = new StringBuilder();
        builder.append("WebDAV request: id=").append(request.getId()).append(", ").append(request.getMethod()).append(" ").append(request.getRequestURL());
        Enumeration headers = request.getHeaderNames();
        while (headers.hasMoreElements()) {
            String name = (String)headers.nextElement();
            builder.append("\n header: ").append(name).append("=").append(request.getHeader(name));
        }
        log.debug((Object)builder.toString());
    }

    private void log(RequestWrapper request, ResponseWrapper response) {
        StringBuilder builder = new StringBuilder();
        if (this.isLoggable(request.getContentType())) {
            builder.append("WebDAV request: id=").append(request.getId()).append(", ").append(request.getMethod()).append(" ").append(request.getRequestURL());
            builder.append("\n body: ").append(this.getBody(request.toByteArray(), request.getCharacterEncoding()));
        }
        Response.Status status = Response.Status.fromCode((int)response.getStatus());
        builder.append("WebDAV response: id=").append(response.getId()).append(", ").append(request.getMethod()).append(request.getRequestURL()).append(" - ").append(status);
        for (String name : response.getHeaderNames()) {
            builder.append("\n header: ").append(name).append("=").append(response.getHeader(name));
        }
        if (this.isLoggable(response.getContentType())) {
            builder.append("\n body: ").append(this.getBody(response.toByteArray(), response.getCharacterEncoding()));
        }
        log.debug((Object)builder.toString());
    }

    private String getBody(byte[] body, String characterEncoding) {
        String result = "";
        if (characterEncoding == null) {
            characterEncoding = "UTF-8";
        }
        try {
            result = new String(body, characterEncoding);
        }
        catch (UnsupportedEncodingException exception) {
            log.warn((Object)"Failed to parse body: ", (Throwable)exception);
        }
        return result;
    }

    private boolean isLoggable(String contentType) {
        return contentType != null && (contentType.contains("application/xml") || contentType.contains("text/xml"));
    }
}

