/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.webdav.milton;

import io.milton.http.ExistingEntityHandler;
import io.milton.http.HttpManager;
import io.milton.http.Request;
import io.milton.http.ResourceHandler;
import io.milton.http.ResourceHandlerHelper;
import io.milton.http.Response;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.ConflictException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.http.exceptions.NotFoundException;
import io.milton.http.exceptions.PreConditionFailedException;
import io.milton.http.webdav.WebDavResponseHandler;
import io.milton.resource.LockableResource;
import io.milton.resource.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openvpms.web.webdav.milton.LockHelper;

public class UnlockHandler
implements ExistingEntityHandler {
    private final WebDavResponseHandler responseHandler;
    private final ResourceHandlerHelper resourceHandler;
    private static final String[] METHODS = new String[]{Request.Method.UNLOCK.code};
    private static final Log log = LogFactory.getLog(UnlockHandler.class);

    public UnlockHandler(WebDavResponseHandler responseHandler, ResourceHandlerHelper resourceHandler) {
        this.responseHandler = responseHandler;
        this.resourceHandler = resourceHandler;
    }

    public String[] getMethods() {
        return METHODS;
    }

    public boolean isCompatible(Resource resource) {
        return resource instanceof LockableResource;
    }

    public void process(HttpManager manager, Request request, Response response) throws ConflictException, NotAuthorizedException, BadRequestException {
        this.resourceHandler.process(manager, request, response, (ResourceHandler)this);
    }

    public void processResource(HttpManager manager, Request request, Response response, Resource resource) throws NotAuthorizedException, ConflictException, BadRequestException {
        this.resourceHandler.processResource(manager, request, response, resource, (ExistingEntityHandler)this);
    }

    public void processExistingResource(HttpManager manager, Request request, Response response, Resource resource) throws NotAuthorizedException, BadRequestException, ConflictException, NotFoundException {
        LockableResource lockable = (LockableResource)resource;
        String token = LockHelper.parseToken(request.getLockTokenHeader());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Unlocking resource " + request.getAbsolutePath() + " with token=" + token));
        }
        try {
            lockable.unlock(token);
            this.responseHandler.respondNoContent(resource, response, request);
        }
        catch (PreConditionFailedException ex) {
            this.responseHandler.respondPreconditionFailed(request, response, resource);
        }
    }
}

