/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.webdav.milton;

import io.milton.http.ExistingEntityHandler;
import io.milton.http.HttpManager;
import io.milton.http.LockInfo;
import io.milton.http.LockInfoSaxHandler;
import io.milton.http.LockResult;
import io.milton.http.LockTimeout;
import io.milton.http.Request;
import io.milton.http.ResourceHandler;
import io.milton.http.ResourceHandlerHelper;
import io.milton.http.Response;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.ConflictException;
import io.milton.http.exceptions.LockedException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.http.exceptions.NotFoundException;
import io.milton.http.exceptions.PreConditionFailedException;
import io.milton.http.webdav.WebDavResponseHandler;
import io.milton.resource.LockableResource;
import io.milton.resource.Resource;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openvpms.web.webdav.milton.LockHelper;
import org.xml.sax.SAXException;

public class LockHandler
implements ExistingEntityHandler {
    private final WebDavResponseHandler responseHandler;
    private final ResourceHandlerHelper resourceHandler;
    private static final Log log = LogFactory.getLog(LockHandler.class);
    private static final String[] METHODS = new String[]{Request.Method.LOCK.code};

    public LockHandler(WebDavResponseHandler responseHandler, ResourceHandlerHelper resourceHandler) {
        this.responseHandler = responseHandler;
        this.resourceHandler = resourceHandler;
    }

    public String[] getMethods() {
        return METHODS;
    }

    public boolean isCompatible(Resource resource) {
        return resource instanceof LockableResource;
    }

    public void process(HttpManager manager, Request request, Response response) throws ConflictException, NotAuthorizedException, BadRequestException {
        this.resourceHandler.process(manager, request, response, (ResourceHandler)this);
    }

    public void processResource(HttpManager manager, Request request, Response response, Resource resource) throws NotAuthorizedException, ConflictException, BadRequestException {
        this.resourceHandler.processResource(manager, request, response, resource, (ExistingEntityHandler)this);
    }

    public void processExistingResource(HttpManager manager, Request request, Response response, Resource resource) throws NotAuthorizedException, BadRequestException, ConflictException, NotFoundException {
        LockableResource lockable = (LockableResource)resource;
        response.setContentTypeHeader("text/xml; charset=UTF-8");
        String header = request.getIfHeader();
        if (StringUtils.isEmpty((CharSequence)header)) {
            this.createLock(request, response, lockable);
        } else {
            this.refreshLock(request, response, lockable, header);
        }
    }

    private void createLock(Request request, Response response, LockableResource resource) throws BadRequestException, NotAuthorizedException {
        LockInfo lockInfo;
        LockTimeout timeout = LockTimeout.parseTimeout((Request)request);
        try {
            lockInfo = LockInfoSaxHandler.parseLockInfo((Request)request);
        }
        catch (IOException | SAXException exception) {
            throw new BadRequestException("Failed to read lock: " + exception.getMessage(), (Throwable)exception);
        }
        if (this.resourceHandler.isLockedOut(request, (Resource)resource)) {
            this.responseHandler.respondLocked(request, response, (Resource)resource);
        } else {
            try {
                LockResult result = resource.lock(timeout, lockInfo);
                if (result.isSuccessful()) {
                    this.respondSuccess(result, request, response);
                } else {
                    this.respondFailure(result, response);
                }
            }
            catch (PreConditionFailedException exception) {
                this.responseHandler.respondPreconditionFailed(request, response, (Resource)resource);
            }
            catch (LockedException exception) {
                this.responseHandler.respondLocked(request, response, (Resource)resource);
            }
        }
    }

    private void refreshLock(Request request, Response response, LockableResource resource, String ifHeader) throws NotAuthorizedException {
        String token = LockHelper.parseToken(ifHeader);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Refreshing lock on " + request.getAbsolutePath() + " with token=" + token));
        }
        try {
            LockResult result = resource.refreshLock(token);
            if (result.isSuccessful()) {
                this.respondSuccess(result, request, response);
            } else {
                this.respondFailure(result, response);
            }
        }
        catch (PreConditionFailedException exception) {
            this.responseHandler.respondPreconditionFailed(request, response, (Resource)resource);
        }
    }

    private void respondSuccess(LockResult result, Request request, Response response) {
        response.setStatus(Response.Status.SC_OK);
        String lock = LockHelper.serialiseLockResponse(result.getLockToken(), request.getAbsoluteUrl());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Lock response: " + lock));
        }
        try {
            response.getOutputStream().write(lock.getBytes());
        }
        catch (IOException exception) {
            log.warn((Object)"Failed to write lock response", (Throwable)exception);
        }
    }

    private void respondFailure(LockResult result, Response response) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Lock failed: " + result.getFailureReason()));
        }
        response.setStatus(result.getFailureReason().status);
    }
}

