/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.webdav.milton;

import java.util.Date;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.map.LRUMap;
import org.apache.commons.collections4.map.PassiveExpiringMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.user.User;
import org.openvpms.web.webdav.resource.DocumentActResource;
import org.openvpms.web.webdav.resource.EditableDocuments;
import org.openvpms.web.webdav.session.Session;
import org.openvpms.web.webdav.session.SessionManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public class DocumentSessionManager
implements SessionManager {
    private final Map<String, Session> sessions;
    private final EditableDocuments documents;
    private static final Log log = LogFactory.getLog(DocumentSessionManager.class);

    public DocumentSessionManager(EditableDocuments documents, int maxSessions, long timeToLive) {
        this.documents = documents;
        LRUMap map = new LRUMap(maxSessions);
        this.sessions = new PassiveExpiringMap(timeToLive, TimeUnit.MINUTES, (Map)map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Session get(String sessionId) {
        Session session;
        Map<String, Session> map = this.sessions;
        synchronized (map) {
            session = this.sessions.get(sessionId);
            if (session != null) {
                this.add(session);
            }
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Session create(DocumentAct act) {
        SessionImpl session = new SessionImpl(this.getUser(), act);
        Map<String, Session> map = this.sessions;
        synchronized (map) {
            this.add(session);
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Session create(String sessionId, String actId, String name) {
        DocumentAct act;
        SessionImpl session = null;
        if (this.isValid(sessionId) && (act = this.getDocumentAct(actId)) != null && StringUtils.equals((CharSequence)DocumentActResource.encode(act.getFileName()), (CharSequence)name)) {
            Map<String, Session> map = this.sessions;
            synchronized (map) {
                if (this.sessions.get(sessionId) == null) {
                    session = new SessionImpl(sessionId, this.getUser(), act);
                    this.add(session);
                }
            }
        }
        return session;
    }

    protected User getUser() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null) {
            throw new IllegalStateException("No current user");
        }
        return (User)authentication.getPrincipal();
    }

    protected DocumentAct getDocumentAct(String id) {
        DocumentAct result = null;
        try {
            result = this.documents.getDocumentAct(Long.parseLong(id));
        }
        catch (NumberFormatException ignore) {
            log.warn((Object)("Invalid document act identifier: " + id));
        }
        return result;
    }

    private boolean isValid(String sessionId) {
        boolean valid = false;
        try {
            UUID.fromString(sessionId);
            valid = true;
        }
        catch (IllegalArgumentException exception) {
            log.warn((Object)("Invalid session identifier: " + sessionId));
        }
        return valid;
    }

    private void add(Session session) {
        this.sessions.put(session.getSessionId(), session);
    }

    private static class SessionImpl
    implements Session {
        private final String sessionId;
        private final String userName;
        private final Reference act;
        private final String fileName;
        private final Date created;

        SessionImpl(User user, DocumentAct act) {
            this(UUID.randomUUID().toString(), user, act);
        }

        SessionImpl(String sessionId, User user, DocumentAct act) {
            this.sessionId = sessionId;
            this.userName = user.getUsername();
            this.act = act.getObjectReference();
            this.fileName = DocumentActResource.encode(act.getFileName());
            this.created = new Date();
        }

        @Override
        public String getSessionId() {
            return this.sessionId;
        }

        @Override
        public String getUserName() {
            return this.userName;
        }

        @Override
        public Reference getDocumentAct() {
            return this.act;
        }

        @Override
        public String getPath() {
            return "/" + this.sessionId + "/" + this.act.getId() + "/" + this.fileName;
        }

        @Override
        public Date getCreated() {
            return this.created;
        }
    }
}

