/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.webdav.servlet;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.business.domain.im.security.User;
import org.openvpms.component.business.service.security.UserService;
import org.openvpms.web.webdav.session.Session;
import org.openvpms.web.webdav.session.SessionManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.filter.GenericFilterBean;

public class WebDAVAuthenticationFilter
extends GenericFilterBean {
    private final SessionManager sessions;
    private final UserService users;

    public WebDAVAuthenticationFilter(SessionManager sessions, UserService users) {
        this.sessions = sessions;
        this.users = users;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        this.authenticate((HttpServletRequest)request);
        filterChain.doFilter(request, response);
    }

    protected void authenticate(HttpServletRequest request) {
        String sessionId;
        Session session;
        String contextPath = request.getContextPath();
        String uri = request.getRequestURI();
        String path = uri.substring(contextPath.length());
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if ((path = StringUtils.substringAfter((String)path, (String)"webdav")).startsWith("/")) {
            path = path.substring(1);
        }
        if ((session = this.sessions.get(sessionId = StringUtils.substringBefore((String)path, (String)"/"))) != null) {
            String userName = session.getUserName();
            User user = (User)this.users.loadUserByUsername(userName);
            UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)user, (Object)user.getPassword(), user.getAuthorities());
            SecurityContextHolder.getContext().setAuthentication((Authentication)token);
        }
    }
}

