/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.webdav.resource;

import io.milton.http.Auth;
import io.milton.http.LockManager;
import io.milton.http.Request;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.resource.CollectionResource;
import io.milton.resource.PropFindableResource;
import io.milton.resource.Resource;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.web.webdav.resource.DocumentActResource;
import org.openvpms.web.webdav.session.Session;

public class SessionResource
implements CollectionResource,
PropFindableResource {
    private final Session session;
    private final IArchetypeService service;
    private final DocumentHandlers handlers;
    private final LockManager lockManager;
    private DocumentActResource resource;

    public SessionResource(Session session, IArchetypeService service, DocumentHandlers handlers, LockManager lockManager) {
        this.session = session;
        this.service = service;
        this.handlers = handlers;
        this.lockManager = lockManager;
    }

    public Session getSession() {
        return this.session;
    }

    public Resource child(String childName) {
        return StringUtils.equals((CharSequence)Long.toString(this.session.getDocumentAct().getId()), (CharSequence)childName) ? this.getChildResource() : null;
    }

    public List<? extends Resource> getChildren() throws NotAuthorizedException, BadRequestException {
        Resource act = this.getChildResource();
        return act != null ? Collections.singletonList(act) : Collections.emptyList();
    }

    public String getUniqueId() {
        return this.session.getSessionId();
    }

    public String getName() {
        return this.session.getSessionId();
    }

    public Object authenticate(String user, String password) {
        return user;
    }

    public boolean authorise(Request request, Request.Method method, Auth auth) {
        return true;
    }

    public String getRealm() {
        return "WebDAV";
    }

    public Date getModifiedDate() {
        return this.session.getCreated();
    }

    public String checkRedirect(Request request) throws NotAuthorizedException, BadRequestException {
        return null;
    }

    public Date getCreateDate() {
        return this.session.getCreated();
    }

    private synchronized Resource getChildResource() {
        DocumentAct act;
        if (this.resource == null && (act = (DocumentAct)this.service.get(this.session.getDocumentAct(), DocumentAct.class)) != null) {
            this.resource = new DocumentActResource(act, this.session, this.service, this.handlers, this.lockManager, this.session.getCreated());
        }
        return this.resource;
    }
}

