/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.webdav.resource;

import io.milton.common.ContentTypeUtils;
import io.milton.http.Auth;
import io.milton.http.LockInfo;
import io.milton.http.LockManager;
import io.milton.http.LockResult;
import io.milton.http.LockTimeout;
import io.milton.http.LockToken;
import io.milton.http.Range;
import io.milton.http.Request;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.LockedException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.http.exceptions.NotFoundException;
import io.milton.http.exceptions.PreConditionFailedException;
import io.milton.resource.GetableResource;
import io.milton.resource.LockableResource;
import io.milton.resource.PropFindableResource;
import io.milton.resource.ReplaceableResource;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.joda.time.DateTime;
import org.openvpms.archetype.rules.doc.DocumentHandler;
import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.component.business.domain.im.document.Document;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.NodeSelectConstraint;
import org.openvpms.component.system.common.query.ObjectSet;
import org.openvpms.component.system.common.query.ObjectSetQueryIterator;
import org.openvpms.web.webdav.resource.IMObjectResource;
import org.openvpms.web.webdav.session.Session;

class DocumentResource
implements GetableResource,
ReplaceableResource,
PropFindableResource,
LockableResource,
IMObjectResource {
    private final Session session;
    private final String name;
    private final Reference reference;
    private final DocumentHandlers handlers;
    private final IArchetypeService service;
    private final LockManager lockManager;
    private State cachedState;

    DocumentResource(String name, Session session, Reference reference, IArchetypeService service, DocumentHandlers handlers, LockManager lockManager) {
        this.name = name;
        this.session = session;
        this.reference = reference;
        this.handlers = handlers;
        this.service = service;
        this.lockManager = lockManager;
    }

    public String getUniqueId() {
        return this.reference.getArchetype() + "-" + this.reference.getId();
    }

    public String getName() {
        return this.name;
    }

    public Object authenticate(String user, String password) {
        return user;
    }

    public boolean authorise(Request request, Request.Method method, Auth auth) {
        return true;
    }

    public String getRealm() {
        return "WebDAV";
    }

    public Date getModifiedDate() {
        return this.getState().modified;
    }

    public String checkRedirect(Request request) {
        return null;
    }

    public void sendContent(OutputStream out, Range range, Map<String, String> params, String contentType) throws IOException, NotAuthorizedException, BadRequestException, NotFoundException {
        Document document = this.getDocument();
        if (document == null) {
            throw new NotFoundException("Document " + this.reference + " no longer exists");
        }
        DocumentHandler handler = this.handlers.get((org.openvpms.component.model.document.Document)document);
        try (InputStream stream = handler.getContent((org.openvpms.component.model.document.Document)document);){
            IOUtils.copy((InputStream)stream, (OutputStream)out);
        }
    }

    public Long getMaxAgeSeconds(Auth auth) {
        return 3600L;
    }

    public String getContentType(String accepts) {
        State state = this.getState();
        return ContentTypeUtils.findAcceptableContentType((String)state.mimeType, (String)accepts);
    }

    public Long getContentLength() {
        return this.reference != null ? Long.valueOf(this.getState().size) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceContent(InputStream in, Long length) throws BadRequestException {
        Document document = this.getDocument();
        if (document == null) {
            throw new BadRequestException("Document " + this.reference + " no longer exists");
        }
        String mimeType = this.getState().mimeType;
        DocumentHandler handler = this.handlers.get(this.name, mimeType);
        int size = length != null ? length.intValue() : -1;
        handler.update(document, in, mimeType, size);
        this.service.save((IMObject)document);
        DocumentResource documentResource = this;
        synchronized (documentResource) {
            this.cachedState.size = size;
            this.cachedState.version = document.getVersion();
            this.updateModified();
        }
    }

    public Date getCreateDate() {
        return this.session.getCreated();
    }

    public LockResult lock(LockTimeout timeout, LockInfo lockInfo) throws NotAuthorizedException, PreConditionFailedException, LockedException {
        return this.lockManager.lock(timeout, lockInfo, (LockableResource)this);
    }

    public LockResult refreshLock(String token) throws NotAuthorizedException, PreConditionFailedException {
        return this.lockManager.refresh(token, (LockableResource)this);
    }

    public void unlock(String tokenId) throws NotAuthorizedException, PreConditionFailedException {
        this.lockManager.unlock(tokenId, (LockableResource)this);
    }

    public LockToken getCurrentLock() {
        return this.lockManager.getCurrentToken((LockableResource)this);
    }

    @Override
    public Reference getReference() {
        return this.reference;
    }

    @Override
    public long getVersion() {
        return this.getState().version;
    }

    private synchronized State getState() {
        if (this.cachedState == null) {
            ArchetypeQuery query = new ArchetypeQuery(this.reference);
            query.getArchetypeConstraint().setAlias("doc");
            query.add((IConstraint)new NodeSelectConstraint("version"));
            query.add((IConstraint)new NodeSelectConstraint("mimeType"));
            query.add((IConstraint)new NodeSelectConstraint("size"));
            ObjectSetQueryIterator iterator = new ObjectSetQueryIterator(this.service, (IArchetypeQuery)query);
            this.cachedState = new State();
            if (iterator.hasNext()) {
                ObjectSet set = (ObjectSet)iterator.next();
                this.cachedState.version = set.getLong("doc.version");
                this.cachedState.mimeType = set.getString("doc.mimeType");
                this.cachedState.size = set.getLong("doc.size");
                this.updateModified();
            }
        }
        return this.cachedState;
    }

    private void updateModified() {
        this.cachedState.modified = this.cachedState.version == 0L ? this.session.getCreated() : new DateTime((Object)this.session.getCreated()).plusSeconds((int)this.cachedState.version).toDate();
    }

    private Document getDocument() {
        return (Document)this.service.get(this.reference, Document.class);
    }

    private static class State {
        long version;
        String mimeType;
        long size;
        Date modified;

        private State() {
        }
    }
}

