/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.webdav.milton;

import io.milton.http.LockInfo;
import io.milton.http.LockToken;
import io.milton.http.XmlWriter;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;

public class LockHelper {
    public static String serialiseLockResponse(LockToken lock, String uri) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        XmlWriter writer = new XmlWriter((OutputStream)out);
        writer.writeXMLHeader();
        String prefix = "D";
        writer.open(prefix, "prop xmlns:D=\"DAV:\"");
        writer.newLine();
        LockHelper.writeLockDiscovery(lock, prefix, uri, writer);
        writer.close(prefix, "prop");
        writer.flush();
        return out.toString();
    }

    public static void writeLockDiscovery(LockToken lock, String prefix, String uri, XmlWriter writer) {
        writer.open(prefix, "lockdiscovery");
        if (lock != null) {
            writer.open(prefix, "activelock");
            writer.writeProperty(prefix, "locktype", "<" + prefix + ":" + lock.info.type.toString().toLowerCase() + "/>");
            writer.writeProperty(prefix, "lockscope", "<" + prefix + ":" + lock.info.scope.toString().toLowerCase() + "/>");
            writer.writeProperty(prefix, "depth", LockHelper.getDepth(lock.info.depth));
            writer.writeProperty(prefix, "owner", lock.info.lockedByUser);
            Long seconds = lock.timeout.getSeconds();
            if (seconds != null && seconds > 0L) {
                writer.writeProperty(prefix, "timeout", "Second-" + seconds);
            }
            XmlWriter.Element lockToken = writer.begin(prefix, "locktoken").open();
            writer.writeProperty(prefix, "href", "opaquelocktoken:" + lock.tokenId);
            lockToken.close();
            XmlWriter.Element lockRoot = writer.begin(prefix, "lockroot").open();
            writer.writeProperty(prefix, "href", uri);
            lockRoot.close();
            writer.close(prefix, "activelock");
        }
        writer.close(prefix, "lockdiscovery");
    }

    public static String parseToken(String header) {
        String result = header;
        int index = result.indexOf(":");
        if (index >= 0 && (index = (result = result.substring(index + 1)).indexOf(">")) >= 0) {
            result = result.substring(0, index);
        }
        return result;
    }

    private static String getDepth(LockInfo.LockDepth depth) {
        String result = "Infinity";
        if (depth != null && depth == LockInfo.LockDepth.ZERO) {
            result = "0";
        }
        return result;
    }
}

