/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.webdav.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.web.webdav.session.Session;
import org.openvpms.web.webdav.session.SessionManager;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class WebDAVEditorLauncherServlet
extends HttpServlet {
    private SessionManager manager;
    private static final String TEMPLATE_PATH = "/webstart/launch.jnlp";

    public void init() {
        WebApplicationContext context = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext());
        this.manager = (SessionManager)context.getBean(SessionManager.class);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String id;
        String sessionId = request.getParameter("session");
        Session session = this.getSession(sessionId, NumberUtils.toLong((String)(id = request.getParameter("id")), (long)-1L));
        if (session == null) {
            response.sendError(400);
        } else {
            response.setContentType("application/x-java-jnlp-file");
            response.setHeader("Cache-Control", "no-cache");
            response.setHeader("Content-Disposition", "attachment; filename=\"externaledit.jnlp\"");
            String output = this.generateJNLP(request, session);
            response.getWriter().println(output);
        }
    }

    private Session getSession(String sessionId, long id) {
        Session session;
        Session result = null;
        if (sessionId != null && (session = this.manager.get(sessionId)) != null && id == session.getDocumentAct().getId()) {
            result = session;
        }
        return result;
    }

    private String generateJNLP(HttpServletRequest request, Session session) throws IOException {
        String jnlp = this.getTemplate();
        String baseURL = this.getServerURL(request);
        String requestURI = request.getRequestURI();
        int index = requestURI.lastIndexOf(47);
        String name = requestURI.substring(index + 1);
        String context = requestURI.substring(0, index + 1);
        String codebase = context + "webstart";
        String doc = baseURL + context + "webdav" + session.getPath();
        jnlp = StringUtils.replace((String)jnlp, (String)"$$name", (String)name);
        jnlp = StringUtils.replace((String)jnlp, (String)"$$hostname", (String)request.getServerName());
        jnlp = StringUtils.replace((String)jnlp, (String)"$$codebase", (String)(baseURL + codebase));
        jnlp = StringUtils.replace((String)jnlp, (String)"$$context", (String)(baseURL + context));
        jnlp = StringUtils.replace((String)jnlp, (String)"$$site", (String)baseURL);
        jnlp = StringUtils.replace((String)jnlp, (String)"$$doc", (String)doc);
        return jnlp;
    }

    private String getTemplate() throws IOException {
        String template;
        try (InputStream stream = ((Object)((Object)this)).getClass().getResourceAsStream(TEMPLATE_PATH);){
            if (stream == null) {
                throw new IOException("/webstart/launch.jnlp not found");
            }
            template = IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
        }
        return template;
    }

    private String getServerURL(HttpServletRequest request) {
        String url = request.getRequestURL().toString();
        return url.substring(0, url.length() - request.getRequestURI().length());
    }
}

