/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.webdav.resource;

import io.milton.common.Path;
import io.milton.http.ResourceFactory;
import io.milton.resource.Resource;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.web.webdav.resource.DocumentActResource;
import org.openvpms.web.webdav.resource.ResourceLockManager;
import org.openvpms.web.webdav.resource.SessionResource;
import org.openvpms.web.webdav.session.Session;
import org.openvpms.web.webdav.session.SessionManager;

public class WebDAVResourceFactory
implements ResourceFactory {
    private final String root;
    private final IArchetypeService service;
    private final SessionManager sessions;
    private final DocumentHandlers handlers;
    private final ResourceLockManager lockManager;

    public WebDAVResourceFactory(String contextPath, SessionManager sessions, IArchetypeService service, DocumentHandlers handlers, ResourceLockManager lockManager) {
        this.service = service;
        this.sessions = sessions;
        this.handlers = handlers;
        this.lockManager = lockManager;
        if (!contextPath.endsWith("/")) {
            contextPath = contextPath + "/";
        }
        this.root = contextPath + "webdav";
    }

    public Resource getResource(String host, String path) {
        Object resource = null;
        String[] elements = this.getPathParts(path);
        if (elements.length == 1) {
            resource = this.getSessionResource(elements[0]);
        } else if (elements.length == 2) {
            resource = this.getDocumentActResource(elements[0], elements[1]);
        } else if (elements.length == 3) {
            resource = this.getDocumentResource(elements[0], elements[1], elements[2]);
        }
        return resource;
    }

    private SessionResource getSessionResource(String id) {
        Session session = this.sessions.get(id);
        return session != null ? new SessionResource(session, this.service, this.handlers, this.lockManager) : null;
    }

    private DocumentActResource getDocumentActResource(String sessionId, String id) {
        SessionResource session = this.getSessionResource(sessionId);
        return session != null ? (DocumentActResource)session.child(id) : null;
    }

    private Resource getDocumentResource(String sessionId, String id, String name) {
        DocumentActResource act;
        Resource result = null;
        SessionResource session = this.getSessionResource(sessionId);
        if (session == null) {
            session = this.getSessionResource(sessionId, id, name);
        }
        if (session != null && (act = (DocumentActResource)session.child(id)) != null) {
            result = act.child(name);
        }
        return result;
    }

    private SessionResource getSessionResource(String sessionId, String id, String name) {
        Session session = this.sessions.create(sessionId, id, name);
        return session != null ? this.getSessionResource(sessionId) : null;
    }

    private String[] getPathParts(String path) {
        path = StringUtils.removeEnd((String)path, (String)"/.");
        path = StringUtils.removeStart((String)path, (String)this.root);
        path = StringUtils.removeEnd((String)path, (String)"/");
        return Path.path((String)path).getParts();
    }
}

