/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.webdav.resource;

import io.milton.http.LockToken;
import io.milton.resource.LockableResource;
import org.joda.time.DateTime;

public class ResourceLock {
    private final String uniqueId;
    private final String name;
    private final LockToken token;
    private final String user;

    public ResourceLock(LockableResource resource, LockToken token, String user) {
        this.uniqueId = resource.getUniqueId();
        this.name = resource.getName();
        this.token = token;
        this.user = user;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public String getName() {
        return this.name;
    }

    public LockToken getToken() {
        return this.token;
    }

    public String getUser() {
        return this.user;
    }

    public boolean isExpired() {
        return this.token.isExpired();
    }

    public long getExpirationTime() {
        Long seconds = this.token.timeout.getSeconds();
        long result = seconds != null ? new DateTime((Object)this.token.getFrom()).plusSeconds(seconds.intValue()).getMillis() : Long.MAX_VALUE;
        return result;
    }
}

