/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.webdav.resource;

import java.util.HashSet;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptor;
import org.openvpms.component.business.service.archetype.ArchetypeServiceHelper;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.IMObjectQueryIterator;

public class EditableDocuments {
    private final IArchetypeService service;
    private final String[] shortNames;
    private static final Log log = LogFactory.getLog(EditableDocuments.class);

    public EditableDocuments(IArchetypeService service, String[] archetypes) {
        this.service = service;
        this.shortNames = this.getShortNames(archetypes, service);
    }

    public String[] getArchetypes() {
        return this.shortNames;
    }

    public boolean canEdit(DocumentAct act) {
        boolean result = false;
        if (TypeHelper.isA((IMObject)act, (String[])this.shortNames)) {
            if (act.getDocument() != null) {
                String ext = FilenameUtils.getExtension((String)act.getFileName());
                result = "odt".equalsIgnoreCase(ext) || "doc".equalsIgnoreCase(ext) || "docx".equalsIgnoreCase(ext) || "application/vnd.oasis.opendocument.text".equals(act.getMimeType()) || "application/msword".equals(act.getMimeType()) || "application/vnd.openxmlformats-officedocument.wordprocessingml.document".equals(act.getMimeType());
            } else {
                IMObjectBean bean = ArchetypeServiceHelper.getArchetypeService().getBean((IMObject)act);
                if (bean.hasNode("documentTemplate")) {
                    result = bean.getTargetRef("documentTemplate") != null;
                }
            }
        }
        return result;
    }

    public DocumentAct getDocumentAct(long id) {
        ArchetypeQuery query = new ArchetypeQuery(this.shortNames, false, true);
        query.add((IConstraint)Constraints.eq((String)"id", (Object)id));
        IMObjectQueryIterator iterator = new IMObjectQueryIterator(this.service, (IArchetypeQuery)query);
        return iterator.hasNext() ? (DocumentAct)iterator.next() : null;
    }

    private synchronized String[] getShortNames(String[] archetypes, IArchetypeService service) {
        HashSet<String> result = new HashSet<String>();
        for (String archetype : archetypes) {
            String[] shortNames = DescriptorHelper.getShortNames((String)archetype, (ArchetypeService)service);
            if (shortNames.length == 0) {
                log.error((Object)("'" + archetype + "' is not a valid archetype"));
                continue;
            }
            for (String shortName : shortNames) {
                Class clazz;
                ArchetypeDescriptor descriptor = service.getArchetypeDescriptor(shortName);
                if (descriptor == null || (clazz = descriptor.getClazz()) == null || !DocumentAct.class.isAssignableFrom(clazz)) continue;
                if (descriptor.getNodeDescriptor("document") != null) {
                    result.add(descriptor.getType().getShortName());
                    continue;
                }
                log.error((Object)("'" + shortName + "' is not a valid archetype"));
            }
        }
        return result.toArray(new String[0]);
    }
}

