/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.worklist;

import java.util.Date;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.workflow.ScheduleTestHelper;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.workspace.workflow.worklist.TaskQueryHelper;

public class TaskQueryHelperTestCase
extends ArchetypeServiceTest {
    private Party workList;

    @Before
    public void setUp() {
        this.workList = ScheduleTestHelper.createWorkList();
        IMObjectBean bean = this.getBean((IMObject)this.workList);
        bean.setValue("maxSlots", (Object)1);
        bean.save();
    }

    @Test
    public void testCompleteTask() {
        Date past = TestHelper.getDate((String)"2012-08-01");
        Date startDate = TestHelper.getDate((String)"2012-10-03");
        Act existingTask = this.createTask(past);
        this.checkTooManyTasks(false, existingTask);
        Act newTask = this.createTask(startDate);
        this.checkTooManyTasks(true, newTask);
        this.checkTooManyTasks(false, existingTask);
        existingTask.setStatus("COMPLETED");
        this.save((IMObject)existingTask);
        this.checkTooManyTasks(false, newTask);
    }

    @Test
    public void testCancelTask() {
        Date past = TestHelper.getDate((String)"2012-08-01");
        Date startDate = TestHelper.getDate((String)"2012-10-03");
        Act existingTask = this.createTask(past);
        this.checkTooManyTasks(false, existingTask);
        Act newTask = this.createTask(startDate);
        this.checkTooManyTasks(true, newTask);
        this.checkTooManyTasks(false, existingTask);
        existingTask.setStatus("CANCELLED");
        this.save((IMObject)existingTask);
        this.checkTooManyTasks(false, newTask);
    }

    @Test
    public void testOverlapStartTime() {
        Date startDate = TestHelper.getDate((String)"2012-08-01");
        Date existingStartDate = TestHelper.getDate((String)"2012-10-01");
        Act existingTask = this.createTask(existingStartDate);
        this.checkTooManyTasks(false, existingTask);
        Act newTask = this.createTask(startDate);
        this.checkTooManyTasks(true, newTask);
        newTask.setActivityEndTime(TestHelper.getDate((String)"2012-09-01"));
        this.checkTooManyTasks(false, newTask);
    }

    @Test
    public void testOverlapEndTime() {
        Date startDate = TestHelper.getDate((String)"2012-10-03");
        Date existingStart = TestHelper.getDate((String)"2012-10-01");
        Act existingTask = this.createTask(existingStart);
        this.checkTooManyTasks(false, existingTask);
        Act newTask = this.createTask(startDate);
        this.checkTooManyTasks(true, newTask);
        existingTask.setActivityEndTime(TestHelper.getDate((String)"2012-10-02"));
        this.save((IMObject)existingTask);
        this.checkTooManyTasks(false, newTask);
    }

    private Act createTask(Date startTime) {
        return ScheduleTestHelper.createTask((Date)startTime, null, (Entity)this.workList);
    }

    private void checkTooManyTasks(boolean tooMany, Act act) {
        Assert.assertEquals((Object)tooMany, (Object)TaskQueryHelper.tooManyTasks((Act)act));
        if (!tooMany) {
            this.save((IMObject)act);
        }
    }
}

