/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.worklist;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.stringparsers.IntegerStringParser;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.openvpms.archetype.rules.patient.PatientRules;
import org.openvpms.archetype.rules.user.UserRules;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.workflow.ScheduleTestHelper;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.Policies;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.IMObjectQueryIterator;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;

public class TaskGenerator {
    private final IArchetypeService service;
    private final PatientRules rules;
    private final List<User> clinicians = new ArrayList<User>();
    private IMObjectQueryIterator<Party> patientIterator;
    private Iterator<User> clinicianIterator;
    private static final String APPLICATION_CONTEXT = "applicationContext.xml";

    public TaskGenerator(IArchetypeService service, PatientRules rules, UserRules userRules) {
        this.service = service;
        this.rules = rules;
        ArchetypeQuery query = new ArchetypeQuery("security.user");
        IMObjectQueryIterator iterator = new IMObjectQueryIterator(service, (IArchetypeQuery)query);
        while (iterator.hasNext()) {
            User user = (User)iterator.next();
            if (!userRules.isClinician(user)) continue;
            this.clinicians.add(user);
        }
    }

    public void generate(String name, int days) {
        ArchetypeQuery query = new ArchetypeQuery("entity.organisationWorkListView");
        query.add((IConstraint)Constraints.eq((String)"name", (Object)name));
        query.add((IConstraint)Constraints.sort((String)"id"));
        query.setMaxResults(1);
        IMObjectQueryIterator iterator = new IMObjectQueryIterator(this.service, (IArchetypeQuery)query);
        Date startDate = DateRules.getToday();
        if (iterator.hasNext()) {
            Entity view = (Entity)iterator.next();
            IMObjectBean workListBean = this.service.getBean((IMObject)view);
            List workLists = workListBean.getTargets("workLists", Entity.class, Policies.orderBySequence());
            for (Entity workList : workLists) {
                System.out.println("Generating tasks for work list: " + workList.getName());
                Date date = startDate;
                for (int i = 0; i < days; ++i) {
                    if (i != 0) {
                        date = DateRules.getNextDate((Date)date);
                    }
                    for (int j = 0; j < 100; ++j) {
                        Patient patient = this.nextPatient();
                        Entity taskType = this.getTaskType(workList);
                        Act task = ScheduleTestHelper.createTask((Date)date, null, (Entity)workList, (Party)patient.customer, (Party)patient.patient, (Entity)taskType, (User)this.nextClinician());
                        task.setStatus("PENDING");
                        this.service.save((IMObject)task);
                    }
                }
            }
        } else {
            System.out.println("No view named " + name);
        }
    }

    public static void main(String[] args) throws Exception {
        JSAP parser = TaskGenerator.createParser();
        JSAPResult config = parser.parse(args);
        if (!config.success()) {
            TaskGenerator.displayUsage(parser);
        } else {
            String contextPath = config.getString("context");
            Object context = !new File(contextPath).exists() ? new ClassPathXmlApplicationContext(contextPath) : new FileSystemXmlApplicationContext(contextPath);
            TaskGenerator generator = new TaskGenerator((IArchetypeService)context.getBean(IArchetypeService.class), (PatientRules)context.getBean(PatientRules.class), (UserRules)context.getBean(UserRules.class));
            generator.generate(config.getString("view"), config.getInt("days"));
        }
    }

    private Entity getTaskType(Entity workList) {
        IMObjectBean bean = this.service.getBean((IMObject)workList);
        return (Entity)bean.getTarget("taskTypes", Entity.class);
    }

    private Patient nextPatient() {
        Patient result;
        boolean all = false;
        if (this.patientIterator == null || !this.patientIterator.hasNext()) {
            all = true;
            this.patientIterator = this.createPatientIterator();
        }
        if ((result = this.getNext(this.patientIterator)) == null && !all) {
            this.patientIterator = this.createPatientIterator();
            result = this.getNext(this.patientIterator);
        }
        if (result == null) {
            throw new IllegalStateException("No patients found");
        }
        return result;
    }

    private User nextClinician() {
        if (this.clinicianIterator == null || !this.clinicianIterator.hasNext()) {
            this.clinicianIterator = this.clinicians.iterator();
        }
        if (this.clinicianIterator.hasNext()) {
            return this.clinicianIterator.next();
        }
        return null;
    }

    private Patient getNext(IMObjectQueryIterator<Party> patients) {
        Patient result = null;
        while (patients.hasNext()) {
            Party patient = (Party)patients.next();
            Party customer = this.rules.getOwner(patient);
            if (customer == null || !customer.isActive()) continue;
            result = new Patient(patient, customer);
            break;
        }
        return result;
    }

    private IMObjectQueryIterator<Party> createPatientIterator() {
        ArchetypeQuery query = new ArchetypeQuery("party.patientpet");
        query.add((IConstraint)Constraints.sort((String)"id"));
        return new IMObjectQueryIterator(this.service, (IArchetypeQuery)query);
    }

    private static JSAP createParser() throws JSAPException {
        JSAP parser = new JSAP();
        parser.registerParameter(new FlaggedOption("context").setShortFlag('c').setLongFlag("context").setDefault(APPLICATION_CONTEXT).setHelp("Application context path"));
        parser.registerParameter(new FlaggedOption("view").setShortFlag('v').setLongFlag("view").setHelp("The work list view."));
        parser.registerParameter(new FlaggedOption("days").setShortFlag('d').setLongFlag("days").setStringParser((StringParser)IntegerStringParser.getParser()).setHelp("The no. of days to generate tasks for."));
        return parser;
    }

    private static void displayUsage(JSAP parser) {
        System.err.println();
        System.err.println("Usage: java " + TaskGenerator.class.getName());
        System.err.println("                " + parser.getUsage());
        System.err.println();
        System.err.println(parser.getHelp());
        System.exit(1);
    }

    private static class Patient {
        private final Party patient;
        private final Party customer;

        public Patient(Party patient, Party customer) {
            this.patient = patient;
            this.customer = customer;
        }
    }
}

