/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.roster;

import java.util.Date;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.archetype.test.builder.scheduling.TestRosterEventBuilder;
import org.openvpms.archetype.test.builder.scheduling.TestSchedulingFactory;
import org.openvpms.archetype.test.builder.user.TestUserFactory;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.ActIdentity;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.edit.EditorTestHelper;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.IMObjectEditorFactory;
import org.openvpms.web.component.im.edit.SaveHelper;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.test.AbstractAppTest;
import org.openvpms.web.workspace.workflow.roster.RosterEventEditor;
import org.springframework.beans.factory.annotation.Autowired;

public class RosterEventEditorTestCase
extends AbstractAppTest {
    @Autowired
    private IMObjectEditorFactory factory;
    @Autowired
    private TestPracticeFactory practiceFactory;
    @Autowired
    private TestSchedulingFactory schedulingFactory;
    @Autowired
    private TestUserFactory userFactory;

    @Test
    public void testStartEndTime() {
        Act event = (Act)this.schedulingFactory.newRosterEvent().build(false);
        DefaultLayoutContext context = new DefaultLayoutContext((Context)new LocalContext(), new HelpContext("foo", null));
        RosterEventEditor editor = new RosterEventEditor(event, null, (LayoutContext)context);
        Date date = DateRules.getToday();
        Assert.assertEquals((Object)this.getTime(date, 9), (Object)editor.getStartTime());
        Assert.assertEquals((Object)this.getTime(date, 17), (Object)editor.getEndTime());
        editor.setStartTime(this.getTime(date, 8));
        Assert.assertEquals((Object)this.getTime(date, 17), (Object)editor.getEndTime());
        editor.setEndTime(this.getTime(date, 12));
        Assert.assertEquals((Object)this.getTime(date, 8), (Object)editor.getStartTime());
        editor.setStartTime(this.getTime(date, 12));
        Assert.assertEquals((Object)this.getTime(date, 16), (Object)editor.getEndTime());
    }

    @Test
    public void testInvalidStartEndTime() {
        Party location = this.practiceFactory.createLocation();
        Entity rosterArea = this.schedulingFactory.createRosterArea(location);
        Act event1 = (Act)((TestRosterEventBuilder)((TestRosterEventBuilder)((TestRosterEventBuilder)this.schedulingFactory.newRosterEvent().startTime(DateRules.getToday())).endTime(DateRules.getToday())).location(location).schedule(rosterArea)).build(false);
        this.checkInvalid(event1, "Start Time cannot be the same as End Time");
        Act event2 = (Act)((TestRosterEventBuilder)((TestRosterEventBuilder)((TestRosterEventBuilder)this.schedulingFactory.newRosterEvent().startTime(DateRules.getTomorrow())).endTime(DateRules.getToday())).location(location).schedule(rosterArea)).build(false);
        this.checkInvalid(event2, "Start Time is greater than End Time");
    }

    @Test
    public void testNewInstance() {
        Act event = (Act)this.schedulingFactory.newRosterEvent().build(false);
        DefaultLayoutContext context = new DefaultLayoutContext((Context)new LocalContext(), new HelpContext("foo", null));
        RosterEventEditor editor = new RosterEventEditor(event, null, (LayoutContext)context);
        IMObjectEditor newInstance = editor.newInstance();
        Assert.assertTrue((boolean)(newInstance instanceof RosterEventEditor));
    }

    @Test
    public void testFactory() {
        Act event = (Act)this.create("act.rosterEvent", Act.class);
        IMObjectEditor editor = this.factory.create((IMObject)event, (LayoutContext)new DefaultLayoutContext((Context)new LocalContext(), new HelpContext("foo", null)));
        Assert.assertTrue((boolean)(editor instanceof RosterEventEditor));
    }

    @Test
    public void testSyncStatus() {
        Party location = this.practiceFactory.createLocation();
        User user = this.userFactory.createUser();
        ActIdentity id1 = this.schedulingFactory.createSyncId();
        ActIdentity id2 = this.schedulingFactory.createSyncId();
        Act event = (Act)((TestRosterEventBuilder)((TestRosterEventBuilder)this.schedulingFactory.newRosterEvent().location(location).schedule(this.schedulingFactory.createRosterArea(location))).addIdentities(new ActIdentity[]{id1, id2})).build(false);
        DefaultLayoutContext context = new DefaultLayoutContext((Context)new LocalContext(), new HelpContext("foo", null));
        RosterEventEditor editor = new RosterEventEditor(event, null, (LayoutContext)context);
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor));
        this.checkStatus(id1, "PENDING");
        this.checkStatus(id2, "PENDING");
        this.setStatus(id1, "SYNC");
        this.setStatus(id2, "ERROR");
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor));
        this.checkStatus(id1, "SYNC");
        this.checkStatus(id2, "ERROR");
        editor.setUser(user);
        this.checkStatus(id1, "PENDING");
        this.checkStatus(id2, "PENDING");
    }

    private void checkInvalid(Act event, String expected) {
        DefaultLayoutContext context = new DefaultLayoutContext((Context)new LocalContext(), new HelpContext("foo", null));
        RosterEventEditor editor = new RosterEventEditor(event, null, (LayoutContext)context);
        EditorTestHelper.assertInvalid((Modifiable)editor, (String)expected);
    }

    private Date getTime(Date date, int hour) {
        return DateRules.getDate((Date)date, (int)hour, (DateUnits)DateUnits.HOURS);
    }

    private void checkStatus(ActIdentity identity, String status) {
        IMObjectBean bean = this.getBean((IMObject)identity);
        Assert.assertEquals((Object)status, (Object)bean.getString("status"));
    }

    private void setStatus(ActIdentity identity, String status) {
        this.schedulingFactory.updateSyncId(identity).status(status).build();
    }
}

