/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.order;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.stringparsers.IntegerStringParser;
import java.io.File;
import java.math.BigDecimal;
import org.openvpms.archetype.rules.patient.PatientRules;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.IMObjectQueryIterator;
import org.openvpms.web.workspace.customer.order.PharmacyTestHelper;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;

public class CustomerOrderGenerator {
    private final IArchetypeService service;
    private final PatientRules rules;
    private IMObjectQueryIterator<Party> patientIterator;
    private IMObjectQueryIterator<Product> productIterator;
    private static final String[] PRODUCTS = new String[]{"product.medication", "product.merchandise", "product.service"};
    private static final String APPLICATION_CONTEXT = "applicationContext.xml";

    public CustomerOrderGenerator(IArchetypeService service, PatientRules rules) {
        this.service = service;
        this.rules = rules;
    }

    public void generate(int count) {
        for (int i = 0; i < count; ++i) {
            Patient patient = this.nextPatient();
            Product product = this.nextProduct();
            PharmacyTestHelper.createOrder(patient.customer, patient.patient, product, BigDecimal.ONE, null);
        }
    }

    public static void main(String[] args) throws Exception {
        JSAP parser = CustomerOrderGenerator.createParser();
        JSAPResult config = parser.parse(args);
        if (!config.success()) {
            CustomerOrderGenerator.displayUsage(parser);
        } else {
            String contextPath = config.getString("context");
            Object context = !new File(contextPath).exists() ? new ClassPathXmlApplicationContext(contextPath) : new FileSystemXmlApplicationContext(contextPath);
            CustomerOrderGenerator generator = new CustomerOrderGenerator((IArchetypeService)context.getBean(IArchetypeService.class), (PatientRules)context.getBean(PatientRules.class));
            generator.generate(config.getInt("count"));
        }
    }

    private Patient nextPatient() {
        Patient result;
        boolean all = false;
        if (this.patientIterator == null || !this.patientIterator.hasNext()) {
            all = true;
            this.patientIterator = this.createPatientIterator();
        }
        if ((result = this.getNext(this.patientIterator)) == null && !all) {
            this.patientIterator = this.createPatientIterator();
            result = this.getNext(this.patientIterator);
        }
        if (result == null) {
            throw new IllegalStateException("No patients found");
        }
        return result;
    }

    private Product nextProduct() {
        if (this.productIterator == null || !this.productIterator.hasNext()) {
            this.productIterator = this.createProductIterator();
            if (!this.productIterator.hasNext()) {
                throw new IllegalStateException("No products found");
            }
        }
        return (Product)this.productIterator.next();
    }

    private Patient getNext(IMObjectQueryIterator<Party> patients) {
        Patient result = null;
        while (patients.hasNext()) {
            Party patient = (Party)patients.next();
            Party customer = this.rules.getOwner(patient);
            if (customer == null || !customer.isActive()) continue;
            result = new Patient(patient, customer);
            break;
        }
        return result;
    }

    private IMObjectQueryIterator<Party> createPatientIterator() {
        ArchetypeQuery query = new ArchetypeQuery("party.patientpet");
        query.add((IConstraint)Constraints.sort((String)"id"));
        return new IMObjectQueryIterator(this.service, (IArchetypeQuery)query);
    }

    private IMObjectQueryIterator<Product> createProductIterator() {
        ArchetypeQuery query = new ArchetypeQuery(PRODUCTS, true, true);
        query.add((IConstraint)Constraints.leftJoin((String)"species")).add((IConstraint)Constraints.isNull((String)"species.code"));
        query.add((IConstraint)Constraints.sort((String)"id"));
        return new IMObjectQueryIterator(this.service, (IArchetypeQuery)query);
    }

    private static JSAP createParser() throws JSAPException {
        JSAP parser = new JSAP();
        parser.registerParameter(new FlaggedOption("context").setLongFlag("context").setDefault(APPLICATION_CONTEXT).setHelp("Application context path"));
        parser.registerParameter(new FlaggedOption("count").setShortFlag('c').setLongFlag("count").setStringParser((StringParser)IntegerStringParser.getParser()).setHelp("The no. of orders to generate."));
        return parser;
    }

    private static void displayUsage(JSAP parser) {
        System.err.println();
        System.err.println("Usage: java " + CustomerOrderGenerator.class.getName());
        System.err.println("                " + parser.getUsage());
        System.err.println();
        System.err.println(parser.getHelp());
        System.exit(1);
    }

    private static class Patient {
        private final Party patient;
        private final Party customer;

        public Patient(Party patient, Party customer) {
            this.patient = patient;
            this.customer = customer;
        }
    }
}

