/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.consult;

import java.math.BigDecimal;
import java.util.Date;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.test.builder.patient.TestVisitBuilder;
import org.openvpms.archetype.test.builder.scheduling.TestAppointmentBuilder;
import org.openvpms.archetype.test.builder.scheduling.TestSchedulingFactory;
import org.openvpms.archetype.test.builder.scheduling.TestTaskBuilder;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.util.UserHelper;
import org.openvpms.web.echo.dialog.PopupDialog;
import org.openvpms.web.test.EchoTestHelper;
import org.openvpms.web.workspace.customer.charge.CustomerChargeActItemEditor;
import org.openvpms.web.workspace.patient.visit.VisitEditorDialog;
import org.openvpms.web.workspace.workflow.AbstractWorkflowTest;
import org.openvpms.web.workspace.workflow.checkin.CheckInWorkflowRunner;
import org.openvpms.web.workspace.workflow.consult.ConsultWorkflowRunner;
import org.springframework.beans.factory.annotation.Autowired;

public class ConsultWorkflowTestCase
extends AbstractWorkflowTest {
    @Autowired
    private TestSchedulingFactory schedulingFactory;
    private Party customer;
    private Party patient;
    private User clinician;
    private Party location;
    private Context context;
    private Entity workList;
    private Entity taskType;

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.customer = this.customerFactory.createCustomer();
        this.patient = this.patientFactory.createPatient(this.customer);
        this.clinician = this.userFactory.createClinician();
        this.context = new LocalContext();
        this.location = this.practiceFactory.createLocation();
        this.context.setLocation(this.location);
        this.context.setUser(this.userFactory.createUser());
        this.taskType = this.schedulingFactory.createTaskType();
        this.workList = (Entity)this.schedulingFactory.newWorkList().addTaskType(this.taskType, 1, true).build();
        Entity workListView = this.schedulingFactory.createWorkListView(new Entity[]{this.workList});
        this.practiceFactory.updateLocation(this.location).workListViews(new Entity[]{workListView}).build();
    }

    @Test
    public void testConsultForAppointment() {
        Date date = new Date();
        Act appointment = this.createAppointment(date);
        Act previousEvent = (Act)((TestVisitBuilder)((TestVisitBuilder)((TestVisitBuilder)((TestVisitBuilder)this.patientFactory.newVisit().startTime(DateRules.getYesterday())).patient(this.patient)).clinician(this.clinician)).status("COMPLETED")).build();
        CheckInWorkflowRunner runner = new CheckInWorkflowRunner(appointment, this.getPractice(), this.context);
        Act event = runner.runWorkflow(this.patient, this.customer, this.workList, date, this.clinician, this.location);
        Assert.assertNotEquals((Object)previousEvent, (Object)event);
        this.checkConsultWorkflow((Act)this.get((IMObject)appointment), event, this.clinician);
    }

    @Test
    public void testConsultForTask() {
        Date date = new Date();
        Act previousEvent = (Act)((TestVisitBuilder)((TestVisitBuilder)((TestVisitBuilder)((TestVisitBuilder)this.patientFactory.newVisit().startTime(DateRules.getYesterday())).patient(this.patient)).clinician(this.clinician)).status("COMPLETED")).build();
        Act appointment = this.createAppointment(date);
        CheckInWorkflowRunner runner = new CheckInWorkflowRunner(appointment, this.getPractice(), this.context);
        Act event = runner.runWorkflow(this.patient, this.customer, this.workList, date, this.clinician, this.location);
        Assert.assertNotEquals((Object)previousEvent, (Object)event);
        Act task = runner.checkTask(this.workList, this.customer, this.patient, this.clinician, "PENDING", "Reason X");
        this.checkConsultWorkflow(task, event, this.clinician);
    }

    @Test
    public void testCancelInvoiceByUserCloseNoSave() {
        this.checkCancelInvoice(false, true);
    }

    @Test
    public void testCancelInvoiceByUserCloseAfterSave() {
        this.checkCancelInvoice(true, true);
    }

    @Test
    public void testCancelInvoiceByCancelButtonNoSave() {
        this.checkCancelInvoice(false, false);
    }

    @Test
    public void testCompleteInvoiceStatusForAppointment() {
        Act appointment = this.createAppointment();
        this.checkCompleteInvoiceStatus(appointment);
    }

    @Test
    public void testCompleteInvoiceStatusForTask() {
        Act task = this.createTask();
        this.checkCompleteInvoiceStatus(task);
    }

    @Test
    public void testInProgressInvoiceStatusForBilledAppointment() {
        Act appointment = this.createAppointment();
        this.checkChangeCompleteInvoiceToInProgress(appointment, "BILLED");
    }

    @Test
    public void testInProgressInvoiceStatusForCompletedAppointment() {
        Act appointment = this.createAppointment();
        this.checkChangeCompleteInvoiceToInProgress(appointment, "COMPLETED");
    }

    @Test
    public void testInProgressInvoiceStatusForBilledTask() {
        Act task = this.createTask();
        this.checkChangeCompleteInvoiceToInProgress(task, "BILLED");
    }

    @Test
    public void testInProgressInvoiceStatusForCompletedTask() {
        Act task = this.createTask();
        this.checkChangeCompleteInvoiceToInProgress(task, "COMPLETED");
    }

    @Test
    public void testCancelInvoiceByCancelButtonAfterSave() {
        this.checkCancelInvoice(true, false);
    }

    @Test
    public void testUseLoggedInClinicianForClinician() {
        this.checkUseLoggedInClinician(true, this.clinician, this.userFactory.createClinician(), this.clinician);
    }

    @Test
    public void testUseLoggedInClinicianForNonClinician() {
        User user = this.userFactory.createUser();
        this.checkUseLoggedInClinician(true, user, this.clinician, this.clinician);
    }

    @Test
    public void testUseLoggedInClinicianDisabledForClinician() {
        User clinician2 = this.userFactory.createClinician();
        this.checkUseLoggedInClinician(false, this.clinician, clinician2, clinician2);
    }

    @Test
    public void testUseLoggedInClinicianDisabledForNonClinician() {
        User user = this.userFactory.createUser();
        this.checkUseLoggedInClinician(false, user, this.clinician, this.clinician);
    }

    @Test
    public void testConsultFromBackDatedAppointment() {
        Date arrivalTime;
        Act appointment = this.createAppointment(DateRules.getYesterday());
        CheckInWorkflowRunner runner = new CheckInWorkflowRunner(appointment, this.getPractice(), this.context);
        Act event = runner.runWorkflow(this.patient, this.customer, this.workList, arrivalTime = new Date(), this.clinician, this.location);
        Assert.assertTrue((DateRules.compareTo((Date)event.getActivityStartTime(), (Date)arrivalTime, (boolean)true) >= 0 ? 1 : 0) != 0);
        this.checkConsultWorkflow((Act)this.get((IMObject)appointment), event, this.clinician);
    }

    @Test
    public void testTaskChangedByAnotherUser() {
        Act task = this.createTask();
        ConsultWorkflowRunner workflow = new ConsultWorkflowRunner(task, this.getPractice(), this.context);
        task = (Act)this.get((IMObject)task);
        task.setDescription("set to force update");
        this.save((IMObject)task);
        workflow.start();
        workflow.checkClinician(this.clinician);
        VisitEditorDialog dialog = workflow.editVisit();
        EchoTestHelper.fireDialogButton((PopupDialog)dialog, (String)"ok");
        workflow.checkComplete("IN_PROGRESS");
        workflow.checkContext(this.context, this.customer, this.patient, this.clinician);
    }

    protected Act createAppointment(Party customer, Party patient, User clinician, Party location) {
        return this.createAppointment(new Date(), customer, patient, clinician, location);
    }

    protected Act createAppointment(Date startTime, Party customer, Party patient, User clinician, Party location) {
        return (Act)((TestAppointmentBuilder)((TestAppointmentBuilder)this.newAppointment(customer, patient, clinician, location).startTime(startTime)).status("CHECKED_IN")).build();
    }

    private void checkUseLoggedInClinician(boolean enabled, User user, User appointmentClinician, User expectedClinician) {
        this.practiceFactory.updatePractice(this.getPractice()).useLoggedInClinician(enabled).build();
        this.context.setUser(user);
        this.context.setClinician(this.clinician);
        Date date = new Date();
        Act appointment = this.createAppointment(date, this.customer, this.patient, appointmentClinician, this.location);
        Act previousEvent = (Act)((TestVisitBuilder)((TestVisitBuilder)((TestVisitBuilder)((TestVisitBuilder)this.patientFactory.newVisit().startTime(DateRules.getYesterday())).patient(this.patient)).clinician(appointmentClinician)).status("COMPLETED")).build();
        CheckInWorkflowRunner runner = new CheckInWorkflowRunner(appointment, this.getPractice(), this.context);
        Act event = runner.runWorkflow(this.patient, this.customer, this.workList, date, expectedClinician, this.location);
        Assert.assertNotEquals((Object)previousEvent, (Object)event);
        this.checkConsultWorkflow((Act)this.get((IMObject)appointment), event, expectedClinician);
    }

    private void checkConsultWorkflow(Act act, Act event, User clinician) {
        ConsultWorkflowRunner workflow = new ConsultWorkflowRunner(act, this.getPractice(), this.context);
        workflow.start();
        if (!UserHelper.useLoggedInClinician((Context)this.context)) {
            workflow.checkClinician(clinician);
        }
        VisitEditorDialog dialog = workflow.editVisit();
        Assert.assertEquals((Object)event, (Object)dialog.getEditor().getEvent());
        workflow.addNote();
        CustomerChargeActItemEditor itemEditor = workflow.addVisitInvoiceItem(this.patient, new BigDecimal(20));
        Assert.assertEquals((Object)clinician, (Object)itemEditor.getClinician());
        EchoTestHelper.fireDialogButton((PopupDialog)dialog, (String)"ok");
        workflow.checkComplete("IN_PROGRESS");
        workflow.checkContext(this.context, this.customer, this.patient, clinician);
    }

    private void checkCancelInvoice(boolean save, boolean userClose) {
        Act appointment = this.createAppointment();
        ConsultWorkflowRunner workflow = new ConsultWorkflowRunner(appointment, this.getPractice(), this.context);
        workflow.start();
        workflow.checkClinician(this.clinician);
        VisitEditorDialog dialog = workflow.editVisit();
        BigDecimal fixedPrice = new BigDecimal("18.18");
        workflow.addVisitInvoiceItem(this.patient, fixedPrice);
        if (save) {
            dialog.getEditor().selectCharges();
            EchoTestHelper.fireDialogButton((PopupDialog)dialog, (String)"apply");
        }
        workflow.addVisitInvoiceItem(this.patient, fixedPrice);
        EchoTestHelper.cancelDialog((PopupDialog)dialog, (boolean)userClose);
        if (save) {
            BigDecimal fixedPriceIncTax = BigDecimal.valueOf(20L);
            workflow.checkInvoice("IN_PROGRESS", fixedPriceIncTax, this.clinician);
        } else {
            FinancialAct invoice = workflow.getInvoice();
            Assert.assertNotNull((Object)invoice);
            Assert.assertTrue((boolean)invoice.isNew());
        }
        workflow.checkComplete("IN_PROGRESS");
        workflow.checkContext(this.context, null, null, null);
    }

    private void checkCompleteInvoiceStatus(Act act) {
        ConsultWorkflowRunner workflow = new ConsultWorkflowRunner(act, this.getPractice(), this.context);
        workflow.start();
        workflow.checkClinician(this.clinician);
        VisitEditorDialog dialog = workflow.editVisit();
        workflow.addVisitInvoiceItem(this.patient, new BigDecimal(20));
        dialog.getEditor().getChargeEditor().setStatus("COMPLETED");
        EchoTestHelper.fireDialogButton((PopupDialog)dialog, (String)"ok");
        workflow.checkComplete("BILLED");
        workflow.checkContext(this.context, this.customer, this.patient, this.clinician);
    }

    private void checkChangeCompleteInvoiceToInProgress(Act act, String expectedStatus) {
        this.checkCompleteInvoiceStatus(act);
        if (!act.getStatus().equals(expectedStatus)) {
            act.setStatus(expectedStatus);
            this.save((IMObject)act);
        }
        ConsultWorkflowRunner workflow = new ConsultWorkflowRunner(act, this.getPractice(), this.context);
        workflow.start();
        workflow.checkClinician(this.clinician);
        VisitEditorDialog dialog = workflow.editVisit();
        workflow.addVisitInvoiceItem(this.patient, new BigDecimal(20));
        dialog.getEditor().getChargeEditor().setStatus("IN_PROGRESS");
        EchoTestHelper.fireDialogButton((PopupDialog)dialog, (String)"ok");
        Act invoice = (Act)this.get((IMObject)workflow.getInvoice());
        Assert.assertNotNull((Object)invoice);
        Assert.assertEquals((Object)"IN_PROGRESS", (Object)invoice.getStatus());
        workflow.checkComplete(expectedStatus);
        workflow.checkContext(this.context, this.customer, this.patient, this.clinician);
    }

    private Act createAppointment() {
        return this.createAppointment(this.customer, this.patient, this.clinician, this.location);
    }

    private Act createAppointment(Date startTime) {
        return this.createAppointment(startTime, this.customer, this.patient, this.clinician, this.location);
    }

    private Act createTask() {
        return (Act)((TestTaskBuilder)((TestTaskBuilder)((TestTaskBuilder)((TestTaskBuilder)this.schedulingFactory.newTask().startTime(new Date())).taskType(this.taskType).customer(this.customer)).patient(this.patient)).clinician(this.clinician)).workList(this.workList).build();
    }
}

