/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.consult;

import org.junit.Assert;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.echo.dialog.PopupDialog;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.test.EchoTestHelper;
import org.openvpms.web.workspace.patient.visit.VisitEditor;
import org.openvpms.web.workspace.patient.visit.VisitEditorDialog;
import org.openvpms.web.workspace.workflow.EditVisitTask;
import org.openvpms.web.workspace.workflow.FinancialWorkflowRunner;
import org.openvpms.web.workspace.workflow.TestEditVisitTask;
import org.openvpms.web.workspace.workflow.TestVisitCRUDWindow;
import org.openvpms.web.workspace.workflow.consult.ClinicianSelectionDialog;
import org.openvpms.web.workspace.workflow.consult.ConsultWorkflow;

class ConsultWorkflowRunner
extends FinancialWorkflowRunner<TestWorkflow> {
    private Act act;

    public ConsultWorkflowRunner(Act act, Party practice, Context context) {
        super(practice);
        context.setPractice(practice);
        this.act = act;
        this.setWorkflow(new TestWorkflow(act, context));
    }

    public void addNote() {
        TestEditVisitTask task = (TestEditVisitTask)this.getTask();
        VisitEditorDialog dialog = task.getVisitDialog();
        VisitEditor visitEditor = dialog.getEditor();
        TestVisitCRUDWindow window = (TestVisitCRUDWindow)visitEditor.getHistoryWindow();
        Assert.assertNotNull((Object)((Object)window));
        window.addNote();
    }

    public void checkComplete(String status) {
        Assert.assertNull((Object)this.getTask());
        this.act = this.get(this.act);
        Assert.assertNotNull((Object)this.act);
        Assert.assertEquals((Object)status, (Object)this.act.getStatus());
    }

    public void checkContext(Context context, Party customer, Party patient, User clinician) {
        Assert.assertEquals((Object)customer, (Object)context.getCustomer());
        Assert.assertEquals((Object)patient, (Object)context.getPatient());
        Assert.assertEquals((Object)clinician, (Object)context.getClinician());
    }

    public ClinicianSelectionDialog checkClinician(User clinician) {
        ClinicianSelectionDialog dialog = (ClinicianSelectionDialog)EchoTestHelper.getWindowPane(ClinicianSelectionDialog.class);
        Assert.assertEquals((Object)clinician, (Object)dialog.getClinician());
        EchoTestHelper.fireDialogButton((PopupDialog)dialog, (String)"ok");
        return dialog;
    }

    protected static class TestWorkflow
    extends ConsultWorkflow {
        public TestWorkflow(Act act, Context context) {
            super(act, context, new HelpContext("foo", null));
        }

        protected EditVisitTask createEditVisitTask() {
            return new TestEditVisitTask();
        }
    }
}

