/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.checkout;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.patient.PatientRules;
import org.openvpms.archetype.rules.patient.PatientTestHelper;
import org.openvpms.archetype.rules.workflow.AppointmentRules;
import org.openvpms.archetype.rules.workflow.ScheduleTestHelper;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.math.WeightUnits;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.web.workspace.workflow.checkout.BoardingTestHelper;
import org.openvpms.web.workspace.workflow.checkout.Visit;
import org.openvpms.web.workspace.workflow.checkout.Visits;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;

@ContextConfiguration(value={"/applicationContext.xml"})
public class VisitsTestCase
extends ArchetypeServiceTest {
    @Autowired
    private AppointmentRules appointmentRules;
    @Autowired
    private PatientRules patientRules;
    private Visits visits;
    private Party customer;
    private Party patient1;
    private Party patient2;
    private Party location;
    private Entity cageType;

    @Before
    public void setUp() {
        this.location = TestHelper.createLocation();
        this.customer = TestHelper.createCustomer();
        this.patient1 = TestHelper.createPatient((Party)this.customer);
        this.patient2 = TestHelper.createPatient((Party)this.customer);
        this.visits = new Visits(this.customer, this.appointmentRules, this.patientRules, this.getArchetypeService());
        Product firstPetProductDay = TestHelper.createProduct((String)"product.service", null);
        Product firstPetProductNight = TestHelper.createProduct((String)"product.service", null);
        Product secondPetProductDay = TestHelper.createProduct((String)"product.service", null);
        Product secondPetProductNight = TestHelper.createProduct((String)"product.service", null);
        this.cageType = ScheduleTestHelper.createCageType((String)"Z Test Cage", (Product)firstPetProductDay, (Product)firstPetProductNight, (Product)secondPetProductDay, (Product)secondPetProductNight);
    }

    @Test
    public void testRateDoubleBookingOnSameDay() {
        Party patient3 = TestHelper.createPatient((Party)this.customer);
        Party schedule = ScheduleTestHelper.createSchedule((Party)this.location, (Entity)this.cageType);
        Visit visit1 = this.createVisit("2016-03-24 10:00:00", "2016-03-24 17:00:00", (Entity)schedule, this.customer, this.patient1);
        Visit visit2 = this.createVisit("2016-03-24 10:00:00", "2016-03-24 17:00:00", (Entity)schedule, this.customer, this.patient2);
        Visit visit3 = this.createVisit("2016-03-24 10:00:00", "2016-03-24 17:00:00", (Entity)schedule, this.customer, patient3);
        visit1.setFirstPet(false);
        visit2.setFirstPet(true);
        visit3.setFirstPet(true);
        this.visits.rate(Arrays.asList(visit1, visit2, visit3), new Date());
        Assert.assertTrue((boolean)visit1.isFirstPet());
        Assert.assertFalse((boolean)visit2.isFirstPet());
        Assert.assertFalse((boolean)visit3.isFirstPet());
        PatientTestHelper.createWeight((Party)this.patient1, (BigDecimal)BigDecimal.ONE, (WeightUnits)WeightUnits.KILOGRAMS);
        PatientTestHelper.createWeight((Party)this.patient2, (BigDecimal)BigDecimal.valueOf(2L), (WeightUnits)WeightUnits.KILOGRAMS);
        PatientTestHelper.createWeight((Party)patient3, (BigDecimal)BigDecimal.TEN, (WeightUnits)WeightUnits.KILOGRAMS);
        visit1 = this.refresh(visit1);
        visit2 = this.refresh(visit2);
        visit3 = this.refresh(visit3);
        this.visits.rate(Arrays.asList(visit1, visit2, visit3), new Date());
        Assert.assertFalse((boolean)visit1.isFirstPet());
        Assert.assertFalse((boolean)visit2.isFirstPet());
        Assert.assertTrue((boolean)visit3.isFirstPet());
    }

    @Test
    public void testRateDoubleBookingOnSameDayDifferentTimes() {
        Party patient3 = TestHelper.createPatient();
        Party schedule = ScheduleTestHelper.createSchedule((Party)this.location, (Entity)this.cageType);
        Visit visit1 = this.createVisit("2016-03-24 09:00:00", "2016-03-24 15:00:00", (Entity)schedule, this.customer, this.patient1);
        Visit visit2 = this.createVisit("2016-03-24 10:00:00", "2016-03-25 00:00:00", (Entity)schedule, this.customer, this.patient2);
        Visit visit3 = this.createVisit("2016-03-24 11:00:00", "2016-03-24 17:00:00", (Entity)schedule, this.customer, patient3);
        visit1.setFirstPet(false);
        visit2.setFirstPet(true);
        visit3.setFirstPet(true);
        this.visits.rate(Arrays.asList(visit1, visit2, visit3), new Date());
        Assert.assertTrue((boolean)visit1.isFirstPet());
        Assert.assertFalse((boolean)visit2.isFirstPet());
        Assert.assertFalse((boolean)visit3.isFirstPet());
    }

    @Test
    public void testRateDoubleBookingOnDifferentDaySameSchedule() {
        Party schedule = ScheduleTestHelper.createSchedule((Party)this.location, (Entity)this.cageType);
        Visit visit1 = this.createVisit("2016-03-24 09:00:00", "2016-03-25 15:00:00", (Entity)schedule, this.customer, this.patient1);
        Visit visit2 = this.createVisit("2016-03-25 10:00:00", "2016-03-26 16:00:00", (Entity)schedule, this.customer, this.patient2);
        visit1.setFirstPet(true);
        visit2.setFirstPet(true);
        this.visits.rate(Arrays.asList(visit1, visit2), new Date());
        Assert.assertTrue((boolean)visit1.isFirstPet());
        Assert.assertTrue((boolean)visit2.isFirstPet());
    }

    @Test
    public void testRateDoubleBookingForCompletedAppointment() {
        Party patient3 = TestHelper.createPatient();
        Party schedule = ScheduleTestHelper.createSchedule((Party)this.location, (Entity)this.cageType);
        Visit visit1 = this.createVisit("2016-03-24 09:00:00", "2016-03-24 15:00:00", (Entity)schedule, this.customer, this.patient1);
        Visit visit2 = this.createVisit("2016-03-24 10:00:00", "2016-03-24 16:00:00", (Entity)schedule, this.customer, this.patient2);
        Visit visit3 = this.createVisit("2016-03-24 10:00:00", "2016-03-25 00:00:00", (Entity)schedule, this.customer, patient3);
        Assert.assertFalse((boolean)visit1.isCharged());
        Assert.assertFalse((boolean)visit2.isCharged());
        Assert.assertFalse((boolean)visit3.isCharged());
        visit1.setFirstPet(true);
        visit1.setCharged(true);
        visit1.save();
        visit1 = this.visits.create(visit1.getEvent(), visit1.getAppointment());
        Assert.assertTrue((boolean)visit1.isFirstPet());
        Assert.assertTrue((boolean)visit1.isCharged());
        this.visits.rate(Collections.singletonList(visit2), new Date());
        Assert.assertFalse((boolean)visit2.isFirstPet());
        this.visits.rate(Collections.singletonList(visit3), new Date());
        Assert.assertFalse((boolean)visit3.isFirstPet());
    }

    private Visit createVisit(String startTime, String endTime, Entity schedule, Party customer, Party patient) {
        return BoardingTestHelper.createVisit(startTime, endTime, schedule, customer, patient, this.visits);
    }

    private Visit refresh(Visit visit) {
        return this.visits.create(visit.getEvent(), visit.getAppointment());
    }
}

