/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.checkin;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.workflow.ScheduleTestHelper;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.archetype.test.builder.doc.TestDocumentFactory;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.im.query.QueryHelper;
import org.openvpms.web.component.im.query.QueryTestHelper;
import org.openvpms.web.test.AbstractAppTest;
import org.openvpms.web.workspace.workflow.checkin.ScheduleDocumentTemplateQuery;
import org.springframework.beans.factory.annotation.Autowired;

public class ScheduleDocumentTemplateQueryTestCase
extends AbstractAppTest {
    @Autowired
    private TestDocumentFactory documentFactory;

    @Test
    public void testUseAllTemplatesFalseWithNoTemplates() {
        Party location = TestHelper.createLocation();
        Entity schedule1 = this.createSchedule(location, false, new Entity[0]);
        Entity workList1 = this.createWorkList(false, new Entity[0]);
        this.checkQuery(schedule1, workList1, new Entity[0]);
    }

    @Test
    public void testUseAllTemplatesTrueWithNoTemplates() {
        Entity template1 = this.createTemplate();
        Party location = TestHelper.createLocation();
        Entity schedule1 = this.createSchedule(location, true, new Entity[0]);
        Entity workList1 = this.createWorkList(true, new Entity[0]);
        ScheduleDocumentTemplateQuery query = new ScheduleDocumentTemplateQuery(schedule1, workList1);
        QueryTestHelper.checkSelects((boolean)true, (Query)query, (IMObject)template1);
    }

    @Test
    public void testUseAllTemplatesTrueWithTemplates() {
        Entity template1 = this.createTemplate();
        Entity template2 = this.createTemplate();
        Entity template3 = this.createTemplate();
        Party location = TestHelper.createLocation();
        Entity schedule1 = this.createSchedule(location, true, template1);
        Entity workList1 = this.createWorkList(true, template2);
        ScheduleDocumentTemplateQuery query = new ScheduleDocumentTemplateQuery(schedule1, workList1);
        QueryTestHelper.checkSelects((boolean)true, (Query)query, (IMObject)template1);
        QueryTestHelper.checkSelects((boolean)true, (Query)query, (IMObject)template2);
        QueryTestHelper.checkSelects((boolean)true, (Query)query, (IMObject)template3);
    }

    @Test
    public void testUseAllTemplatesFalseWithTemplates() {
        Party location = TestHelper.createLocation();
        Entity template1 = this.createTemplate();
        Entity template2 = this.createTemplate();
        Entity template3 = this.createTemplate();
        Entity template4 = this.createTemplate();
        Entity schedule1 = this.createSchedule(location, false, template1);
        Entity schedule2 = this.createSchedule(location, false, template2);
        Entity workList1 = this.createWorkList(false, template3);
        Entity workList2 = this.createWorkList(false, template4);
        this.checkQuery(schedule1, workList1, template1, template3);
        this.checkQuery(schedule2, workList2, template2, template4);
    }

    @Test
    public void testUseAllTemplatesFalseWithDuplicateTemplates() {
        Party location = TestHelper.createLocation();
        Entity template1 = this.createTemplate();
        Entity template2 = this.createTemplate();
        Entity schedule1 = this.createSchedule(location, false, template1, template2);
        Entity workList1 = this.createWorkList(false, template1, template2);
        this.checkQuery(schedule1, workList1, template1, template2);
    }

    @Test
    public void testUseAllTemplatesTrueWithScheduleButNotWorkList() {
        Party location = TestHelper.createLocation();
        Entity template1 = this.createTemplate();
        Entity template2 = this.createTemplate();
        Entity template3 = this.createTemplate();
        Entity template4 = this.createTemplate();
        Entity schedule1 = this.createSchedule(location, true, new Entity[0]);
        Entity workList1 = this.createWorkList(false, template3);
        ScheduleDocumentTemplateQuery query = new ScheduleDocumentTemplateQuery(schedule1, workList1);
        QueryTestHelper.checkSelects((boolean)true, (Query)query, (IMObject)template1);
        QueryTestHelper.checkSelects((boolean)true, (Query)query, (IMObject)template2);
        QueryTestHelper.checkSelects((boolean)true, (Query)query, (IMObject)template3);
        QueryTestHelper.checkSelects((boolean)true, (Query)query, (IMObject)template4);
    }

    @Test
    public void testUseAllTemplatesTrueWithWorKListButNotSchedule() {
        Party location = TestHelper.createLocation();
        Entity template1 = this.createTemplate();
        Entity template2 = this.createTemplate();
        Entity template3 = this.createTemplate();
        Entity template4 = this.createTemplate();
        Entity schedule1 = this.createSchedule(location, false, new Entity[0]);
        Entity workList1 = this.createWorkList(true, new Entity[0]);
        ScheduleDocumentTemplateQuery query = new ScheduleDocumentTemplateQuery(schedule1, workList1);
        QueryTestHelper.checkSelects((boolean)true, (Query)query, (IMObject)template1);
        QueryTestHelper.checkSelects((boolean)true, (Query)query, (IMObject)template2);
        QueryTestHelper.checkSelects((boolean)true, (Query)query, (IMObject)template3);
        QueryTestHelper.checkSelects((boolean)true, (Query)query, (IMObject)template4);
    }

    private Entity createTemplate() {
        return this.documentFactory.createTemplate("act.patientDocumentLetter");
    }

    private void checkQuery(Entity schedule, Entity workList, Entity ... templates) {
        ScheduleDocumentTemplateQuery query = new ScheduleDocumentTemplateQuery(schedule, workList);
        List matches = QueryHelper.query((Query)query);
        Assert.assertEquals((long)templates.length, (long)matches.size());
        for (Entity template : templates) {
            Assert.assertTrue((boolean)matches.contains(template));
        }
    }

    private Entity createSchedule(Party location, boolean useAllTemplates, Entity ... templates) {
        Party schedule = ScheduleTestHelper.createSchedule((Party)location);
        this.addTemplates((Entity)schedule, useAllTemplates, templates);
        return schedule;
    }

    private Entity createWorkList(boolean useAllTemplates, Entity ... templates) {
        Party workList = ScheduleTestHelper.createWorkList();
        this.addTemplates((Entity)workList, useAllTemplates, templates);
        return workList;
    }

    private void addTemplates(Entity schedule, boolean useAllTemplates, Entity[] templates) {
        IMObjectBean bean = this.getBean((IMObject)schedule);
        for (Entity template : templates) {
            bean.addTarget("templates", (IMObject)template);
        }
        bean.setValue("useAllTemplates", (Object)useAllTemplates);
        bean.save();
    }
}

