/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.checkin;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import nextapp.echo2.app.Component;
import org.junit.Assert;
import org.openvpms.archetype.rules.patient.PatientRules;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.edit.Editor;
import org.openvpms.web.component.im.edit.EditDialog;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.PatientReferenceEditor;
import org.openvpms.web.component.im.query.BrowserDialog;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.component.workflow.Task;
import org.openvpms.web.echo.dialog.PopupDialog;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.test.EchoTestHelper;
import org.openvpms.web.workspace.patient.PatientEditor;
import org.openvpms.web.workspace.patient.visit.VisitEditorDialog;
import org.openvpms.web.workspace.workflow.EditVisitTask;
import org.openvpms.web.workspace.workflow.FinancialWorkflowRunner;
import org.openvpms.web.workspace.workflow.TestEditVisitTask;
import org.openvpms.web.workspace.workflow.checkin.CheckInDialog;
import org.openvpms.web.workspace.workflow.checkin.CheckInEditor;
import org.openvpms.web.workspace.workflow.checkin.CheckInWorkflow;

public class CheckInWorkflowRunner
extends FinancialWorkflowRunner<TestCheckInWorkflow> {
    private Act appointment;

    public CheckInWorkflowRunner(Act appointment, Party practice, Context context) {
        super(practice);
        context.setPractice(practice);
        this.appointment = appointment;
        this.setWorkflow(new TestCheckInWorkflow(appointment, context, new HelpContext("foo", null)));
    }

    public CheckInDialog getCheckInDialog() {
        Task task = this.getTask();
        Assert.assertTrue((boolean)(task instanceof CheckInWorkflow.CheckInDialogTask));
        return ((CheckInWorkflow.CheckInDialogTask)task).getCheckInDialog();
    }

    public CheckInEditor getCheckInEditor() {
        return this.getCheckInDialog().getEditor();
    }

    public void setArrivalTime(Date arrivalTime) {
        ((TestCheckInWorkflow)((Object)this.getWorkflow())).setArrivalTime(arrivalTime);
    }

    public BrowserDialog<Party> selectPatient() {
        CheckInEditor editor = this.getCheckInEditor();
        PatientReferenceEditor patientEditor = editor.getPatientReferenceEditor();
        EchoTestHelper.fireButton((Component)patientEditor.getComponent(), (String)"button.select");
        return EchoTestHelper.findBrowserDialog();
    }

    public BrowserDialog<Entity> selectWorkList() {
        CheckInEditor editor = this.getCheckInEditor();
        Editor workListEditor = editor.getWorkListEditor();
        Assert.assertNotNull((Object)workListEditor);
        EchoTestHelper.fireButton((Component)workListEditor.getComponent(), (String)"button.select");
        return EchoTestHelper.findBrowserDialog();
    }

    public EditDialog editPatient(String name) {
        EditDialog dialog = EchoTestHelper.findEditDialog();
        Assert.assertNotNull((Object)dialog);
        IMObjectEditor editor = dialog.getEditor();
        Assert.assertTrue((boolean)(editor instanceof PatientEditor));
        Party patient = (Party)editor.getObject();
        Assert.assertTrue((boolean)patient.isNew());
        editor.getProperty("name").setValue((Object)name);
        editor.getProperty("species").setValue((Object)TestHelper.getLookup((String)"lookup.species", (String)"CANINE").getCode());
        return dialog;
    }

    public void checkPatient(Party patient, Party customer) {
        Party p = this.getContext().getPatient();
        Assert.assertEquals((Object)patient, (Object)p);
        Assert.assertFalse((boolean)p.isNew());
        PatientRules rules = (PatientRules)ServiceHelper.getBean(PatientRules.class);
        customer = (Party)IMObjectHelper.reload((IMObject)customer);
        Assert.assertNotNull((Object)customer);
        Assert.assertTrue((boolean)rules.isOwner(customer, patient));
    }

    public Act checkTask(Entity workList, Party customer, Party patient, User clinician, String status, String notes) {
        Act task = (Act)this.getContext().getObject("act.customerTask");
        Assert.assertNotNull((Object)task);
        Assert.assertFalse((boolean)task.isNew());
        Assert.assertEquals((Object)status, (Object)task.getStatus());
        IMObjectBean bean = IMObjectHelper.getBean((IMObject)task);
        Assert.assertEquals((long)0L, (long)DateRules.compareTo((Date)((TestCheckInWorkflow)((Object)this.getWorkflow())).getArrivalTime(), (Date)task.getActivityStartTime()));
        Assert.assertEquals((Object)workList, (Object)bean.getTarget("worklist"));
        Assert.assertEquals((Object)customer, (Object)bean.getTarget("customer"));
        Assert.assertEquals((Object)patient, (Object)bean.getTarget("patient"));
        Assert.assertEquals((Object)clinician, (Object)bean.getTarget("clinician"));
        Assert.assertEquals((Object)notes, (Object)bean.getString("notes"));
        return task;
    }

    public Act checkEvent(Party patient, User clinician, String status, Party location) {
        Act event = (Act)this.getContext().getObject("act.patientClinicalEvent");
        Assert.assertNotNull((Object)event);
        Assert.assertFalse((boolean)event.isNew());
        IMObjectBean bean = IMObjectHelper.getBean((IMObject)event);
        Date arrivalTime = ((TestCheckInWorkflow)((Object)this.getWorkflow())).getArrivalTime();
        Assert.assertEquals((String)("Expected " + arrivalTime + ", got " + event.getActivityStartTime()), (long)0L, (long)DateRules.compareTo((Date)arrivalTime, (Date)event.getActivityStartTime(), (boolean)true));
        Assert.assertEquals((Object)patient, (Object)bean.getTarget("patient"));
        Assert.assertEquals((Object)clinician, (Object)bean.getTarget("clinician"));
        Assert.assertEquals((Object)status, (Object)event.getStatus());
        Assert.assertEquals((Object)location, (Object)bean.getTarget("location"));
        return event;
    }

    public void checkInvoice(User clinician, BigDecimal amount, String status, boolean saved) {
        Act invoice = (Act)this.getContext().getObject("act.customerAccountChargesInvoice");
        Assert.assertNotNull((Object)invoice);
        Assert.assertEquals((Object)saved, (Object)(!invoice.isNew() ? 1 : 0));
        IMObjectBean bean = IMObjectHelper.getBean((IMObject)invoice);
        Assert.assertEquals((long)0L, (long)bean.getBigDecimal("amount").compareTo(amount));
        Assert.assertEquals((Object)clinician, (Object)bean.getTarget("clinician"));
        Assert.assertEquals((Object)status, (Object)invoice.getStatus());
    }

    public void checkWeight(Party patient, BigDecimal weight, User clinician) {
        Act event = (Act)this.getContext().getObject("act.patientClinicalEvent");
        Assert.assertNotNull((Object)event);
        IMObjectBean bean = IMObjectHelper.getBean((IMObject)event);
        List acts = bean.getTargets("items", Act.class);
        Act weightAct = (Act)IMObjectHelper.getObject((String)"act.patientWeight", (Collection)acts);
        Assert.assertNotNull((Object)weightAct);
        acts.remove(weightAct);
        Assert.assertNull((Object)IMObjectHelper.getObject((String)"act.patientWeight", (Collection)acts));
        IMObjectBean weightBean = IMObjectHelper.getBean((IMObject)weightAct);
        Assert.assertEquals((Object)patient, (Object)weightBean.getTarget("patient"));
        Assert.assertEquals((Object)clinician, (Object)weightBean.getTarget("clinician"));
        Assert.assertEquals((long)0L, (long)weight.compareTo(weightBean.getBigDecimal("weight")));
    }

    public Act runWorkflow(Party patient, Party customer, Entity workList, Date arrivalTime, User clinician, Party location) {
        IMObjectBean bean;
        this.setArrivalTime(arrivalTime);
        this.start();
        CheckInEditor editor = this.getCheckInEditor();
        if (clinician != null) {
            editor.setClinician(clinician);
        }
        if ((bean = IMObjectHelper.getBean((IMObject)this.appointment)).getTargetRef("patient") == null) {
            editor.setPatient(patient);
        } else {
            Assert.assertEquals((Object)patient, (Object)editor.getPatient());
        }
        if (workList != null) {
            editor.setWorkList(workList);
        }
        editor.setWeight(BigDecimal.TEN);
        this.fireDialogButton((PopupDialog)this.getCheckInDialog(), "ok");
        this.checkWeight(patient, BigDecimal.TEN, clinician);
        if (workList != null) {
            this.checkTask(workList, customer, patient, clinician, "PENDING", "Reason X");
        }
        VisitEditorDialog eventDialog = this.editVisit();
        this.fireDialogButton((PopupDialog)eventDialog, "ok");
        return this.checkEvent(patient, clinician, "IN_PROGRESS", location);
    }

    public void checkComplete(boolean appointmentUpdated, Party customer, Party patient, Context context) {
        Assert.assertNull((Object)this.getTask());
        Assert.assertEquals((Object)patient, (Object)context.getPatient());
        Assert.assertEquals((Object)customer, (Object)context.getCustomer());
        this.appointment = (Act)IMObjectHelper.reload((IMObject)this.appointment);
        if (appointmentUpdated) {
            Assert.assertEquals((Object)"CHECKED_IN", (Object)this.appointment.getStatus());
            IMObjectBean bean = IMObjectHelper.getBean((IMObject)this.appointment);
            Assert.assertEquals((long)0L, (long)DateRules.compareTo((Date)((TestCheckInWorkflow)((Object)this.getWorkflow())).getArrivalTime(), (Date)bean.getDate("arrivalTime")));
        } else {
            Assert.assertTrue(("PENDING".equals(this.appointment.getStatus()) || "CONFIRMED".equals(this.appointment.getStatus()) ? 1 : 0) != 0);
        }
    }

    protected static class TestCheckInWorkflow
    extends CheckInWorkflow {
        private final Act appointment;
        private final Context context;
        private Date arrivalTime;

        public TestCheckInWorkflow(Act appointment, Context context, HelpContext help) {
            super(help);
            this.appointment = appointment;
            this.context = context;
        }

        public void setArrivalTime(Date arrivalTime) {
            this.arrivalTime = arrivalTime;
        }

        public Date getArrivalTime() {
            if (this.arrivalTime == null) {
                this.arrivalTime = super.getArrivalTime();
            }
            return this.arrivalTime;
        }

        public void start() {
            this.initialise(this.appointment, this.context);
            super.start();
        }

        protected EditVisitTask createEditVisitTask() {
            return new TestEditVisitTask();
        }
    }
}

