/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.appointment.repeat;

import java.util.Date;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.web.workspace.workflow.appointment.repeat.AbstractRepeatExpressionTest;
import org.openvpms.web.workspace.workflow.appointment.repeat.CronRepeatExpression;
import org.openvpms.web.workspace.workflow.appointment.repeat.RepeatExpression;
import org.openvpms.web.workspace.workflow.appointment.repeat.RepeatOnNthDayEditor;

public class RepeatOnNthDayEditorTestCase
extends AbstractRepeatExpressionTest {
    @Test
    public void testCreateWithStartTime() {
        Date startTime = TestHelper.getDatetime((String)"2015-01-08 09:30:00");
        RepeatOnNthDayEditor editor = new RepeatOnNthDayEditor(startTime);
        RepeatExpression expression = editor.getExpression();
        Assert.assertTrue((boolean)(expression instanceof CronRepeatExpression));
        CronRepeatExpression cron = (CronRepeatExpression)expression;
        Assert.assertEquals((Object)"9", (Object)cron.getHours());
        Assert.assertEquals((Object)"30", (Object)cron.getMinutes());
        Assert.assertTrue((boolean)cron.getDayOfMonth().isAll());
        Assert.assertEquals((long)1L, (long)cron.getMonth().month());
        Assert.assertEquals((long)1L, (long)cron.getMonth().getInterval());
        Assert.assertEquals((long)5L, (long)cron.getDayOfWeek().day());
        Assert.assertEquals((long)2L, (long)cron.getDayOfWeek().getOrdinal());
        Assert.assertTrue((boolean)cron.getYear().isAll());
        Assert.assertEquals((Object)"0 30 9 ? 1/1 THU#2 *", (Object)cron.getExpression());
        Date date1 = this.checkNext(startTime, (RepeatExpression)cron, "2015-02-12 09:30:00");
        Date date2 = this.checkNext(date1, (RepeatExpression)cron, "2015-03-12 09:30:00");
        this.checkNext(date2, (RepeatExpression)cron, "2015-04-09 09:30:00");
    }

    @Test
    public void testCreateWithExpression() {
        CronRepeatExpression cron = this.parse("0 30 9 ? 1/2 THU#2 *");
        Assert.assertTrue((boolean)RepeatOnNthDayEditor.supports((CronRepeatExpression)cron));
        RepeatOnNthDayEditor editor = new RepeatOnNthDayEditor(cron);
        Date startTime = TestHelper.getDatetime((String)"2015-01-08 09:30:00");
        editor.setStartTime(startTime);
        RepeatExpression expression = editor.getExpression();
        Assert.assertEquals((Object)cron, (Object)expression);
        Date date1 = this.checkNext(startTime, expression, "2015-03-12 09:30:00");
        Date date2 = this.checkNext(date1, expression, "2015-05-14 09:30:00");
        this.checkNext(date2, expression, "2015-07-09 09:30:00");
    }
}

