/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.appointment.repeat;

import java.util.Date;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.web.workspace.workflow.appointment.repeat.AbstractRepeatExpressionTest;
import org.openvpms.web.workspace.workflow.appointment.repeat.CronRepeatExpression;
import org.openvpms.web.workspace.workflow.appointment.repeat.RepeatExpression;
import org.openvpms.web.workspace.workflow.appointment.repeat.RepeatOnDaysOfMonthEditor;

public class RepeatOnDaysOfMonthEditorTestCase
extends AbstractRepeatExpressionTest {
    @Test
    public void testCreateWithStartTime() {
        Date startTime = TestHelper.getDatetime((String)"2015-01-08 09:30:00");
        RepeatOnDaysOfMonthEditor editor = new RepeatOnDaysOfMonthEditor(startTime);
        RepeatExpression expression = editor.getExpression();
        Assert.assertTrue((boolean)(expression instanceof CronRepeatExpression));
        CronRepeatExpression cron = (CronRepeatExpression)expression;
        Assert.assertEquals((Object)"9", (Object)cron.getHours());
        Assert.assertEquals((Object)"30", (Object)cron.getMinutes());
        Assert.assertEquals((long)8L, (long)cron.getDayOfMonth().day());
        Assert.assertEquals((long)1L, (long)cron.getMonth().getInterval());
        Assert.assertTrue((boolean)cron.getDayOfWeek().isAll());
        Assert.assertTrue((boolean)cron.getYear().isAll());
        Assert.assertEquals((Object)"0 30 9 8 1/1 ? *", (Object)cron.getExpression());
        Date date1 = this.checkNext(startTime, (RepeatExpression)cron, "2015-02-08 09:30:00");
        Date date2 = this.checkNext(date1, (RepeatExpression)cron, "2015-03-08 09:30:00");
        this.checkNext(date2, (RepeatExpression)cron, "2015-04-08 09:30:00");
    }

    @Test
    public void testCreateWithExpression() {
        CronRepeatExpression cron = this.parse("0 30 9 8,10 1/2 ? *");
        Assert.assertTrue((boolean)RepeatOnDaysOfMonthEditor.supports((CronRepeatExpression)cron));
        RepeatOnDaysOfMonthEditor editor = new RepeatOnDaysOfMonthEditor(cron);
        Date startTime = TestHelper.getDatetime((String)"2015-01-08 09:30:00");
        editor.setStartTime(startTime);
        RepeatExpression expression = editor.getExpression();
        Assert.assertEquals((Object)cron, (Object)expression);
        Date date1 = this.checkNext(startTime, (RepeatExpression)cron, "2015-01-10 09:30:00");
        Date date2 = this.checkNext(date1, (RepeatExpression)cron, "2015-03-08 09:30:00");
        this.checkNext(date2, (RepeatExpression)cron, "2015-03-10 09:30:00");
    }
}

