/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.appointment.repeat;

import java.util.BitSet;
import java.util.Date;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.web.workspace.workflow.appointment.repeat.AbstractRepeatExpressionTest;
import org.openvpms.web.workspace.workflow.appointment.repeat.CronRepeatExpression;
import org.openvpms.web.workspace.workflow.appointment.repeat.RepeatExpression;

public class CronRepeatExpressionTestCase
extends AbstractRepeatExpressionTest {
    @Test
    public void testParseDayOfWeek() {
        CronRepeatExpression expression1 = this.parse("0 0 12 ? * MON");
        Assert.assertTrue((boolean)expression1.getDayOfMonth().isAll());
        Assert.assertTrue((boolean)expression1.getMonth().isAll());
        this.checkSelected(expression1.getDayOfWeek(), 2);
        CronRepeatExpression expression2 = this.parse("0 0 12 ? * TUE-THU");
        Assert.assertTrue((boolean)expression2.getDayOfMonth().isAll());
        Assert.assertTrue((boolean)expression2.getMonth().isAll());
        this.checkSelected(expression2.getDayOfWeek(), 3, 4, 5);
        CronRepeatExpression expression3 = this.parse("0 0 12 ? * FRI,SAT");
        Assert.assertTrue((boolean)expression3.getDayOfMonth().isAll());
        Assert.assertTrue((boolean)expression3.getMonth().isAll());
        this.checkSelected(expression3.getDayOfWeek(), 6, 7);
    }

    @Test
    public void testParseDayOfWeekWithOrdinal() {
        CronRepeatExpression expression = this.parse("0 0 12 ? 1/2 MON#1");
        Assert.assertTrue((boolean)expression.getDayOfMonth().isAll());
        Assert.assertEquals((long)1L, (long)expression.getMonth().month());
        Assert.assertEquals((long)2L, (long)expression.getMonth().getInterval());
        Assert.assertEquals((long)1L, (long)expression.getDayOfWeek().getOrdinal());
        Assert.assertEquals((Object)"MON", (Object)expression.getDayOfWeek().getDay());
    }

    @Test
    public void testParseWeekdays() {
        CronRepeatExpression expression = this.parse("0 0 12 ? * MON-FRI");
        Assert.assertTrue((boolean)expression.getDayOfMonth().isAll());
        Assert.assertTrue((boolean)expression.getMonth().isAll());
        Assert.assertTrue((boolean)expression.getDayOfWeek().weekdays());
    }

    @Test
    public void testParseWeekends() {
        CronRepeatExpression expression = this.parse("0 0 12 ? * SUN,SAT");
        Assert.assertTrue((boolean)expression.getDayOfMonth().isAll());
        Assert.assertTrue((boolean)expression.getMonth().isAll());
        Assert.assertTrue((boolean)expression.getDayOfWeek().weekends());
    }

    @Test
    public void testParseMonthDays() {
        CronRepeatExpression expression1 = this.parse("0 0 12 1,3,5,7 * ?");
        this.checkSelected(expression1.getDayOfMonth(), 1, 3, 5, 7);
        Assert.assertFalse((boolean)expression1.getDayOfMonth().hasLast());
        Assert.assertTrue((boolean)expression1.getMonth().isAll());
        Assert.assertTrue((boolean)expression1.getDayOfWeek().isAll());
        CronRepeatExpression expression2 = this.parse("0 0 12 20-24 * ?");
        this.checkSelected(expression2.getDayOfMonth(), 20, 21, 22, 23, 24);
        Assert.assertFalse((boolean)expression2.getDayOfMonth().hasLast());
        Assert.assertTrue((boolean)expression2.getMonth().isAll());
        Assert.assertTrue((boolean)expression2.getDayOfWeek().isAll());
        CronRepeatExpression expression3 = this.parse("0 0 12 L * ?");
        this.checkSelected(expression3.getDayOfMonth(), new int[0]);
        Assert.assertTrue((boolean)expression3.getDayOfMonth().hasLast());
        Assert.assertTrue((boolean)expression3.getMonth().isAll());
        Assert.assertTrue((boolean)expression3.getDayOfWeek().isAll());
    }

    private void checkSelected(CronRepeatExpression.DayOfMonth dayOfMonth, int ... expected) {
        BitSet set = new BitSet();
        for (int day : expected) {
            set.set(day, true);
        }
        for (int day = 1; day <= 31; ++day) {
            Assert.assertEquals((Object)set.get(day), (Object)dayOfMonth.isSelected(day));
        }
    }

    private void checkSelected(CronRepeatExpression.DayOfWeek dayOfWeek, int ... expected) {
        BitSet set = new BitSet();
        for (int day : expected) {
            set.set(day, true);
        }
        for (int day = 1; day <= 31; ++day) {
            Assert.assertEquals((Object)set.get(day), (Object)dayOfWeek.isSelected(day));
        }
    }

    @Test
    public void testGetRepeatAfterForOrdinalDay() {
        Date startTime = TestHelper.getDatetime((String)"2015-01-05 12:00:00");
        CronRepeatExpression expression = this.parse("0 0 12 ? 1/2 MON#1");
        Date date1 = this.checkNext(startTime, (RepeatExpression)expression, "2015-03-02 12:00:00");
        Date date2 = this.checkNext(date1, (RepeatExpression)expression, "2015-05-04 12:00:00");
        this.checkNext(date2, (RepeatExpression)expression, "2015-07-06 12:00:00");
    }

    @Test
    public void testGetRepeatAfterForDate() {
        Date startTime = TestHelper.getDatetime((String)"2015-01-01 12:00:00");
        CronRepeatExpression expression = this.parse("0 0 12 1 1 ? 2015/2");
        Date date1 = this.checkNext(startTime, (RepeatExpression)expression, "2017-01-01 12:00:00");
        Date date2 = this.checkNext(date1, (RepeatExpression)expression, "2019-01-01 12:00:00");
        this.checkNext(date2, (RepeatExpression)expression, "2021-01-01 12:00:00");
    }
}

