/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.appointment.repeat;

import java.util.Date;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.rules.workflow.Times;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.business.service.security.AuthenticationContextImpl;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.user.User;
import org.openvpms.web.workspace.workflow.appointment.repeat.RepeatCondition;
import org.openvpms.web.workspace.workflow.appointment.repeat.RepeatExpression;
import org.openvpms.web.workspace.workflow.appointment.repeat.Repeats;
import org.openvpms.web.workspace.workflow.appointment.repeat.ScheduleEventSeries;

public abstract class AbstractScheduleEventSeriesTest
extends ArchetypeServiceTest {
    private Date startTime;
    private Date endTime;

    @Before
    public void setUp() {
        this.startTime = TestHelper.getDatetime((String)"2015-01-01 09:30:00");
        this.endTime = TestHelper.getDatetime((String)"2015-01-01 09:45:00");
        User author = TestHelper.createUser();
        new AuthenticationContextImpl().setUser(author);
    }

    @Test
    public void testRepeatDaily() {
        this.checkCreateSeries(Repeats.daily(), this.startTime, this.endTime, 1, DateUnits.DAYS);
    }

    @Test
    public void testRepeatWeekly() {
        this.checkCreateSeries(Repeats.weekly(), this.startTime, this.endTime, 1, DateUnits.WEEKS);
    }

    @Test
    public void testRepeatMonthly() {
        this.checkCreateSeries(Repeats.monthly(), this.startTime, this.endTime, 1, DateUnits.MONTHS);
    }

    @Test
    public void testRepeatYearly() {
        this.checkCreateSeries(Repeats.yearly(), this.startTime, this.endTime, 1, DateUnits.YEARS);
    }

    @Test
    public void testChangeSeriesExpression() {
        Act event = this.createEvent(this.startTime, this.endTime);
        ScheduleEventSeries series = this.createSeries(event, Repeats.monthly(), Repeats.times((int)11));
        this.checkSeries(series, event, 1, DateUnits.MONTHS, 12);
        series.setExpression(Repeats.yearly());
        series.save();
        this.checkSeries(series, event, 1, DateUnits.YEARS, 12);
    }

    @Test
    public void testChangeSeriesConditionToFewerEvents() {
        Act event = this.createEvent(this.startTime, this.endTime);
        ScheduleEventSeries series = this.createSeries(event, Repeats.monthly(), Repeats.times((int)11));
        this.checkSeries(series, event, 1, DateUnits.MONTHS, 12);
        List oldEvents = series.getEvents();
        Assert.assertEquals((long)12L, (long)oldEvents.size());
        List toRemove = oldEvents.subList(10, 12);
        series.setCondition(Repeats.times((int)9));
        series.save();
        this.checkSeries(series, event, 1, DateUnits.MONTHS, 10);
        List newEvents = series.getEvents();
        Assert.assertEquals((long)10L, (long)newEvents.size());
        for (Act act : oldEvents) {
            if (!toRemove.contains(act)) {
                Assert.assertTrue((boolean)newEvents.contains(act));
                continue;
            }
            Assert.assertNull((Object)this.get((IMObject)act));
        }
    }

    @Test
    public void testChangeSeriesConditionToMoreEvents() {
        Act event = this.createEvent(this.startTime, this.endTime);
        ScheduleEventSeries series = this.createSeries(event, Repeats.monthly(), Repeats.times((int)9));
        this.checkSeries(series, event, 1, DateUnits.MONTHS, 10);
        List oldEvents = series.getEvents();
        Assert.assertEquals((long)10L, (long)oldEvents.size());
        series.setCondition(Repeats.times((int)11));
        series.save();
        this.checkSeries(series, event, 1, DateUnits.MONTHS, 12);
        List newEvents = series.getEvents();
        Assert.assertEquals((long)12L, (long)newEvents.size());
        for (Act act : oldEvents) {
            Assert.assertTrue((boolean)newEvents.contains(act));
        }
    }

    @Test
    public void testSeriesWithOverlappingEvents() {
        Act event = this.createEvent(this.startTime, DateRules.getDate((Date)this.startTime, (int)2, (DateUnits)DateUnits.DAYS));
        ScheduleEventSeries series = this.createSeries(event);
        series.setExpression(Repeats.daily());
        series.setCondition(Repeats.once());
        ScheduleEventSeries.Overlap overlap = series.getFirstOverlap();
        Assert.assertNotNull((Object)overlap);
        Assert.assertEquals((Object)overlap.getEvent1(), (Object)Times.create((Act)event));
    }

    @Test
    public void testDeleteSeriesWithNoExpiredEvents() {
        Act event = this.createEvent();
        ScheduleEventSeries series = this.createSeries(event, Repeats.yearly(), Repeats.times((int)9));
        Act act = series.getSeries();
        Assert.assertNotNull((Object)act);
        List events = series.getEvents();
        Assert.assertEquals((long)10L, (long)events.size());
        series.setExpression(null);
        series.setCondition(null);
        series.save();
        events = series.getEvents();
        Assert.assertEquals((long)0L, (long)events.size());
        Assert.assertNull((Object)series.getSeries());
        Assert.assertNotNull((Object)this.get((IMObject)event));
        Assert.assertNull((Object)this.get((IMObject)act));
    }

    @Test
    public void testNewSeriesCreatedForNonInitialEvent() {
        Act first = this.createEvent(this.startTime, this.endTime);
        ScheduleEventSeries series1 = this.createSeries(first, Repeats.monthly(), Repeats.times((int)4));
        List<Act> events = this.checkSeries(series1, first, 1, DateUnits.MONTHS, 5);
        Act third = events.get(2);
        ScheduleEventSeries series2 = this.createSeries(third);
        RepeatCondition condition = series2.getCondition();
        Assert.assertEquals((Object)Repeats.times((int)2), (Object)condition);
        series2.setExpression(Repeats.yearly());
        this.checkSave(series2);
        this.checkSeries(series2, third, 1, DateUnits.YEARS, 3);
        series1 = this.createSeries(first);
        this.checkSeries(series1, first, 1, DateUnits.MONTHS, 2);
    }

    @Test
    public void testChangeEventDate() {
        Act event = this.createEvent(this.startTime, this.endTime);
        ScheduleEventSeries series = this.createSeries(event, Repeats.monthly(), Repeats.times((int)11));
        this.checkSeries(series, event, 1, DateUnits.MONTHS, 12);
        this.startTime = DateRules.getDate((Date)this.startTime, (int)1, (DateUnits)DateUnits.WEEKS);
        this.endTime = DateRules.getDate((Date)this.endTime, (int)1, (DateUnits)DateUnits.WEEKS);
        event.setActivityStartTime(this.startTime);
        event.setActivityEndTime(this.endTime);
        this.checkSave(series);
        this.checkSeries(series, event, 1, DateUnits.MONTHS, 12);
    }

    @Test
    public void testChangeTimesWithCronRepeat() {
        this.startTime = TestHelper.getDatetime((String)"2018-05-07 09:00:00");
        this.endTime = TestHelper.getDatetime((String)"2018-05-07 10:00:00");
        Act event = this.createEvent(this.startTime, this.endTime);
        ScheduleEventSeries series = this.createSeries(event, Repeats.weekdays((Date)this.startTime), Repeats.times((int)4));
        List acts1 = series.getEvents();
        Assert.assertEquals((long)5L, (long)acts1.size());
        for (int i = 0; i < acts1.size(); ++i) {
            Assert.assertEquals((Object)DateRules.getDate((Date)this.startTime, (int)i, (DateUnits)DateUnits.DAYS), (Object)((Act)acts1.get(i)).getActivityStartTime());
            Assert.assertEquals((Object)DateRules.getDate((Date)this.endTime, (int)i, (DateUnits)DateUnits.DAYS), (Object)((Act)acts1.get(i)).getActivityEndTime());
        }
        this.startTime = TestHelper.getDatetime((String)"2018-05-07 09:30:00");
        this.endTime = TestHelper.getDatetime((String)"2018-05-07 10:30:00");
        event.setActivityStartTime(this.startTime);
        event.setActivityEndTime(this.endTime);
        series.refresh();
        series.setExpression(Repeats.weekdays((Date)series.getStartTime()));
        this.checkSave(series);
        List acts2 = series.getEvents();
        Assert.assertEquals((long)5L, (long)acts2.size());
        for (int i = 0; i < acts2.size(); ++i) {
            Assert.assertEquals((Object)DateRules.getDate((Date)this.startTime, (int)i, (DateUnits)DateUnits.DAYS), (Object)((Act)acts2.get(i)).getActivityStartTime());
            Assert.assertEquals((Object)DateRules.getDate((Date)this.endTime, (int)i, (DateUnits)DateUnits.DAYS), (Object)((Act)acts2.get(i)).getActivityEndTime());
        }
    }

    protected void checkCreateSeries(RepeatExpression expression, Date startTime, Date endTime, int interval, DateUnits units) {
        Act event = this.createEvent(startTime, endTime);
        ScheduleEventSeries series = this.createSeries(event, expression, Repeats.times((int)9));
        this.checkSeries(series, event, interval, units, 10);
        Assert.assertFalse((boolean)series.isModified());
    }

    protected List<Act> checkSeries(ScheduleEventSeries series, Act event, int interval, DateUnits units, int count) {
        User author = (User)this.get(event.getCreatedBy());
        return this.checkSeries(series, event, interval, units, count, author);
    }

    protected Act createEvent() {
        return this.createEvent(this.startTime, this.endTime);
    }

    protected abstract Act createEvent(Date var1, Date var2);

    protected abstract List<Act> checkSeries(ScheduleEventSeries var1, Act var2, int var3, DateUnits var4, int var5, User var6);

    protected void checkSave(ScheduleEventSeries series) {
        Assert.assertNull((Object)series.getFirstOverlap());
        series.save();
    }

    protected ScheduleEventSeries createSeries(Act event, RepeatExpression expression, RepeatCondition condition) {
        ScheduleEventSeries series = this.createSeries(event);
        Assert.assertEquals((long)0L, (long)series.getEvents().size());
        Assert.assertTrue((boolean)series.isModified());
        Assert.assertNull((Object)series.getSeries());
        series.setExpression(expression);
        series.setCondition(condition);
        Assert.assertTrue((boolean)series.isModified());
        this.checkSave(series);
        Assert.assertFalse((boolean)series.isModified());
        Assert.assertNotNull((Object)series.getSeries());
        return series;
    }

    protected abstract ScheduleEventSeries createSeries(Act var1);
}

