/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.appointment;

import java.util.Date;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.workflow.AppointmentRules;
import org.openvpms.archetype.rules.workflow.ScheduleEvents;
import org.openvpms.archetype.rules.workflow.roster.RosterService;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.web.workspace.workflow.appointment.AbstractAppointmentGridTest;
import org.openvpms.web.workspace.workflow.appointment.AppointmentGrid;
import org.openvpms.web.workspace.workflow.appointment.SingleScheduleGrid;
import org.openvpms.web.workspace.workflow.scheduling.Schedule;
import org.openvpms.web.workspace.workflow.scheduling.ScheduleEventGrid;
import org.springframework.beans.factory.annotation.Autowired;

public class SingleScheduleGridTestCase
extends AbstractAppointmentGridTest {
    @Autowired
    private AppointmentRules rules;
    @Autowired
    private RosterService rosterService;

    @Test
    public void test9to5ScheduleGrid() {
        Entity schedule = this.createSchedule(15, "09:00", "17:00");
        Date date = TestHelper.getDate((String)"2019-10-07");
        Act appointment1 = this.createAppointment("2019-10-07 09:00", "2019-10-07 09:15", schedule);
        Act appointment2 = this.createAppointment("2019-10-07 09:30", "2019-10-07 10:00", schedule);
        Entity scheduleView = this.schedulingFactory.createScheduleView(new Entity[]{schedule});
        ScheduleEvents events = this.getScheduleEvents(appointment1, appointment2);
        SingleScheduleGrid grid = new SingleScheduleGrid(scheduleView, date, schedule, events, this.rules, this.rosterService);
        Assert.assertEquals((long)32L, (long)grid.getSlots());
        this.checkSlot((AppointmentGrid)grid, schedule, 0, "2019-10-07 09:00:00", appointment1, 1, ScheduleEventGrid.Availability.BUSY);
        this.checkSlot((AppointmentGrid)grid, schedule, 1, "2019-10-07 09:15:00", null, 0, ScheduleEventGrid.Availability.FREE);
        this.checkSlot((AppointmentGrid)grid, schedule, 2, "2019-10-07 09:30:00", appointment2, 2, ScheduleEventGrid.Availability.BUSY);
        this.checkSlot((AppointmentGrid)grid, schedule, 3, "2019-10-07 09:45:00", appointment2, 1, ScheduleEventGrid.Availability.BUSY);
        this.checkSlot((AppointmentGrid)grid, schedule, 4, "2019-10-07 10:00:00", null, 0, ScheduleEventGrid.Availability.FREE);
        this.checkSlot((AppointmentGrid)grid, schedule, 31, "2019-10-07 16:45:00", null, 0, ScheduleEventGrid.Availability.FREE);
        Schedule first = (Schedule)grid.getSchedules().get(0);
        Assert.assertEquals((Object)first.getSchedule(), (Object)schedule);
        Assert.assertNull((Object)grid.getEvent(first, -1));
        Assert.assertNull((Object)grid.getEvent(first, 32));
    }

    @Test
    public void testAppointmentsOutsideOfScheduleTimes() {
        Entity schedule = this.createSchedule(30, "09:00", "17:00");
        Date date = TestHelper.getDate((String)"2019-10-07");
        Act appointment1 = this.createAppointment("2019-10-07 08:30", "2019-10-07 09:30", schedule);
        Act appointment2 = this.createAppointment("2019-10-07 16:30", "2019-10-07 17:30", schedule);
        Entity scheduleView = this.schedulingFactory.createScheduleView(new Entity[]{schedule});
        ScheduleEvents events = this.getScheduleEvents(appointment1, appointment2);
        SingleScheduleGrid grid = new SingleScheduleGrid(scheduleView, date, schedule, events, this.rules, this.rosterService);
        Assert.assertEquals((long)18L, (long)grid.getSlots());
        this.checkSlot((AppointmentGrid)grid, schedule, 0, "2019-10-07 08:30", appointment1, 2, ScheduleEventGrid.Availability.BUSY);
        this.checkSlot((AppointmentGrid)grid, schedule, 1, "2019-10-07 09:00", appointment1, 1, ScheduleEventGrid.Availability.BUSY);
        this.checkSlot((AppointmentGrid)grid, schedule, 2, "2019-10-07 09:30", null, 0, ScheduleEventGrid.Availability.FREE);
        this.checkSlot((AppointmentGrid)grid, schedule, 15, "2019-10-07 16:00", null, 0, ScheduleEventGrid.Availability.FREE);
        this.checkSlot((AppointmentGrid)grid, schedule, 16, "2019-10-07 16:30", appointment2, 2, ScheduleEventGrid.Availability.BUSY);
        this.checkSlot((AppointmentGrid)grid, schedule, 17, "2019-10-07 17:00", appointment2, 1, ScheduleEventGrid.Availability.BUSY);
        Schedule first = (Schedule)grid.getSchedules().get(0);
        Assert.assertEquals((Object)first.getSchedule(), (Object)schedule);
        Assert.assertNull((Object)grid.getEvent(first, -1));
        Assert.assertNull((Object)grid.getEvent(first, 19));
    }

    @Test
    public void testAppointmentsNotOnSlotBoundaries() {
        Entity schedule = this.createSchedule(60, "09:00", "17:00");
        Date date = TestHelper.getDate((String)"2019-10-07");
        Act appointment1 = this.createAppointment("2019-10-07 08:30", "2019-10-07 09:30", schedule);
        Act appointment2 = this.createAppointment("2019-10-07 11:00", "2019-10-07 11:15", schedule);
        Act appointment3 = this.createAppointment("2019-10-07 12:30", "2019-10-07 13:00", schedule);
        Act appointment4 = this.createAppointment("2019-10-07 16:45", "2019-10-07 17:15", schedule);
        Entity scheduleView = this.schedulingFactory.createScheduleView(new Entity[]{schedule});
        ScheduleEvents events = this.getScheduleEvents(appointment1, appointment2, appointment3, appointment4);
        SingleScheduleGrid grid = new SingleScheduleGrid(scheduleView, date, schedule, events, this.rules, this.rosterService);
        Assert.assertEquals((long)10L, (long)grid.getSlots());
        this.checkSlot((AppointmentGrid)grid, schedule, 0, "2019-10-07 08:00", appointment1, 2, ScheduleEventGrid.Availability.BUSY);
        this.checkSlot((AppointmentGrid)grid, schedule, 1, "2019-10-07 09:00", appointment1, 1, ScheduleEventGrid.Availability.BUSY);
        this.checkSlot((AppointmentGrid)grid, schedule, 2, "2019-10-07 10:00", null, 0, ScheduleEventGrid.Availability.FREE);
        this.checkSlot((AppointmentGrid)grid, schedule, 3, "2019-10-07 11:00", appointment2, 1, ScheduleEventGrid.Availability.BUSY);
        this.checkSlot((AppointmentGrid)grid, schedule, 4, "2019-10-07 12:00", appointment3, 1, ScheduleEventGrid.Availability.BUSY);
        this.checkSlot((AppointmentGrid)grid, schedule, 5, "2019-10-07 13:00", null, 0, ScheduleEventGrid.Availability.FREE);
        this.checkSlot((AppointmentGrid)grid, schedule, 8, "2019-10-07 16:00", appointment4, 2, ScheduleEventGrid.Availability.BUSY);
        this.checkSlot((AppointmentGrid)grid, schedule, 9, "2019-10-07 17:00", appointment4, 1, ScheduleEventGrid.Availability.BUSY);
        Schedule first = (Schedule)grid.getSchedules().get(0);
        Assert.assertEquals((Object)first.getSchedule(), (Object)schedule);
        Assert.assertNull((Object)grid.getEvent(first, -1));
        Assert.assertNull((Object)grid.getEvent(first, 10));
    }
}

