/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.appointment;

import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.time.DateUtils;
import org.joda.time.Period;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.rules.workflow.ScheduleTestHelper;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.web.workspace.workflow.appointment.repeat.AbstractCalendarEventSeriesTest;
import org.openvpms.web.workspace.workflow.appointment.repeat.AppointmentSeries;
import org.openvpms.web.workspace.workflow.appointment.repeat.Repeats;
import org.openvpms.web.workspace.workflow.appointment.repeat.ScheduleEventSeries;

public class AppointmentSeriesTestCase
extends AbstractCalendarEventSeriesTest {
    private Party customer;
    private Party patient;
    private User clinician;

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.customer = TestHelper.createCustomer();
        this.patient = TestHelper.createPatient();
        this.clinician = TestHelper.createClinician();
    }

    @Test
    public void testChangeAppointmentType() {
        Entity appointmentType2 = ScheduleTestHelper.createAppointmentType();
        Entity schedule = this.getSchedule();
        ScheduleTestHelper.addAppointmentType((Entity)schedule, (Entity)appointmentType2, (int)1, (boolean)false);
        this.save((IMObject[])new Entity[]{schedule, appointmentType2});
        Act appointment = this.createEvent();
        ScheduleEventSeries series = this.createSeries(appointment, Repeats.weekly(), Repeats.times((int)2));
        this.checkSeries(series, appointment, 1, DateUnits.WEEKS, 3);
        IMObjectBean bean = this.getBean((IMObject)appointment);
        bean.setTarget("appointmentType", (IMObject)appointmentType2);
        this.checkSave(series);
        Assert.assertEquals((Object)appointmentType2, (Object)bean.getTarget("appointmentType"));
        this.checkSeries(series, appointment, 1, DateUnits.WEEKS, 3);
    }

    @Test
    public void testChangeCustomer() {
        Act appointment = this.createEvent();
        ScheduleEventSeries series = this.createSeries(appointment, Repeats.monthly(), Repeats.times((int)2));
        this.checkSeries(series, appointment, 1, DateUnits.MONTHS, 3);
        Party customer2 = TestHelper.createCustomer();
        IMObjectBean bean = this.getBean((IMObject)appointment);
        bean.setTarget("customer", (IMObject)customer2);
        this.checkSave(series);
        Assert.assertEquals((Object)customer2, (Object)bean.getTarget("customer"));
        this.checkSeries(series, appointment, 1, DateUnits.MONTHS, 3);
    }

    @Test
    public void testChangePatient() {
        Act appointment = this.createEvent();
        ScheduleEventSeries series = this.createSeries(appointment, Repeats.monthly(), Repeats.times((int)2));
        this.checkSeries(series, appointment, 1, DateUnits.MONTHS, 3);
        IMObjectBean bean = this.getBean((IMObject)appointment);
        bean.setTarget("patient", (IMObject)this.patient);
        this.checkSave(series);
        Assert.assertEquals((Object)this.patient, (Object)bean.getTarget("patient"));
        this.checkSeries(series, appointment, 1, DateUnits.MONTHS, 3);
    }

    @Test
    public void testChangeClinician() {
        Act appointment = this.createEvent();
        ScheduleEventSeries series = this.createSeries(appointment, Repeats.monthly(), Repeats.times((int)2));
        this.checkSeries(series, appointment, 1, DateUnits.MONTHS, 3);
        User clinician2 = TestHelper.createClinician();
        IMObjectBean bean = this.getBean((IMObject)appointment);
        bean.setTarget("clinician", (IMObject)clinician2);
        this.checkSave(series);
        Assert.assertEquals((Object)clinician2, (Object)bean.getTarget("clinician"));
        this.checkSeries(series, appointment, 1, DateUnits.MONTHS, 3);
    }

    @Test
    public void testChangeStatus() {
        Act appointment = this.createEvent();
        ScheduleEventSeries series = this.createSeries(appointment, Repeats.monthly(), Repeats.times((int)2));
        this.checkSeries(series, appointment, 1, DateUnits.MONTHS, 3);
        appointment.setStatus("COMPLETED");
        this.checkSave(series);
        Assert.assertEquals((Object)"COMPLETED", (Object)appointment.getStatus());
        this.checkSeries(series, appointment, 1, DateUnits.MONTHS, 3);
    }

    @Test
    public void testSendReminder() {
        Date startTime = DateRules.getDate((Date)DateRules.getYesterday(), (int)9, (DateUnits)DateUnits.HOURS);
        Date endTime = DateRules.getDate((Date)startTime, (int)15, (DateUnits)DateUnits.MINUTES);
        Act appointment1 = this.createEvent(startTime, endTime);
        this.setSendReminder(appointment1, true);
        ScheduleEventSeries series1 = this.createSeries(appointment1, Repeats.weekly(), Repeats.times((int)2));
        List<Act> acts1 = this.checkSeries(series1, appointment1, 1, DateUnits.WEEKS, 3);
        this.checkSendReminder(acts1.get(0), true);
        this.checkSendReminder(acts1.get(1), true);
        this.checkSendReminder(acts1.get(2), true);
        Act appointment2 = acts1.get(1);
        ScheduleEventSeries series2 = this.createSeries(appointment2);
        this.setSendReminder(appointment2, false);
        Assert.assertTrue((boolean)series2.isModified());
        this.save((IMObject)appointment2);
        series2.save();
        List<Act> acts2 = this.checkSeries(series2, appointment1, 1, DateUnits.WEEKS, 3);
        this.checkSendReminder(acts2.get(0), true);
        this.checkSendReminder(acts2.get(1), false);
        this.checkSendReminder(acts2.get(2), false);
    }

    @Test
    public void testSendReminderNotEnabledWithinNoReminderPeriod() {
        Date startTime = DateUtils.truncate((Date)new Date(), (int)13);
        Date endTime = DateRules.getDate((Date)startTime, (int)15, (DateUnits)DateUnits.MINUTES);
        Act appointment = this.createEvent(startTime, endTime);
        this.setSendReminder(appointment, true);
        ScheduleEventSeries series = this.createSeries(appointment, Repeats.daily(), Repeats.times((int)2));
        List<Act> acts1 = this.checkSeries(series, appointment, 1, DateUnits.DAYS, 3);
        this.checkSendReminder(acts1.get(0), true);
        this.checkSendReminder(acts1.get(1), false);
        this.checkSendReminder(acts1.get(2), true);
        this.setSendReminder(appointment, false);
        Assert.assertTrue((boolean)series.isModified());
        this.save((IMObject)appointment);
        series.save();
        List<Act> acts2 = this.checkSeries(series, appointment, 1, DateUnits.DAYS, 3);
        this.checkSendReminder(acts2.get(0), false);
        this.checkSendReminder(acts2.get(1), false);
        this.checkSendReminder(acts2.get(2), false);
    }

    @Override
    protected List<Act> checkSeries(ScheduleEventSeries series, Act event, int interval, DateUnits units, int count, User author) {
        List acts = series.getEvents();
        Assert.assertEquals((long)count, (long)acts.size());
        Date from = event.getActivityStartTime();
        Date to = event.getActivityEndTime();
        Assert.assertEquals((Object)event, acts.get(0));
        IMObjectBean bean = this.getBean((IMObject)event);
        Entity schedule = (Entity)bean.getTarget("schedule", Entity.class);
        Entity appointmentType = (Entity)bean.getTarget("appointmentType", Entity.class);
        String status = event.getStatus();
        Party customer = (Party)bean.getTarget("customer", Party.class);
        Party patient = (Party)bean.getTarget("patient", Party.class);
        User clinician = (User)bean.getTarget("clinician", User.class);
        String notes = bean.getString("notes");
        for (Act act : acts) {
            this.checkAppointment(act, from, to, schedule, appointmentType, status, customer, patient, clinician, author, notes);
            from = DateRules.getDate((Date)from, (int)interval, (DateUnits)units);
            to = DateRules.getDate((Date)to, (int)interval, (DateUnits)units);
        }
        return acts;
    }

    @Override
    protected Act createEvent(Date startTime, Date endTime, Entity schedule, Entity appointmentType) {
        Act appointment = ScheduleTestHelper.createAppointment((Date)startTime, (Date)endTime, (Entity)schedule, (Entity)appointmentType, (Party)this.customer, (Party)this.patient, (User)this.clinician);
        IMObjectBean bean = this.getBean((IMObject)appointment);
        bean.setValue("notes", (Object)"some notes");
        return appointment;
    }

    @Override
    protected ScheduleEventSeries createSeries(Act event) {
        AppointmentSeries series = new AppointmentSeries(event, this.getArchetypeService());
        series.setNoReminderPeriod(Period.days((int)1));
        return series;
    }

    protected void setSendReminder(Act appointment, boolean sendReminder) {
        IMObjectBean bean = this.getBean((IMObject)appointment);
        bean.setValue("sendReminder", (Object)sendReminder);
    }

    private void checkAppointment(Act act, Date startTime, Date endTime, Entity schedule, Entity appointmentType, String status, Party customer, Party patient, User clinician, User author, String notes) {
        Assert.assertEquals((long)0L, (long)DateRules.compareTo((Date)startTime, (Date)act.getActivityStartTime()));
        Assert.assertEquals((long)0L, (long)DateRules.compareTo((Date)endTime, (Date)act.getActivityEndTime()));
        IMObjectBean bean = this.getBean((IMObject)act);
        Assert.assertEquals((Object)schedule, (Object)bean.getTarget("schedule"));
        Assert.assertEquals((Object)appointmentType, (Object)bean.getTarget("appointmentType"));
        Assert.assertEquals((Object)status, (Object)act.getStatus());
        Assert.assertEquals((Object)customer, (Object)bean.getTarget("customer"));
        Assert.assertEquals((Object)patient, (Object)bean.getTarget("patient"));
        Assert.assertEquals((Object)clinician, (Object)bean.getTarget("clinician"));
        Assert.assertEquals((Object)author.getObjectReference(), (Object)act.getCreatedBy());
        Assert.assertEquals((Object)notes, (Object)bean.getString("notes"));
    }

    private void checkSendReminder(Act appointment, boolean sendReminder) {
        IMObjectBean bean = this.getBean((IMObject)appointment);
        Assert.assertEquals((Object)sendReminder, (Object)bean.getBoolean("sendReminder"));
    }
}

