/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.appointment;

import java.util.Date;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.archetype.test.builder.customer.TestCustomerFactory;
import org.openvpms.archetype.test.builder.patient.TestPatientFactory;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.archetype.test.builder.scheduling.TestAppointmentBuilder;
import org.openvpms.archetype.test.builder.scheduling.TestSchedulingFactory;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.system.common.util.PropertySet;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.ContextApplicationInstance;
import org.openvpms.web.component.app.GlobalContext;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.test.AbstractAppTest;
import org.openvpms.web.workspace.workflow.appointment.AppointmentBrowser;
import org.openvpms.web.workspace.workflow.appointment.AppointmentCRUDWindow;
import org.springframework.beans.factory.annotation.Autowired;

public class AppointmentCRUDWindowTestCase
extends AbstractAppTest {
    @Autowired
    private TestCustomerFactory customerFactory;
    @Autowired
    private TestPatientFactory patientFactory;
    @Autowired
    private TestPracticeFactory practiceFactory;
    @Autowired
    private TestSchedulingFactory schedulingFactory;

    @Test
    public void testUpdateContext() {
        GlobalContext context = ContextApplicationInstance.getInstance().getContext();
        AppointmentCRUDWindow window = new AppointmentCRUDWindow((AppointmentBrowser)Mockito.mock(AppointmentBrowser.class), (Context)context, new HelpContext("foo", null));
        Assert.assertNull((Object)context.getAppointment());
        Party location = this.practiceFactory.createLocation();
        Entity schedule = this.schedulingFactory.createSchedule(location);
        Entity appointmentType = this.schedulingFactory.createAppointmentType();
        Party customer = this.customerFactory.createCustomer();
        Act appointment = (Act)((TestAppointmentBuilder)((TestAppointmentBuilder)this.schedulingFactory.newAppointment().startTime(DateRules.getToday())).schedule(schedule).appointmentType(appointmentType).customer(customer)).build();
        window.setObject(appointment);
        Assert.assertEquals((Object)appointment, (Object)context.getAppointment());
        window.setObject(null);
        Assert.assertNull((Object)context.getAppointment());
    }

    @Test
    public void testCutPasteConfirmedAppointmentToSameTime() {
        this.checkCutPasteConfirmedAppointment(true);
    }

    @Test
    public void testCutPasteConfirmedAppointmentToDifferentTime() {
        this.checkCutPasteConfirmedAppointment(false);
    }

    private void checkCutPasteConfirmedAppointment(boolean sameTime) {
        Entity newSchedule;
        Date start2;
        Party location = this.practiceFactory.createLocation();
        LocalContext context = new LocalContext();
        HelpContext help = new HelpContext("foo", null);
        DefaultLayoutContext layoutContext = new DefaultLayoutContext((Context)context, help);
        Entity appointmentType = this.schedulingFactory.createAppointmentType();
        Entity schedule1 = (Entity)this.schedulingFactory.newSchedule().location(location).appointmentTypes(new Entity[]{appointmentType}).build();
        Entity schedule2 = (Entity)this.schedulingFactory.newSchedule().location(location).appointmentTypes(new Entity[]{appointmentType}).build();
        Entity scheduleView = this.schedulingFactory.createScheduleView(new Entity[]{schedule1, schedule2});
        this.practiceFactory.updateLocation(location).scheduleViews(new Entity[]{scheduleView}).build();
        Party customer = this.customerFactory.createCustomer();
        Party patient = this.patientFactory.createPatient(customer);
        Date start1 = TestHelper.getDatetime((String)"2023-07-25 09:00");
        Date reminderSent = DateRules.getDate((Date)start1, (int)1, (DateUnits)DateUnits.HOURS);
        Act appointment = (Act)((TestAppointmentBuilder)((TestAppointmentBuilder)((TestAppointmentBuilder)((TestAppointmentBuilder)this.schedulingFactory.newAppointment().startTime(start1)).schedule(schedule1).appointmentType(appointmentType).customer(customer)).patient(patient)).sendReminder(true).reminderSent(reminderSent).reminderError("an error").status("CONFIRMED")).build();
        AppointmentBrowser browser = new AppointmentBrowser(location, (LayoutContext)layoutContext);
        browser.getComponent();
        browser.setDate(DateRules.getDate((Date)start1));
        Assert.assertEquals((Object)scheduleView, (Object)browser.getScheduleView());
        browser.query();
        AppointmentCRUDWindow window = new AppointmentCRUDWindow(browser, (Context)context, help);
        browser.getComponent();
        browser.setSelected(schedule1, start1);
        PropertySet selected = browser.getSelected();
        Assert.assertNotNull((Object)selected);
        Assert.assertEquals((Object)appointment, (Object)browser.getAct(selected));
        window.cut();
        Assert.assertEquals((Object)selected, (Object)browser.getMarked());
        if (sameTime) {
            start2 = start1;
            newSchedule = schedule2;
        } else {
            newSchedule = schedule1;
            start2 = DateRules.getDate((Date)start1, (int)2, (DateUnits)DateUnits.HOURS);
        }
        browser.setSelected(newSchedule, start2);
        window.paste();
        Assert.assertNull((Object)browser.getMarked());
        Act updated = sameTime ? (Act)this.get((IMObject)appointment) : browser.getAct(browser.getSelected());
        Assert.assertEquals((Object)appointment, (Object)updated);
        Assert.assertEquals((Object)start2, (Object)updated.getActivityStartTime());
        Assert.assertEquals((Object)DateRules.getDate((Date)start2, (int)15, (DateUnits)DateUnits.MINUTES), (Object)updated.getActivityEndTime());
        IMObjectBean bean = this.getBean((IMObject)updated);
        Assert.assertEquals((Object)newSchedule.getObjectReference(), (Object)bean.getTargetRef("schedule"));
        if (sameTime) {
            Assert.assertEquals((Object)"CONFIRMED", (Object)updated.getStatus());
            Assert.assertEquals((Object)reminderSent, (Object)bean.getDate("reminderSent"));
            Assert.assertEquals((Object)"an error", (Object)bean.getString("reminderError"));
        } else {
            Assert.assertEquals((Object)"PENDING", (Object)updated.getStatus());
            Assert.assertNull((Object)bean.getDate("reminderSent"));
            Assert.assertNull((Object)bean.getString("reminderError"));
        }
    }
}

