/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.supplier.order;

import java.math.BigDecimal;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.workspace.supplier.AbstractSupplierStockItemEditorTest;
import org.openvpms.web.workspace.supplier.SupplierStockItemEditor;
import org.openvpms.web.workspace.supplier.order.OrderEditContext;
import org.openvpms.web.workspace.supplier.order.OrderItemEditor;

public class OrderItemEditorTestCase
extends AbstractSupplierStockItemEditorTest {
    private LayoutContext context;

    @Before
    public void setUp() {
        super.setUp();
        this.context = new DefaultLayoutContext((Context)new LocalContext(), new HelpContext("foo", null));
    }

    @Test
    public void testValidation() {
        Party supplier = TestHelper.createSupplier();
        Act order = this.createOrder(supplier);
        FinancialAct item = (FinancialAct)this.create("act.supplierOrderItem", FinancialAct.class);
        OrderItemEditor editor = new OrderItemEditor(item, order, this.context);
        Assert.assertFalse((boolean)editor.isValid());
        Assert.assertFalse((boolean)editor.isValid());
        Product product = TestHelper.createProduct();
        editor.setProduct(product);
        Assert.assertTrue((boolean)editor.isValid());
        editor.setProduct(null);
        Assert.assertFalse((boolean)editor.isValid());
        editor.setProduct(product);
        Assert.assertTrue((boolean)editor.isValid());
        editor.setQuantity(BigDecimal.ONE);
        editor.setCancelledQuantity(new BigDecimal(2));
        Assert.assertFalse((boolean)editor.isValid());
        editor.setCancelledQuantity(BigDecimal.ONE);
        Assert.assertTrue((boolean)editor.isValid());
    }

    @Test
    public void testCreateProductSupplierRelationship() {
        Party supplier = TestHelper.createSupplier();
        Act order = this.createOrder(supplier);
        FinancialAct item = (FinancialAct)this.create("act.supplierOrderItem", FinancialAct.class);
        OrderItemEditor editor = new OrderItemEditor(item, order, new OrderEditContext(), this.context);
        this.checkCreateProductSupplierRelationship((SupplierStockItemEditor)editor, supplier);
    }

    @Test
    public void testUpdateProductSupplierRelationship() {
        Party supplier = TestHelper.createSupplier();
        Act order = this.createOrder(supplier);
        FinancialAct item = (FinancialAct)this.create("act.supplierOrderItem", FinancialAct.class);
        OrderItemEditor editor = new OrderItemEditor(item, order, this.context);
        this.checkUpdateProductSupplierRelationship((SupplierStockItemEditor)editor);
    }

    private Act createOrder(Party supplier) {
        Act order = (Act)this.create("act.supplierOrder", FinancialAct.class);
        IMObjectBean bean = this.getBean((IMObject)order);
        bean.setTarget("supplier", (IMObject)supplier);
        return order;
    }
}

