/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.supplier.delivery;

import java.math.BigDecimal;
import java.util.List;
import org.junit.Test;
import org.openvpms.archetype.rules.supplier.SupplierTestHelper;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.im.query.QueryTestHelper;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.test.AbstractAppTest;
import org.openvpms.web.workspace.supplier.delivery.PostedOrderQuery;

public class PostedOrderQueryTestCase
extends AbstractAppTest {
    @Test
    public void testQueryStatus() {
        Party supplier1 = TestHelper.createSupplier();
        Party supplier2 = TestHelper.createSupplier();
        Party stockLocation = SupplierTestHelper.createStockLocation();
        FinancialAct inProgress = this.createOrder(supplier1, stockLocation, "IN_PROGRESS");
        FinancialAct completed = this.createOrder(supplier1, stockLocation, "COMPLETED");
        FinancialAct cancelled = this.createOrder(supplier1, stockLocation, "CANCELLED");
        FinancialAct posted1 = this.createOrder(supplier1, stockLocation, "POSTED");
        FinancialAct posted2 = this.createOrder(supplier2, stockLocation, "POSTED");
        FinancialAct accepted = this.createOrder(supplier1, stockLocation, "ACCEPTED");
        FinancialAct rejected = this.createOrder(supplier1, stockLocation, "REJECTED");
        PostedOrderQuery query = new PostedOrderQuery(true, (LayoutContext)new DefaultLayoutContext((Context)new LocalContext(), new HelpContext("foo", null)));
        QueryTestHelper.checkEmpty((Query)query);
        QueryTestHelper.checkExists((IMObject)inProgress, (Query)query, (boolean)false);
        QueryTestHelper.checkExists((IMObject)completed, (Query)query, (boolean)false);
        QueryTestHelper.checkExists((IMObject)cancelled, (Query)query, (boolean)false);
        QueryTestHelper.checkExists((IMObject)posted1, (Query)query, (boolean)false);
        QueryTestHelper.checkExists((IMObject)posted2, (Query)query, (boolean)false);
        QueryTestHelper.checkExists((IMObject)accepted, (Query)query, (boolean)false);
        QueryTestHelper.checkExists((IMObject)rejected, (Query)query, (boolean)false);
        query.setSupplier(supplier1);
        query.setStockLocation(stockLocation);
        QueryTestHelper.checkExists((IMObject)inProgress, (Query)query, (boolean)false);
        QueryTestHelper.checkExists((IMObject)completed, (Query)query, (boolean)false);
        QueryTestHelper.checkExists((IMObject)cancelled, (Query)query, (boolean)false);
        QueryTestHelper.checkExists((IMObject)posted1, (Query)query, (boolean)true);
        QueryTestHelper.checkExists((IMObject)accepted, (Query)query, (boolean)true);
        QueryTestHelper.checkExists((IMObject)rejected, (Query)query, (boolean)false);
    }

    @Test
    public void testSupplierQuery() {
        Party supplier1 = TestHelper.createSupplier();
        Party supplier2 = TestHelper.createSupplier();
        Party stockLocation = SupplierTestHelper.createStockLocation();
        FinancialAct posted1 = this.createOrder(supplier1, stockLocation, "POSTED");
        FinancialAct posted2 = this.createOrder(supplier2, stockLocation, "POSTED");
        PostedOrderQuery query = new PostedOrderQuery(true, (LayoutContext)new DefaultLayoutContext((Context)new LocalContext(), new HelpContext("foo", null)));
        QueryTestHelper.checkExists((IMObject)posted1, (Query)query, (boolean)false);
        QueryTestHelper.checkExists((IMObject)posted2, (Query)query, (boolean)false);
        query.setStockLocation(stockLocation);
        QueryTestHelper.checkExists((IMObject)posted1, (Query)query, (boolean)false);
        QueryTestHelper.checkExists((IMObject)posted2, (Query)query, (boolean)false);
        query.setSupplier(supplier1);
        QueryTestHelper.checkExists((IMObject)posted1, (Query)query, (boolean)true);
        QueryTestHelper.checkExists((IMObject)posted2, (Query)query, (boolean)false);
    }

    @Test
    public void testInitFromContext() {
        HelpContext help = new HelpContext("foo", null);
        Party supplier1 = TestHelper.createSupplier();
        Party supplier2 = TestHelper.createSupplier();
        Party stockLocation = SupplierTestHelper.createStockLocation();
        FinancialAct posted1 = this.createOrder(supplier1, stockLocation, "POSTED");
        FinancialAct posted2 = this.createOrder(supplier2, stockLocation, "POSTED");
        LocalContext context1 = new LocalContext();
        PostedOrderQuery query1 = new PostedOrderQuery(true, (LayoutContext)new DefaultLayoutContext((Context)context1, help));
        QueryTestHelper.checkExists((IMObject)posted1, (Query)query1, (boolean)false);
        QueryTestHelper.checkExists((IMObject)posted2, (Query)query1, (boolean)false);
        LocalContext context2 = new LocalContext();
        context2.setStockLocation(stockLocation);
        PostedOrderQuery query2 = new PostedOrderQuery(true, (LayoutContext)new DefaultLayoutContext((Context)context2, help));
        QueryTestHelper.checkExists((IMObject)posted1, (Query)query2, (boolean)false);
        QueryTestHelper.checkExists((IMObject)posted2, (Query)query2, (boolean)false);
        LocalContext context3 = new LocalContext();
        context3.setStockLocation(stockLocation);
        context3.setSupplier(supplier2);
        PostedOrderQuery query3 = new PostedOrderQuery(true, (LayoutContext)new DefaultLayoutContext((Context)context3, help));
        QueryTestHelper.checkExists((IMObject)posted1, (Query)query3, (boolean)false);
        QueryTestHelper.checkExists((IMObject)posted2, (Query)query3, (boolean)true);
    }

    protected FinancialAct createOrder(Party supplier, Party stockLocation, String status) {
        Product product = TestHelper.createProduct();
        List acts = SupplierTestHelper.createOrder((BigDecimal)BigDecimal.ONE, (Party)supplier, (Party)stockLocation, (Product)product);
        FinancialAct order = (FinancialAct)acts.get(0);
        order.setStatus(status);
        this.save(acts);
        return order;
    }
}

