/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.supplier;

import java.math.BigDecimal;
import java.util.List;
import org.junit.Assert;
import org.openvpms.archetype.rules.product.ProductRules;
import org.openvpms.archetype.rules.product.ProductSupplier;
import org.openvpms.archetype.test.builder.lookup.TestLookupFactory;
import org.openvpms.archetype.test.builder.product.TestProductFactory;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.SaveHelper;
import org.openvpms.web.test.AbstractAppTest;
import org.openvpms.web.workspace.supplier.SupplierStockItemEditor;
import org.springframework.beans.factory.annotation.Autowired;

public class AbstractSupplierStockItemEditorTest
extends AbstractAppTest {
    @Autowired
    protected ProductRules productRules;
    @Autowired
    protected TestLookupFactory lookupFactory;
    @Autowired
    protected TestProductFactory productFactory;

    protected void checkCreateProductSupplierRelationship(SupplierStockItemEditor editor, Party supplier) {
        Lookup box = this.lookupFactory.createUnitOfMeasure("BOX");
        Product product = this.productFactory.createMedication();
        this.populate(editor, product, BigDecimal.ONE, "abc", 10, box.getCode(), BigDecimal.ONE);
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor));
        this.checkProductSupplier(product, supplier, "abc", 10, box.getCode(), BigDecimal.ONE);
        editor.setListPrice(BigDecimal.TEN);
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor));
        this.checkProductSupplier(product, supplier, "abc", 10, box.getCode(), BigDecimal.TEN);
    }

    protected void checkUpdateProductSupplierRelationship(SupplierStockItemEditor editor) {
        Lookup box = this.lookupFactory.createUnitOfMeasure("BOX");
        Product product = this.productFactory.createMerchandise();
        this.createProductSupplier(product, editor.getSupplier(), "abc", 5, box.getCode(), BigDecimal.TEN, BigDecimal.TEN);
        this.populate(editor, product, BigDecimal.ONE, "abc", 10, box.getCode(), BigDecimal.ONE);
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor));
        this.checkProductSupplier(product, editor.getSupplier(), "abc", 10, box.getCode(), BigDecimal.ONE);
    }

    protected void populate(SupplierStockItemEditor editor, Product product, BigDecimal quantity, String reorderCode, int packageSize, String packageUnits, BigDecimal listPrice) {
        editor.setProduct(product);
        editor.setQuantity(quantity);
        editor.setReorderCode(reorderCode);
        editor.setPackageSize(Integer.valueOf(packageSize));
        editor.setPackageUnits(packageUnits);
        editor.setListPrice(listPrice);
    }

    protected void createProductSupplier(Product product, Party supplier, String reorderCode, int packageSize, String packageUnits, BigDecimal listPrice, BigDecimal nettPrice) {
        ProductSupplier productSupplier = this.productRules.createProductSupplier(product, supplier);
        productSupplier.setReorderCode(reorderCode);
        productSupplier.setPackageSize(packageSize);
        productSupplier.setPackageUnits(packageUnits);
        productSupplier.setListPrice(listPrice);
        productSupplier.setNettPrice(nettPrice);
        this.save((IMObject[])new Entity[]{product, supplier});
    }

    protected void checkProductSupplier(Product product, Party supplier, String reorderCode, int packageSize, String packageUnits, BigDecimal listPrice) {
        product = (Product)this.get((IMObject)product);
        supplier = (Party)this.get((IMObject)supplier);
        List productSuppliers = this.productRules.getProductSuppliers(product, supplier);
        Assert.assertEquals((long)1L, (long)productSuppliers.size());
        ProductSupplier ps = (ProductSupplier)productSuppliers.get(0);
        Assert.assertEquals((Object)reorderCode, (Object)ps.getReorderCode());
        Assert.assertEquals((long)packageSize, (long)ps.getPackageSize());
        Assert.assertEquals((Object)packageUnits, (Object)ps.getPackageUnits());
        this.checkEquals(listPrice, ps.getListPrice());
    }
}

