/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.reporting.statement;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.mail.internet.MimeMessage;
import nextapp.echo2.app.ApplicationInstance;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.archetype.rules.finance.account.CustomerAccountRules;
import org.openvpms.archetype.rules.finance.statement.AbstractStatementTest;
import org.openvpms.archetype.rules.finance.statement.Statement;
import org.openvpms.archetype.rules.finance.statement.StatementProcessor;
import org.openvpms.archetype.rules.finance.statement.StatementRules;
import org.openvpms.archetype.rules.practice.PracticeRules;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.archetype.test.builder.customer.TestCustomerBuilder;
import org.openvpms.archetype.test.builder.customer.TestCustomerFactory;
import org.openvpms.archetype.test.builder.doc.TestDocumentBuilder;
import org.openvpms.archetype.test.builder.doc.TestDocumentFactory;
import org.openvpms.archetype.test.builder.doc.TestDocumentTemplateBuilder;
import org.openvpms.archetype.test.builder.practice.TestMailServerBuilder;
import org.openvpms.archetype.test.builder.practice.TestPracticeBuilder;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.component.business.domain.im.datatypes.quantity.Money;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.document.Document;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.macro.Macros;
import org.openvpms.report.DocumentConverter;
import org.openvpms.report.ReportFactory;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.app.PracticeMailContext;
import org.openvpms.web.component.im.doc.FileNameFormatter;
import org.openvpms.web.component.im.report.ReporterFactory;
import org.openvpms.web.component.mail.DefaultMailer;
import org.openvpms.web.component.mail.EmailTemplateEvaluator;
import org.openvpms.web.component.mail.MailContext;
import org.openvpms.web.component.mail.MailerFactory;
import org.openvpms.web.security.mail.MailPasswordResolver;
import org.openvpms.web.workspace.OpenVPMSApp;
import org.openvpms.web.workspace.customer.communication.CommunicationLogger;
import org.openvpms.web.workspace.reporting.statement.StatementEmailProcessor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mail.javamail.JavaMailSender;

public class StatementEmailProcessorTestCase
extends AbstractStatementTest {
    @Autowired
    private CustomerAccountRules customerAccountRules;
    @Autowired
    private DocumentHandlers documentHandlers;
    @Autowired
    private FileNameFormatter formatter;
    @Autowired
    private PracticeRules practiceRules;
    @Autowired
    private TestCustomerFactory customerFactory;
    @Autowired
    private TestDocumentFactory documentFactory;
    @Autowired
    private TestPracticeFactory practiceFactory;
    @Autowired
    private ReportFactory reportFactory;
    @Autowired
    private OpenVPMSApp app;
    private Entity statementTemplate;

    @Before
    public void setUp() {
        this.app.setApplicationContext(this.applicationContext);
        ApplicationInstance.setActive((ApplicationInstance)this.app);
        this.app.doInit();
        Entity settings = (Entity)((TestMailServerBuilder)this.practiceFactory.newMailServer().name("Default Mail Server")).host("localhost").build();
        ((TestPracticeBuilder)this.practiceFactory.updatePractice(this.getPractice()).addEmail("foo@bar.com", new String[0])).mailServer(settings).build(false);
        Document handout1 = (Document)((TestDocumentBuilder)this.documentFactory.newDocument().name("Patient Handout.pdf")).content("dummy pdf content").mimeType("application/pdf").build();
        Entity attachment1 = (Entity)((TestDocumentTemplateBuilder)this.documentFactory.newTemplate().type("act.patientDocumentForm").document(handout1)).build();
        Document handout2 = (Document)((TestDocumentBuilder)this.documentFactory.newDocument().name("Customer Handout.pdf")).content("dummy pdf content").mimeType("application/pdf").build();
        Entity attachment2 = (Entity)((TestDocumentTemplateBuilder)this.documentFactory.newTemplate().type("act.customerDocumentForm").document(handout2)).build();
        Entity emailTemplate = (Entity)this.documentFactory.newEmailTemplate().subject("Statement Email").content("Statement Text").addAttachments(new Entity[]{attachment1, attachment2}).build();
        this.statementTemplate = (Entity)((TestDocumentTemplateBuilder)((TestDocumentTemplateBuilder)this.documentFactory.newTemplate().name("Statement")).type("act.customerAccountOpeningBalance").blankDocument()).emailTemplate(emailTemplate).build();
    }

    @Test
    public void testEmail() {
        JavaMailSender sender = (JavaMailSender)Mockito.mock(JavaMailSender.class);
        MimeMessage mimeMessage = (MimeMessage)Mockito.mock(MimeMessage.class);
        Mockito.when((Object)sender.createMimeMessage()).thenReturn((Object)mimeMessage);
        Date statementDate = this.getDate("2007-01-01");
        Party practice = this.getPractice();
        Party customer = this.getCustomer();
        this.addCustomerEmail(customer);
        IArchetypeService archetypeService = this.getArchetypeService();
        StatementRules rules = new StatementRules(practice, this.getArchetypeService(), this.customerAccountRules);
        Assert.assertFalse((boolean)rules.hasStatement(customer, statementDate));
        List acts = this.getActs(customer, statementDate);
        Assert.assertEquals((long)0L, (long)acts.size());
        Money amount = new Money(100);
        List invoice1 = this.createChargesInvoice((BigDecimal)amount, this.getDatetime("2007-01-01 10:00:00"));
        this.save(invoice1);
        acts = this.getActs(customer, statementDate);
        Assert.assertEquals((long)1L, (long)acts.size());
        this.checkAct((Act)acts.get(0), (FinancialAct)invoice1.get(0), "POSTED");
        ArrayList statements = new ArrayList();
        StatementProcessor processor = new StatementProcessor(statementDate, practice, archetypeService, this.customerAccountRules);
        processor.addListener(statements::add);
        processor.process(customer);
        Assert.assertEquals((long)1L, (long)statements.size());
        Macros macros = (Macros)Mockito.mock(Macros.class);
        DocumentConverter converter = (DocumentConverter)Mockito.mock(DocumentConverter.class);
        EmailTemplateEvaluator evaluator = new EmailTemplateEvaluator((ArchetypeService)archetypeService, this.getLookupService(), macros, this.reportFactory, converter);
        ReporterFactory reporterFactory = new ReporterFactory(this.reportFactory, this.formatter, archetypeService, this.getLookupService());
        MailerFactory mailerFactory = (MailerFactory)Mockito.mock(MailerFactory.class);
        sender = (JavaMailSender)Mockito.mock(JavaMailSender.class);
        mimeMessage = (MimeMessage)Mockito.mock(MimeMessage.class);
        Mockito.when((Object)sender.createMimeMessage()).thenReturn((Object)mimeMessage);
        LocalContext context = new LocalContext();
        Party location = TestHelper.createLocation();
        context.setPractice(practice);
        context.setLocation(location);
        PracticeMailContext mailContext = new PracticeMailContext((Context)context);
        final ArrayList attachments = new ArrayList();
        DefaultMailer mailer = new DefaultMailer((MailContext)mailContext, sender, this.documentHandlers){

            public void addAttachment(Document document) {
                super.addAttachment(document);
                attachments.add(document.getName());
            }
        };
        Mockito.when((Object)mailerFactory.create((MailContext)Mockito.any(), (JavaMailSender)Mockito.any())).thenReturn((Object)mailer);
        CommunicationLogger logger = (CommunicationLogger)Mockito.mock(CommunicationLogger.class);
        StatementEmailProcessor emailProcessor = new StatementEmailProcessor(mailerFactory, evaluator, reporterFactory, practice, location, this.practiceRules, archetypeService, logger, (MailPasswordResolver)Mockito.mock(MailPasswordResolver.class)){

            protected Entity getStatementTemplate(IArchetypeService service) {
                return StatementEmailProcessorTestCase.this.statementTemplate;
            }
        };
        emailProcessor.process((Statement)statements.get(0));
        ((JavaMailSender)Mockito.verify((Object)sender, (VerificationMode)Mockito.times((int)1))).send(mimeMessage);
        Assert.assertEquals((long)3L, (long)attachments.size());
        Assert.assertTrue((boolean)attachments.contains("Statement.pdf"));
        Assert.assertTrue((boolean)attachments.contains("Customer Handout.pdf"));
        Assert.assertTrue((boolean)attachments.contains("Patient Handout.pdf"));
    }

    private void addCustomerEmail(Party customer) {
        customer.getContacts().clear();
        ((TestCustomerBuilder)this.customerFactory.updateCustomer(customer).addEmail("foo@bar.com", new String[]{"BILLING"})).build();
    }
}

