/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.reporting.reminder;

import java.util.Date;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.openvpms.archetype.rules.patient.reminder.ReminderConfiguration;
import org.openvpms.archetype.rules.patient.reminder.ReminderEvent;
import org.openvpms.archetype.rules.patient.reminder.ReminderRule;
import org.openvpms.archetype.rules.patient.reminder.ReminderTestHelper;
import org.openvpms.archetype.rules.patient.reminder.ReminderTypes;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.archetype.test.builder.party.TestPhoneContactBuilder;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.party.Contact;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.im.print.IMPrinterFactory;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.workspace.customer.communication.CommunicationLogger;
import org.openvpms.web.workspace.reporting.reminder.AbstractPatientReminderProcessorTest;
import org.openvpms.web.workspace.reporting.reminder.PatientReminders;
import org.openvpms.web.workspace.reporting.reminder.ReminderListProcessor;

public class ReminderListProcessorTestCase
extends AbstractPatientReminderProcessorTest<PatientReminders> {
    private ReminderListProcessor processor;

    public ReminderListProcessorTestCase() {
        super("contact.phoneNumber");
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        Entity documentTemplate = ReminderTestHelper.createDocumentTemplate((boolean)false, (boolean)true);
        this.reminderFactory.updateReminderType(this.reminderType).newCount().count(0).interval(0, DateUnits.WEEKS).template(documentTemplate).newRule().sms().sendTo(ReminderRule.SendTo.ANY).add().add().build();
        IArchetypeService service = this.getArchetypeService();
        ReminderTypes reminderTypes = new ReminderTypes((ArchetypeService)service);
        CommunicationLogger logger = (CommunicationLogger)Mockito.mock(CommunicationLogger.class);
        ReminderConfiguration config = this.createConfiguration();
        Party location = TestHelper.createLocation();
        IMPrinterFactory printerFactory = (IMPrinterFactory)Mockito.mock(IMPrinterFactory.class);
        this.processor = new ReminderListProcessor(reminderTypes, this.reminderRules, this.patientRules, location, this.practice, (ArchetypeService)service, config, printerFactory, logger, this.actionFactory, new HelpContext("foo", null)){

            protected void print(List<Act> reminders) {
            }
        };
    }

    @Override
    @Test
    public void testNoContact() {
        Date tomorrow = DateRules.getTomorrow();
        Act item = this.createReminderItem(DateRules.getToday(), tomorrow);
        Act reminder = this.createReminder(tomorrow, this.reminderType, item);
        Object reminders = this.prepare(item, reminder, null);
        List events = reminders.getReminders();
        Assert.assertEquals((long)1L, (long)events.size());
        Assert.assertEquals((long)0L, (long)reminders.getErrors().size());
        this.checkItem(((ReminderEvent)events.get(0)).getItem(), "PENDING", null);
    }

    @Test
    public void testReminderContact() {
        Contact phone1 = ((TestPhoneContactBuilder)this.contactFactory.newPhone().phone("1").purposes(new String[]{"REMINDER"})).build();
        Contact phone2 = this.contactFactory.createPhone("2");
        Contact phone3 = this.contactFactory.createPhone("3");
        this.customer.addContact(phone1);
        this.customer.addContact(phone2);
        this.customer.addContact(phone3);
        this.checkList(null, phone1);
    }

    @Test
    public void testOverrideContact() {
        Contact phone1 = ((TestPhoneContactBuilder)((TestPhoneContactBuilder)this.contactFactory.newPhone().phone("1").sms().preferred()).purposes(new String[]{"REMINDER"})).build();
        Contact phone2 = this.contactFactory.newPhone().phone("2").sms().build();
        this.customer.addContact(phone1);
        this.customer.addContact(phone2);
        this.checkList(phone2, phone2);
    }

    protected ReminderListProcessor getProcessor() {
        return this.processor;
    }

    @Override
    protected Act createReminderItem(Date send, Date dueDate) {
        return (Act)this.reminderFactory.newListReminder().sendDate(send).dueDate(dueDate).build();
    }

    private void checkList(Contact contact, Contact to) {
        PatientReminders reminders = this.prepare(contact);
        this.processor.process(reminders);
        Assert.assertEquals((long)1L, (long)reminders.getProcessed());
        for (ReminderEvent event : reminders.getReminders()) {
            Assert.assertEquals((Object)to, (Object)event.getContact());
        }
    }

    private PatientReminders prepare(Contact contact) {
        Date tomorrow = DateRules.getTomorrow();
        Act item = this.createReminderItem(DateRules.getToday(), tomorrow);
        Act reminder = this.createReminder(tomorrow, this.reminderType, item);
        return this.prepare(item, reminder, contact);
    }
}

