/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.reporting.reminder;

import java.util.Date;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.openvpms.archetype.rules.patient.reminder.ReminderConfiguration;
import org.openvpms.archetype.rules.patient.reminder.ReminderEvent;
import org.openvpms.archetype.rules.patient.reminder.ReminderRule;
import org.openvpms.archetype.rules.patient.reminder.ReminderTestHelper;
import org.openvpms.archetype.rules.patient.reminder.ReminderTypes;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.party.Contact;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.workspace.customer.communication.CommunicationLogger;
import org.openvpms.web.workspace.reporting.reminder.AbstractPatientReminderProcessorTest;
import org.openvpms.web.workspace.reporting.reminder.PatientReminders;
import org.openvpms.web.workspace.reporting.reminder.ReminderExportProcessor;

public class ReminderExportProcessorTestCase
extends AbstractPatientReminderProcessorTest<PatientReminders> {
    private ReminderExportProcessor processor;

    public ReminderExportProcessorTestCase() {
        super("contact.location");
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        Entity documentTemplate = ReminderTestHelper.createDocumentTemplate((boolean)false, (boolean)false);
        this.reminderFactory.updateReminderType(this.reminderType).newCount().count(0).interval(0, DateUnits.WEEKS).template(documentTemplate).newRule().export().sendTo(ReminderRule.SendTo.ANY).add().add().build();
        IArchetypeService service = this.getArchetypeService();
        ReminderTypes reminderTypes = new ReminderTypes((ArchetypeService)service);
        CommunicationLogger logger = (CommunicationLogger)Mockito.mock(CommunicationLogger.class);
        ReminderConfiguration config = this.createConfiguration();
        Party location = TestHelper.createLocation();
        this.processor = new ReminderExportProcessor(reminderTypes, this.reminderRules, this.patientRules, location, this.practice, service, config, logger, this.actionFactory){

            protected void export(List<ReminderEvent> reminders) {
            }
        };
    }

    @Test
    public void testReminderContact() {
        Contact location1 = this.createLocation("1 St Georges Rd", true, "REMINDER");
        Contact location2 = this.createLocation("2 Keon St", false, null);
        Contact location3 = this.createLocation("3 Hutton St", false, null);
        this.customer.addContact(location1);
        this.customer.addContact(location2);
        this.customer.addContact(location3);
        this.checkExport(null, location1);
    }

    @Test
    public void testOverrideContact() {
        Contact location1 = this.createLocation("1 St Georges Rd", true, "REMINDER");
        Contact location2 = this.createLocation("2 Keon St", false, null);
        this.customer.addContact(location1);
        this.customer.addContact(location2);
        this.checkExport(location2, location2);
    }

    protected ReminderExportProcessor getProcessor() {
        return this.processor;
    }

    @Override
    protected Act createReminderItem(Date send, Date dueDate) {
        return (Act)this.reminderFactory.newExportReminder().sendDate(send).dueDate(dueDate).build();
    }

    private void checkExport(Contact contact, Contact to) {
        PatientReminders reminders = this.prepare(contact);
        this.processor.process(reminders);
        Assert.assertEquals((long)1L, (long)reminders.getProcessed());
        for (ReminderEvent event : reminders.getReminders()) {
            Assert.assertEquals((Object)to, (Object)event.getContact());
        }
    }

    private PatientReminders prepare(Contact contact) {
        Date tomorrow = DateRules.getTomorrow();
        Act item = (Act)this.reminderFactory.newSMSReminder().sendDate(DateRules.getToday()).dueDate(tomorrow).build();
        Act reminder = this.createReminder(tomorrow, this.reminderType, item);
        return this.prepare(item, reminder, contact);
    }
}

