/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.reporting.reminder;

import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.patient.PatientRules;
import org.openvpms.archetype.rules.patient.reminder.ReminderConfiguration;
import org.openvpms.archetype.rules.patient.reminder.ReminderEvent;
import org.openvpms.archetype.rules.patient.reminder.ReminderRules;
import org.openvpms.archetype.rules.patient.reminder.ReminderType;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.test.builder.customer.TestCustomerFactory;
import org.openvpms.archetype.test.builder.party.TestContactFactory;
import org.openvpms.archetype.test.builder.party.TestLocationContactBuilder;
import org.openvpms.archetype.test.builder.patient.TestPatientBuilder;
import org.openvpms.archetype.test.builder.patient.TestPatientFactory;
import org.openvpms.archetype.test.builder.patient.reminder.TestReminderBuilder;
import org.openvpms.archetype.test.builder.patient.reminder.TestReminderConfigurationBuilder;
import org.openvpms.archetype.test.builder.patient.reminder.TestReminderFactory;
import org.openvpms.archetype.test.builder.patient.reminder.TestReminderTypeBuilder;
import org.openvpms.archetype.test.builder.practice.TestLocationBuilder;
import org.openvpms.archetype.test.builder.practice.TestPracticeBuilder;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.component.business.domain.im.common.EntityLink;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Contact;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.action.ActionFactory;
import org.openvpms.web.test.AbstractAppTest;
import org.openvpms.web.workspace.reporting.reminder.PatientReminderProcessor;
import org.openvpms.web.workspace.reporting.reminder.PatientReminders;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractPatientReminderProcessorTest<T extends PatientReminders>
extends AbstractAppTest {
    @Autowired
    protected ActionFactory actionFactory;
    @Autowired
    protected PatientRules patientRules;
    @Autowired
    protected ReminderRules reminderRules;
    @Autowired
    protected TestContactFactory contactFactory;
    @Autowired
    protected TestCustomerFactory customerFactory;
    @Autowired
    protected TestPatientFactory patientFactory;
    @Autowired
    protected TestPracticeFactory practiceFactory;
    @Autowired
    protected TestReminderFactory reminderFactory;
    protected Party customer;
    protected Party patient;
    protected Entity reminderType;
    protected Party practice;
    private final String archetype;

    public AbstractPatientReminderProcessorTest(String archetype) {
        this.archetype = archetype;
    }

    @Before
    public void setUp() {
        super.setUp();
        this.customer = this.customerFactory.createCustomer("J", "Bloggs");
        this.patient = (Party)((TestPatientBuilder)this.patientFactory.newPatient().name("Spot")).owner(this.customer).build();
        Entity settings = (Entity)this.practiceFactory.newMailServer().host("localhost").build();
        this.practice = (Party)((TestPracticeBuilder)((TestPracticeBuilder)this.practiceFactory.newPractice().name("Test Practice")).addEmail("foo@bar.com", new String[0])).mailServer(settings).build(false);
        this.reminderType = (Entity)((TestReminderTypeBuilder)this.reminderFactory.newReminderType().name("Vaccination")).defaultInterval(1, DateUnits.MONTHS).cancelInterval(1, DateUnits.DAYS).build();
    }

    @Test
    public void testNoContact() {
        this.checkNoContact();
    }

    @Test
    public void testOutOfDate() {
        this.checkCancelItem(DateRules.getDate((Date)new Date(), (int)-1, (DateUnits)DateUnits.MONTHS), "Reminder not processed in time");
    }

    @Test
    public void testInactiveReminderType() {
        this.reminderType.setActive(false);
        this.save((IMObject)this.reminderType);
        this.checkCancelItem(DateRules.getToday(), "Reminder Type is inactive");
    }

    @Test
    public void testDeceasedPatient() {
        this.patientRules.setDeceased(this.patient);
        this.checkCancelItem(DateRules.getToday(), "Patient is deceased");
    }

    @Test
    public void testInactivePatient() {
        this.patient.setActive(false);
        this.checkCancelItem(DateRules.getToday(), "Patient is inactive");
    }

    @Test
    public void testInactiveCustomer() {
        this.customer.setActive(false);
        this.checkCancelItem(DateRules.getToday(), "Customer is inactive");
    }

    protected void checkNoContact() {
        Date tomorrow = DateRules.getTomorrow();
        Act item = this.createReminderItem(DateRules.getToday(), tomorrow);
        Act reminder = this.createReminder(tomorrow, this.reminderType, item);
        T reminders = this.prepare(item, reminder, null);
        Assert.assertEquals((long)1L, (long)reminders.getErrors().size());
        Assert.assertEquals((Object)"IN_PROGRESS", (Object)reminder.getStatus());
        this.checkItem(item, "ERROR", "Customer has no " + DescriptorHelper.getDisplayName((String)this.archetype, (ArchetypeService)this.getArchetypeService()));
    }

    protected void checkMissingReminderCount(Contact contact) {
        this.customer.addContact(contact);
        Date tomorrow = DateRules.getTomorrow();
        Act item = this.createReminderItem(DateRules.getToday(), tomorrow);
        Entity invalidReminderType = (Entity)((TestReminderTypeBuilder)this.reminderFactory.newReminderType().name("Xremindertype")).defaultInterval(1, DateUnits.MONTHS).cancelInterval(1, DateUnits.DAYS).build();
        Act reminder = this.createReminder(tomorrow, invalidReminderType, item);
        T reminders = this.prepare(item, reminder, null);
        Assert.assertEquals((long)1L, (long)reminders.getErrors().size());
        Assert.assertEquals((Object)"IN_PROGRESS", (Object)reminder.getStatus());
        this.checkItem(item, "ERROR", "The Reminder Type 'Xremindertype' has no Reminder Count 0");
    }

    protected void checkMissingReminderCountTemplate(Contact contact) {
        this.customer.addContact(contact);
        Date tomorrow = DateRules.getTomorrow();
        Act item = this.createReminderItem(DateRules.getToday(), tomorrow);
        IMObjectBean bean = this.getBean((IMObject)this.reminderType);
        for (Entity count : bean.getTargets("counts", Entity.class)) {
            IMObjectBean countBean = this.getBean((IMObject)count);
            EntityLink template = (EntityLink)countBean.getObject("template", EntityLink.class);
            if (template == null) continue;
            countBean.removeValue("template", (IMObject)template);
            countBean.save();
        }
        Act reminder = this.createReminder(tomorrow, this.reminderType, item);
        T reminders = this.prepare(item, reminder, null);
        Assert.assertEquals((long)1L, (long)reminders.getErrors().size());
        Assert.assertEquals((Object)"IN_PROGRESS", (Object)reminder.getStatus());
        this.checkItem(item, "ERROR", "Cannot print reminder. It does not have a document template");
    }

    protected abstract PatientReminderProcessor<T> getProcessor();

    protected abstract Act createReminderItem(Date var1, Date var2);

    protected void checkCancelItem(Date send, String message) {
        Date tomorrow = DateRules.getTomorrow();
        Act item = this.createReminderItem(send, tomorrow);
        Act reminder = this.createReminder(tomorrow, this.reminderType, item);
        ReminderEvent event = new ReminderEvent(reminder, item, this.patient, this.customer);
        PatientReminderProcessor<T> processor = this.getProcessor();
        PatientReminders reminders = processor.prepare(Collections.singletonList(event), ReminderType.GroupBy.CUSTOMER, new Date(), false);
        Assert.assertEquals((long)1L, (long)reminders.getCancelled().size());
        Assert.assertEquals((Object)"IN_PROGRESS", (Object)reminder.getStatus());
        this.checkItem(item, "CANCELLED", message);
        Assert.assertTrue((boolean)processor.complete(reminders));
    }

    protected void checkItem(Act item, String status, String message) {
        Assert.assertEquals((Object)status, (Object)item.getStatus());
        Assert.assertEquals((Object)message, (Object)this.getBean((IMObject)item).getString("error"));
    }

    protected T prepare(Act item, Act reminder, Contact contact) {
        ReminderEvent event = new ReminderEvent(reminder, item, this.patient, this.customer, contact);
        return this.prepare(ReminderType.GroupBy.CUSTOMER, event);
    }

    protected T prepare(ReminderType.GroupBy groupBy, ReminderEvent ... events) {
        return (T)this.getProcessor().prepare(Arrays.asList(events), groupBy, new Date(), false);
    }

    protected ReminderConfiguration createConfiguration() {
        Entity config = (Entity)this.newReminderConfiguration().build(false);
        return new ReminderConfiguration((IMObject)config, (ArchetypeService)this.getArchetypeService());
    }

    protected TestReminderConfigurationBuilder newReminderConfiguration() {
        Party location = (Party)((TestLocationBuilder)((TestLocationBuilder)this.practiceFactory.newLocation().name("Vets R Us")).addPhone("9123 4567", new String[0])).build();
        return this.reminderFactory.newReminderConfiguration().emailAttachments(false).location(location);
    }

    protected Contact createLocation(String address, boolean preferred, String purpose) {
        TestLocationContactBuilder builder = (TestLocationContactBuilder)this.contactFactory.newLocation().address(address).suburbCode("THORNBURY").stateCode("VIC").postcode("3071").preferred(preferred);
        if (purpose != null) {
            builder.purposes(new String[]{purpose});
        }
        return builder.build();
    }

    protected Act createReminder(Date dueDate, Entity reminderType, Act item) {
        return this.createReminder(dueDate, this.patient, reminderType, item);
    }

    protected Act createReminder(Date dueDate, Party patient, Entity reminderType, Act item) {
        return (Act)((TestReminderBuilder)this.reminderFactory.newReminder().dueDate(dueDate).patient(patient)).reminderType(reminderType).addItems(new Act[]{item}).build();
    }
}

