/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.reporting.eftpos;

import java.math.BigDecimal;
import java.util.Collection;
import nextapp.echo2.app.ApplicationInstance;
import nextapp.echo2.app.Component;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.finance.eft.EFTPOSArchetypes;
import org.openvpms.archetype.test.builder.customer.TestCustomerFactory;
import org.openvpms.archetype.test.builder.customer.account.TestCustomerAccountFactory;
import org.openvpms.archetype.test.builder.eft.TestEFTPOSPaymentBuilder;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.archetype.Archetypes;
import org.openvpms.web.echo.dialog.ErrorDialog;
import org.openvpms.web.echo.dialog.PopupDialog;
import org.openvpms.web.echo.dialog.PopupWindow;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.test.AbstractAppTest;
import org.openvpms.web.test.EchoTestHelper;
import org.openvpms.web.workspace.reporting.eftpos.EFTPOSCRUDWindow;
import org.springframework.beans.factory.annotation.Autowired;

public class EFTPOSCRUDWindowTestCase
extends AbstractAppTest {
    @Autowired
    private TestCustomerFactory customerFactory;
    @Autowired
    private TestCustomerAccountFactory accountFactory;
    @Autowired
    private TestPracticeFactory practiceFactory;

    @Test
    public void testCreateEditAndDeleteForbidden() {
        EFTPOSCRUDWindow window = new EFTPOSCRUDWindow(Archetypes.create((Collection)EFTPOSArchetypes.TRANSACTIONS, Act.class), (Context)new LocalContext(), new HelpContext("foo", null));
        window.create();
        Assert.assertNull((Object)EchoTestHelper.findComponent((Component)ApplicationInstance.getActive().getDefaultWindow(), PopupWindow.class));
        Entity terminal = this.practiceFactory.createEFTPOSTerminal();
        FinancialAct payment = (FinancialAct)((TestEFTPOSPaymentBuilder)((TestEFTPOSPaymentBuilder)((TestEFTPOSPaymentBuilder)((TestEFTPOSPaymentBuilder)((TestEFTPOSPaymentBuilder)this.accountFactory.newEFTPOSPayment().customer(this.customerFactory.createCustomer())).amount(BigDecimal.TEN)).terminal(terminal)).location(this.practiceFactory.createLocation())).status("IN_PROGRESS")).build();
        window.setObject((Act)payment);
        window.edit();
        ErrorDialog dialog1 = (ErrorDialog)this.findComponent(ErrorDialog.class);
        Assert.assertEquals((Object)"Can't edit EFTPOS Payment with status IN_PROGRESS", (Object)dialog1.getMessage());
        EchoTestHelper.fireDialogButton((PopupDialog)dialog1, (String)"ok");
        window.delete();
        ErrorDialog dialog2 = (ErrorDialog)this.findComponent(ErrorDialog.class);
        Assert.assertEquals((Object)"Can't delete EFTPOS Payment with status IN_PROGRESS", (Object)dialog2.getMessage());
    }
}

