/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.reporting.charge.wip;

import java.util.ArrayList;
import java.util.List;
import nextapp.echo2.app.Component;
import org.hibernate.validator.internal.util.Contracts;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.openvpms.archetype.test.builder.customer.account.TestCustomerAccountFactory;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.archetype.Archetypes;
import org.openvpms.web.component.im.query.QueryBrowser;
import org.openvpms.web.component.print.PrintDialog;
import org.openvpms.web.echo.dialog.ConfirmationDialog;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.test.AbstractAppTest;
import org.openvpms.web.test.EchoTestHelper;
import org.openvpms.web.workspace.reporting.charge.wip.IncompleteChargesCRUDWindow;
import org.springframework.beans.factory.annotation.Autowired;

public class IncompleteChargesCRUDWindowTestCase
extends AbstractAppTest {
    private final List<String> errors = new ArrayList<String>();
    @Autowired
    private TestCustomerAccountFactory accountFactory;
    @Autowired
    private TestPracticeFactory practiceFactory;
    private Context context;

    @Before
    public void setUp() {
        super.setUp();
        this.context = new LocalContext();
        this.context.setPractice(this.practiceFactory.getPractice());
        this.context.setLocation(this.practiceFactory.createLocation());
        this.initErrorHandler(this.errors);
    }

    @Test
    public void testPost() {
        this.checkPost(this.accountFactory.createInvoice(10, "IN_PROGRESS"));
        this.checkPost(this.accountFactory.createCounterSale(10, "IN_PROGRESS"));
        this.checkPost(this.accountFactory.createCredit(10, "IN_PROGRESS"));
    }

    private void checkPost(FinancialAct charge) {
        this.errors.clear();
        Archetypes archetypes = Archetypes.create((String)"act.customerAccountCharges*", FinancialAct.class);
        QueryBrowser browser = (QueryBrowser)Mockito.mock(QueryBrowser.class);
        IncompleteChargesCRUDWindow window = new IncompleteChargesCRUDWindow(archetypes, browser, this.context, new HelpContext("foo", null));
        window.setObject(charge);
        EchoTestHelper.fireButton((Component)window.getComponent(), (String)"button.post");
        String displayName = this.getDisplayName((IMObject)charge);
        EchoTestHelper.findMessageDialogAndFireButton(ConfirmationDialog.class, (String)("Finalise " + displayName), (String)("Are you sure you want to Finalise the " + displayName + "?"), (String)"ok");
        FinancialAct reloaded = (FinancialAct)this.get((IMObject)charge);
        Assert.assertEquals((Object)"POSTED", (Object)reloaded.getStatus());
        Assert.assertEquals((Object)reloaded, (Object)window.getObject());
        if (charge.isA(new String[]{"act.customerAccountChargesInvoice", "act.customerAccountChargesCounter"})) {
            EchoTestHelper.findMessageDialogAndFireButton(ConfirmationDialog.class, (String)"Pay Account", (String)"Do you wish to pay the account?", (String)"yes");
        } else {
            Contracts.assertNotNull((Object)EchoTestHelper.findWindowPane(PrintDialog.class));
        }
        Assert.assertTrue((boolean)this.errors.isEmpty());
    }
}

