/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.reporting.charge;

import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.test.builder.customer.TestCustomerFactory;
import org.openvpms.archetype.test.builder.customer.account.TestCounterSaleBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestCustomerAccountFactory;
import org.openvpms.archetype.test.builder.customer.account.TestCustomerChargeBuilder;
import org.openvpms.archetype.test.builder.patient.TestPatientFactory;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.archetype.test.builder.product.TestProductFactory;
import org.openvpms.archetype.test.builder.user.TestUserFactory;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.user.User;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.im.query.QueryTestHelper;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.im.query.ResultSetIterator;
import org.openvpms.web.test.AbstractAppTest;
import org.openvpms.web.workspace.reporting.charge.AbstractChargesQuery;
import org.openvpms.web.workspace.reporting.charge.wip.IncompleteChargesQuery;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractChargesQueryTest
extends AbstractAppTest {
    private final boolean selectsPosted;
    @Autowired
    private TestCustomerAccountFactory accountFactory;
    @Autowired
    private TestCustomerFactory customerFactory;
    @Autowired
    private TestPatientFactory patientFactory;
    @Autowired
    private TestPracticeFactory practiceFactory;
    @Autowired
    private TestProductFactory productFactory;
    @Autowired
    private TestUserFactory userFactory;
    private Party customer;
    private Party patient;
    private Product product;

    protected AbstractChargesQueryTest(boolean selectsPosted) {
        this.selectsPosted = selectsPosted;
    }

    @Before
    public void setUp() {
        super.setUp();
        this.customer = this.customerFactory.createCustomer();
        this.patient = this.patientFactory.createPatient();
        this.product = this.productFactory.createMedication();
    }

    @Test
    public void testEmptyQuery() {
        LocalContext context = new LocalContext();
        Party location1 = this.practiceFactory.createLocation();
        Party location2 = this.practiceFactory.createLocation();
        Party location3 = this.practiceFactory.createLocation();
        Party practice = (Party)this.practiceFactory.newPractice().locations(new Party[]{location1, location2, location3}).build();
        User user = (User)this.userFactory.newUser().addLocations(new Party[]{location1}).build();
        context.setUser(user);
        context.setPractice(practice);
        AbstractChargesQuery query = this.createQuery((Context)context);
        query.setLocation(location1);
        QueryTestHelper.checkEmpty((Query)query);
        Act invoice = this.createInvoice(location2, null, "IN_PROGRESS");
        Act counter = this.createCounter(location2, "IN_PROGRESS");
        Act credit = this.createCredit(location3, null, "IN_PROGRESS");
        this.save((IMObject)invoice);
        this.save((IMObject)counter);
        this.save((IMObject)credit);
        QueryTestHelper.checkEmpty((Query)query);
    }

    @Test
    public void testQueryByLocation() {
        LocalContext context = new LocalContext();
        Party location1 = this.practiceFactory.createLocation();
        Party location2 = this.practiceFactory.createLocation();
        Party location3 = this.practiceFactory.createLocation();
        Party practice = (Party)this.practiceFactory.newPractice().locations(new Party[]{location1, location2, location3}).build();
        User user = (User)this.userFactory.newUser().addLocations(new Party[]{location1, location2}).build();
        context.setUser(user);
        context.setPractice(practice);
        AbstractChargesQuery query = this.createQuery((Context)context);
        query.setLocation(null);
        this.checkNoLocationInvoices(query, IncompleteChargesQuery.SHORT_NAMES);
        Act invoice = this.createInvoice(location1, null, "IN_PROGRESS");
        Act counter = this.createCounter(location2, "IN_PROGRESS");
        Act credit = this.createCredit(location3, null, "IN_PROGRESS");
        List refs1 = QueryTestHelper.getObjectRefs((Query)query);
        Assert.assertTrue((boolean)refs1.contains(invoice.getObjectReference()));
        Assert.assertTrue((boolean)refs1.contains(counter.getObjectReference()));
        Assert.assertFalse((boolean)refs1.contains(credit.getObjectReference()));
        query.setLocation(location1);
        List refs2 = QueryTestHelper.getObjectRefs((Query)query);
        Assert.assertTrue((boolean)refs2.contains(invoice.getObjectReference()));
        Assert.assertFalse((boolean)refs2.contains(counter.getObjectReference()));
        Assert.assertFalse((boolean)refs2.contains(credit.getObjectReference()));
    }

    @Test
    public void testQueryByLocationForUserWithNoLocations() {
        LocalContext context = new LocalContext();
        Party location1 = this.practiceFactory.createLocation();
        Party location2 = this.practiceFactory.createLocation();
        Party location3 = this.practiceFactory.createLocation();
        User user = this.userFactory.createUser();
        Party practice = (Party)this.practiceFactory.newPractice().locations(new Party[]{location1, location2}).build();
        context.setUser(user);
        context.setPractice(practice);
        AbstractChargesQuery query = this.createQuery((Context)context);
        query.setLocation(null);
        this.checkNoLocationInvoices(query, IncompleteChargesQuery.SHORT_NAMES);
        Act invoice = this.createInvoice(location1, null, "IN_PROGRESS");
        Act counter = this.createCounter(location2, "IN_PROGRESS");
        Act credit = this.createCredit(location3, null, "IN_PROGRESS");
        List refs1 = QueryTestHelper.getObjectRefs((Query)query);
        Assert.assertTrue((boolean)refs1.contains(invoice.getObjectReference()));
        Assert.assertTrue((boolean)refs1.contains(counter.getObjectReference()));
        Assert.assertFalse((boolean)refs1.contains(credit.getObjectReference()));
        query.setLocation(location1);
        List refs2 = QueryTestHelper.getObjectRefs((Query)query);
        Assert.assertTrue((boolean)refs2.contains(invoice.getObjectReference()));
        Assert.assertFalse((boolean)refs2.contains(counter.getObjectReference()));
        Assert.assertFalse((boolean)refs2.contains(credit.getObjectReference()));
    }

    @Test
    public void testQueryByStatus() {
        LocalContext context = new LocalContext();
        Party location1 = this.practiceFactory.createLocation();
        User user = (User)this.userFactory.newUser().addLocations(new Party[]{location1}).build();
        context.setUser(user);
        AbstractChargesQuery query = this.createQuery((Context)context);
        Act inProgress = this.createInvoice(location1, null, "IN_PROGRESS");
        Act completed = this.createInvoice(location1, null, "COMPLETED");
        Act onHold = this.createInvoice(location1, null, "ON_HOLD");
        Act posted = this.createInvoice(location1, null, "POSTED");
        List refs1 = QueryTestHelper.getObjectRefs((Query)query);
        Assert.assertTrue((boolean)refs1.contains(inProgress.getObjectReference()));
        Assert.assertTrue((boolean)refs1.contains(completed.getObjectReference()));
        Assert.assertTrue((boolean)refs1.contains(onHold.getObjectReference()));
        Assert.assertEquals((Object)this.selectsPosted, (Object)refs1.contains(posted.getObjectReference()));
        query.setStatus("IN_PROGRESS");
        List refs2 = QueryTestHelper.getObjectRefs((Query)query);
        Assert.assertTrue((boolean)refs2.contains(inProgress.getObjectReference()));
        Assert.assertFalse((boolean)refs2.contains(completed.getObjectReference()));
        Assert.assertFalse((boolean)refs2.contains(onHold.getObjectReference()));
        Assert.assertFalse((boolean)refs2.contains(posted.getObjectReference()));
    }

    @Test
    public void testQueryByClinician() {
        LocalContext context = new LocalContext();
        Party location1 = this.practiceFactory.createLocation();
        User user = this.userFactory.createUser();
        context.setUser(user);
        User clinician1 = this.userFactory.createClinician();
        User clinician2 = this.userFactory.createClinician();
        Act invoice1 = this.createInvoice(location1, clinician1, "IN_PROGRESS");
        Act invoice2 = this.createInvoice(location1, clinician2, "COMPLETED");
        Act invoice3 = this.createInvoice(location1, null, "ON_HOLD");
        Act invoice4 = this.createInvoice(location1, clinician1, "POSTED");
        Act credit1 = this.createCredit(location1, clinician1, "IN_PROGRESS");
        Act credit2 = this.createCredit(location1, clinician2, "POSTED");
        Act counter1 = this.createCounter(location1, "IN_PROGRESS");
        Act counter2 = this.createCounter(location1, "POSTED");
        AbstractChargesQuery query = this.createQuery((Context)context);
        query.setClinician(clinician1);
        List refs1 = QueryTestHelper.getObjectRefs((Query)query);
        Assert.assertTrue((boolean)refs1.contains(invoice1.getObjectReference()));
        Assert.assertEquals((Object)this.selectsPosted, (Object)refs1.contains(invoice4.getObjectReference()));
        Assert.assertTrue((boolean)refs1.contains(credit1.getObjectReference()));
        Assert.assertFalse((boolean)refs1.contains(invoice2.getObjectReference()));
        Assert.assertFalse((boolean)refs1.contains(invoice3.getObjectReference()));
        Assert.assertFalse((boolean)refs1.contains(credit2.getObjectReference()));
        Assert.assertFalse((boolean)refs1.contains(counter1.getObjectReference()));
        Assert.assertFalse((boolean)refs1.contains(counter2.getObjectReference()));
        query.setClinician(clinician2);
        List refs2 = QueryTestHelper.getObjectRefs((Query)query);
        Assert.assertTrue((boolean)refs2.contains(invoice2.getObjectReference()));
        Assert.assertEquals((Object)this.selectsPosted, (Object)refs2.contains(credit2.getObjectReference()));
        Assert.assertFalse((boolean)refs2.contains(invoice1.getObjectReference()));
        Assert.assertFalse((boolean)refs2.contains(invoice3.getObjectReference()));
        Assert.assertFalse((boolean)refs2.contains(invoice4.getObjectReference()));
        Assert.assertFalse((boolean)refs2.contains(credit1.getObjectReference()));
        Assert.assertFalse((boolean)refs2.contains(counter1.getObjectReference()));
        Assert.assertFalse((boolean)refs2.contains(counter2.getObjectReference()));
    }

    protected abstract AbstractChargesQuery createQuery(Context var1);

    private void checkNoLocationInvoices(AbstractChargesQuery query, String ... shortNames) {
        ResultSet set = query.query();
        ResultSetIterator iterator = new ResultSetIterator(set);
        while (iterator.hasNext()) {
            Act act = (Act)iterator.next();
            IMObjectBean bean = this.getBean((IMObject)act);
            Assert.assertTrue((boolean)bean.isA(shortNames));
            Assert.assertNull((Object)bean.getTargetRef("location"));
        }
    }

    private Act createInvoice(Party location, User clinician, String status) {
        return this.createCharge((TestCustomerChargeBuilder<?, ?>)this.accountFactory.newInvoice(), location, clinician, status);
    }

    private Act createCredit(Party location, User clinician, String status) {
        return this.createCharge((TestCustomerChargeBuilder<?, ?>)this.accountFactory.newCredit(), location, clinician, status);
    }

    private Act createCharge(TestCustomerChargeBuilder<?, ?> builder, Party location, User clinician, String status) {
        boolean counter = builder instanceof TestCounterSaleBuilder;
        return (Act)((TestCustomerChargeBuilder)((TestCustomerChargeBuilder)((TestCustomerChargeBuilder)builder.customer(this.customer)).location(location)).clinician(clinician).status(status)).item().patient(counter ? null : this.patient).product(this.product).add().build();
    }

    private Act createCounter(Party location, String status) {
        return this.createCharge((TestCustomerChargeBuilder<?, ?>)this.accountFactory.newCounterSale(), location, null, status);
    }
}

