/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.vetcheck;

import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.openvpms.archetype.rules.patient.MedicalRecordRules;
import org.openvpms.archetype.rules.practice.PracticeService;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.archetype.test.builder.customer.TestCustomerBuilder;
import org.openvpms.archetype.test.builder.customer.TestCustomerFactory;
import org.openvpms.archetype.test.builder.patient.TestPatientBuilder;
import org.openvpms.archetype.test.builder.patient.TestPatientFactory;
import org.openvpms.archetype.test.builder.user.TestUserFactory;
import org.openvpms.component.business.service.singleton.SingletonService;
import org.openvpms.component.business.service.singleton.SingletonServiceImpl;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.domain.internal.factory.DomainService;
import org.openvpms.web.workspace.patient.vetcheck.VetCheckLink;
import org.openvpms.web.workspace.patient.vetcheck.VetCheckRules;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.PlatformTransactionManager;

public class VetCheckRulesTestCase
extends ArchetypeServiceTest {
    @Autowired
    private DomainService domainService;
    @Autowired
    private MedicalRecordRules medicalRecordRules;
    @Autowired
    private PlatformTransactionManager transactionManager;
    @Autowired
    private TestCustomerFactory customerFactory;
    @Autowired
    private TestPatientFactory patientFactory;
    @Autowired
    private TestUserFactory userFactory;
    private VetCheckRules rules;
    private Party practice;

    @Before
    public void setUp() {
        this.practice = (Party)this.create("party.organisationPractice", Party.class);
        PracticeService practiceService = (PracticeService)Mockito.mock(PracticeService.class);
        Mockito.when((Object)practiceService.getPractice()).thenReturn((Object)this.practice);
        this.rules = new VetCheckRules(this.domainService, this.medicalRecordRules, (ArchetypeService)this.getArchetypeService(), this.transactionManager, practiceService, (SingletonService)new SingletonServiceImpl((ArchetypeService)this.getArchetypeService(), this.transactionManager));
    }

    @Test
    public void testIsVetCheckEnabled() {
        Assert.assertFalse((boolean)this.rules.isVetCheckEnabled());
        IMObjectBean bean = this.getBean((IMObject)this.practice);
        bean.setValue("enableVetCheck", (Object)true);
        Assert.assertTrue((boolean)this.rules.isVetCheckEnabled());
    }

    @Test
    public void testGetURL() {
        Assert.assertEquals((Object)"https://plugin.vetcheck.it", (Object)this.rules.getURL());
    }

    @Test
    public void testGetPatientURL() {
        Party customer = (Party)((TestCustomerBuilder)((TestCustomerBuilder)((TestCustomerBuilder)this.customerFactory.newCustomer().lastName("Smith").firstName("J").addAddress("1 Smith Ave", "PRESTON", "VIC", "3072", new String[0])).addMobilePhone("0412345678")).addEmail("foo@bar.com", new String[0])).build();
        Party patient = (Party)((TestPatientBuilder)this.patientFactory.newPatient().name("Fido")).owner(customer).sex("MALE").addMicrochip("12345").colour("Black").dateOfBirth(TestHelper.getDate((String)"2021-08-01")).build();
        String url = "https://plugin.vetcheck.it?client_first_name=J&client_last_name=Smith&client_address=1%20Smith%20Ave,%20Preston%20Vic%203072&client_phone=0412345678&client_email_address=foo@bar.com&patient_id=" + patient.getId() + "&pet_name=Fido&pet_species=Canine&pet_breed&pet_sex=MALE%20Entire&pet_dob=2021-08-01&pet_weight&pet_color=Black&pet_microchip=12345";
        Assert.assertEquals((Object)url, (Object)this.rules.getURL(patient));
    }

    @Test
    public void testAddLink() {
        Party patient = this.patientFactory.createPatient();
        User clinician = this.userFactory.createClinician();
        String data = "share_link=https://vtck.it/v3/d1&document_type=handout&title=A Parasiticide Comparison Chart&patient_id=" + patient.getId();
        VetCheckLink link = this.rules.addLink(patient, clinician, data);
        Assert.assertNotNull((Object)link);
        Assert.assertEquals((Object)"A Parasiticide Comparison Chart", (Object)link.getDescription());
        Assert.assertEquals((Object)"https://vtck.it/v3/d1", (Object)link.getUrl());
        Act act = link.getAct();
        Assert.assertNotNull((Object)act);
        Assert.assertFalse((boolean)act.isNew());
        IMObjectBean bean = this.getBean((IMObject)act);
        Assert.assertEquals((Object)link.getDescription(), (Object)bean.getString("description"));
        Assert.assertEquals((Object)link.getUrl(), (Object)bean.getString("url"));
        Assert.assertEquals((Object)patient, (Object)bean.getTarget("patient"));
        Assert.assertEquals((Object)clinician, (Object)bean.getTarget("clinician"));
        Act event = this.medicalRecordRules.getEvent(patient);
        Assert.assertNotNull((Object)event);
        Assert.assertEquals((Object)event, (Object)bean.getSource("event"));
    }

    @Test
    public void testGetMostRecentLinks() {
        Party patient = this.patientFactory.createPatient();
        User clinician = this.userFactory.createClinician();
        String data1 = "share_link=https://vtck.it/v3/A&document_type=handout&title=A";
        String data2 = "share_link=https://vtck.it/v3/B&document_type=handout&title=B";
        String data3 = "share_link=https://vtck.it/v3/C&document_type=handout&title=C";
        VetCheckLink link1 = this.rules.addLink(patient, clinician, data1);
        VetCheckLink link2 = this.rules.addLink(patient, clinician, data2);
        VetCheckLink link3 = this.rules.addLink(patient, clinician, data3);
        List links = this.rules.getMostRecentLinks(patient, 4);
        Assert.assertEquals((long)3L, (long)links.size());
        Assert.assertEquals((Object)link3.getAct(), links.get(0));
        Assert.assertEquals((Object)link2.getAct(), links.get(1));
        Assert.assertEquals((Object)link1.getAct(), links.get(2));
    }
}

