/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.problem;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.junit.Test;
import org.openvpms.archetype.rules.patient.PatientTestHelper;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.workspace.patient.history.AbstractPatientHistoryFlattener;
import org.openvpms.web.workspace.patient.history.AbstractPatientHistoryFlattenerTest;
import org.openvpms.web.workspace.patient.problem.ProblemHistoryFlattener;

public class ProblemHistoryFlattenerTestCase
extends AbstractPatientHistoryFlattenerTest {
    @Test
    public void testSingleProblem() {
        Party patient = TestHelper.createPatient();
        User clinician = TestHelper.createClinician();
        Act note1 = PatientTestHelper.createNote((Date)TestHelper.getDatetime((String)"2014-05-09 10:04:00"), (Party)patient, (User)clinician);
        Act note2 = PatientTestHelper.createNote((Date)TestHelper.getDatetime((String)"2014-05-09 10:10:00"), (Party)patient, (User)clinician);
        Act problem = PatientTestHelper.createProblem((Date)TestHelper.getDatetime((String)"2014-05-09 10:00:00"), (Party)patient, (User)clinician, (Act[])new Act[]{note1, note2});
        Act event = PatientTestHelper.createEvent((Date)TestHelper.getDatetime((String)"2014-05-09 09:00:00"), (Party)patient, (User)clinician, (Act[])new Act[]{problem, note1, note2});
        String[] archetypes = new String[]{"act.patientWeight", "act.patientClinicalNote", "act.patientClinicalAddendum"};
        ProblemHistoryFlattener flattener = new ProblemHistoryFlattener((ArchetypeService)this.getArchetypeService());
        List<Act> acts = Collections.singletonList(problem);
        this.check((AbstractPatientHistoryFlattener)flattener, acts, archetypes, true, true, problem, event, note1, note2);
        this.check((AbstractPatientHistoryFlattener)flattener, acts, archetypes, true, false, problem, event, note2, note1);
    }

    @Test
    public void testFlattener() {
        Party patient = TestHelper.createPatient();
        User clinician = TestHelper.createClinician();
        Act note1 = PatientTestHelper.createNote((Date)TestHelper.getDatetime((String)"2014-05-09 10:04:00"), (Party)patient, (User)clinician);
        Act note2 = PatientTestHelper.createNote((Date)TestHelper.getDatetime((String)"2014-05-09 10:10:00"), (Party)patient, (User)clinician);
        Act problem1 = PatientTestHelper.createProblem((Date)TestHelper.getDatetime((String)"2014-05-09 10:00:00"), (Party)patient, (User)clinician, (Act[])new Act[]{note1, note2});
        Act event1 = PatientTestHelper.createEvent((Date)TestHelper.getDatetime((String)"2014-05-09 09:00:00"), (Party)patient, (User)clinician, (Act[])new Act[]{problem1, note1, note2});
        Act problem2 = PatientTestHelper.createProblem((Date)TestHelper.getDatetime((String)"2019-07-04 12:00:00"), (Party)patient, (User)clinician, (Act[])new Act[0]);
        Act event2 = PatientTestHelper.createEvent((Date)TestHelper.getDatetime((String)"2019-07-04 11:00:00"), (Party)patient, (User)clinician, (Act[])new Act[]{problem2});
        String[] archetypes = new String[]{"act.patientWeight", "act.patientClinicalNote", "act.patientClinicalAddendum"};
        List<Act> ascending = Arrays.asList(problem1, problem2);
        ArrayList<Act> descending = new ArrayList<Act>(ascending);
        Collections.reverse(descending);
        ProblemHistoryFlattener flattener = new ProblemHistoryFlattener((ArchetypeService)this.getArchetypeService());
        this.check((AbstractPatientHistoryFlattener)flattener, ascending, archetypes, true, true, problem1, event1, note1, note2, problem2, event2);
        this.check((AbstractPatientHistoryFlattener)flattener, ascending, archetypes, true, false, problem1, event1, note2, note1, problem2, event2);
        this.check((AbstractPatientHistoryFlattener)flattener, descending, archetypes, false, true, problem2, event2, problem1, event1, note1, note2);
        this.check((AbstractPatientHistoryFlattener)flattener, descending, archetypes, false, false, problem2, event2, problem1, event1, note2, note1);
    }
}

