/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.insurance.claim;

import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.openvpms.archetype.rules.doc.TemplateHelper;
import org.openvpms.archetype.rules.finance.account.CustomerAccountArchetypes;
import org.openvpms.archetype.rules.finance.account.CustomerAccountQueryFactory;
import org.openvpms.archetype.rules.finance.account.CustomerAccountRules;
import org.openvpms.archetype.test.builder.customer.TestCustomerFactory;
import org.openvpms.archetype.test.builder.customer.account.TestCustomerAccountFactory;
import org.openvpms.archetype.test.builder.customer.account.TestInvoiceBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestInvoiceItemBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestPaymentBuilder;
import org.openvpms.archetype.test.builder.doc.TestDocumentFactory;
import org.openvpms.archetype.test.builder.doc.TestDocumentTemplateBuilder;
import org.openvpms.archetype.test.builder.insurance.TestClaimBuilder;
import org.openvpms.archetype.test.builder.insurance.TestInsuranceFactory;
import org.openvpms.archetype.test.builder.patient.TestPatientFactory;
import org.openvpms.archetype.test.builder.practice.TestLocationBuilder;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.archetype.test.builder.product.TestProductFactory;
import org.openvpms.archetype.test.builder.user.TestUserFactory;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.insurance.claim.Claim;
import org.openvpms.insurance.claim.GapClaim;
import org.openvpms.insurance.internal.InsuranceFactory;
import org.openvpms.insurance.internal.claim.GapClaimImpl;
import org.openvpms.insurance.service.InsuranceServices;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.edit.EditorTestHelper;
import org.openvpms.web.component.im.edit.act.ActEditDialog;
import org.openvpms.web.component.im.edit.payment.PaymentEditor;
import org.openvpms.web.component.im.edit.payment.PaymentItemEditor;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.QueryHelper;
import org.openvpms.web.component.print.PrintDialog;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.echo.dialog.ConfirmationDialog;
import org.openvpms.web.echo.dialog.ErrorDialog;
import org.openvpms.web.echo.dialog.PopupDialog;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.format.DateFormatter;
import org.openvpms.web.resource.i18n.format.NumberFormatter;
import org.openvpms.web.test.AbstractAppTest;
import org.openvpms.web.test.EchoTestHelper;
import org.openvpms.web.workspace.customer.credit.CreditActEditDialog;
import org.openvpms.web.workspace.patient.insurance.claim.BenefitDialog;
import org.openvpms.web.workspace.patient.insurance.claim.ClaimEditor;
import org.openvpms.web.workspace.patient.insurance.claim.ClaimSubmitter;
import org.openvpms.web.workspace.patient.insurance.claim.GapPaymentEditor;
import org.openvpms.web.workspace.patient.insurance.claim.GapPaymentPrompt;
import org.openvpms.web.workspace.patient.insurance.claim.TestClaimEditor;
import org.openvpms.web.workspace.patient.insurance.claim.TestGapInsuranceService;
import org.springframework.beans.factory.annotation.Autowired;

public class ClaimSubmitterTestCase
extends AbstractAppTest {
    private final List<String> errors = new ArrayList<String>();
    @Autowired
    private InsuranceFactory insuranceFactory;
    @Autowired
    private TestCustomerAccountFactory accountFactory;
    @Autowired
    private TestCustomerFactory customerFactory;
    @Autowired
    private TestDocumentFactory documentFactory;
    @Autowired
    private TestInsuranceFactory testInsuranceFactory;
    @Autowired
    private TestPatientFactory patientFactory;
    @Autowired
    private TestPracticeFactory practiceFactory;
    @Autowired
    private TestProductFactory productFactory;
    @Autowired
    private TestUserFactory userFactory;
    @Autowired
    private CustomerAccountRules rules;
    private Party customer;
    private Party patient;
    private User clinician;
    private Party location;
    private Act policyAct;
    private Party insurer;
    private TestGapInsuranceService insuranceService;
    private Party practice;
    private Entity till;

    @Before
    public void setUp() {
        this.practice = this.practiceFactory.getPractice();
        super.setUp();
        this.customer = this.customerFactory.createCustomer();
        this.patient = this.patientFactory.createPatient(this.customer);
        this.clinician = this.userFactory.createClinician();
        this.till = this.practiceFactory.createTill();
        this.location = (Party)this.practiceFactory.newLocation().tills(new Entity[]{this.till}).build();
        this.insurer = this.testInsuranceFactory.createInsurer();
        this.policyAct = this.testInsuranceFactory.createPolicy(this.customer, this.patient, this.insurer, "POL123456");
        this.insuranceService = new TestGapInsuranceService();
        this.initDocumentTemplate("act.customerAccountPayment", "Receipt");
        this.initDocumentTemplate("act.customerAccountRefund", "Refund");
        this.initDocumentTemplate("INSURANCE_CLAIM_MEDICAL_RECORDS", "Insurance Claim Medical Records");
        this.initDocumentTemplate("INSURANCE_CLAIM_INVOICE", "Insurance Claim Invoice");
        this.initErrorHandler(this.errors);
    }

    @Test
    public void testDuplicate() {
        FinancialAct invoiceItem1 = this.createInvoiceItem();
        FinancialAct invoiceItem2 = this.createInvoiceItem();
        FinancialAct invoice = this.createInvoice("POSTED", invoiceItem1, invoiceItem2);
        this.createPayment(invoice.getTotal());
        FinancialAct claim1 = (FinancialAct)this.newClaim(this.policyAct, Claim.Status.PENDING, false).item().diagnosis("VENOM_328").invoiceItems(new FinancialAct[]{invoiceItem1}).add().build();
        FinancialAct claim2 = (FinancialAct)this.newClaim(this.policyAct, Claim.Status.PENDING, false).item().diagnosis("VENOM_328").invoiceItems(new FinancialAct[]{invoiceItem1}).add().build();
        LocalContext context = new LocalContext();
        context.setPractice(this.practice);
        context.setLocation(this.location);
        context.setUser(this.clinician);
        context.setCustomer(this.customer);
        DefaultLayoutContext layoutContext = new DefaultLayoutContext((Context)context, new HelpContext("foo", null));
        TestClaimEditor editor = new TestClaimEditor(claim1, (LayoutContext)layoutContext);
        editor.getComponent();
        this.checkDuplicate(editor, (Act)claim2, false);
        claim2.setStatus(Claim.Status.POSTED.toString());
        this.save((IMObject)claim2);
        this.checkDuplicate(editor, (Act)claim2, false);
        claim2.setStatus(Claim.Status.ACCEPTED.toString());
        this.save((IMObject)claim2);
        this.checkDuplicate(editor, (Act)claim2, false);
        claim2.setStatus(Claim.Status.SETTLED.toString());
        this.save((IMObject)claim2);
        this.checkDuplicate(editor, (Act)claim2, false);
        claim2.setStatus(Claim.Status.DECLINED.toString());
        this.save((IMObject)claim2);
        this.checkDuplicate(editor, (Act)claim2, false);
        claim2.setStatus(Claim.Status.CANCELLED.toString());
        this.save((IMObject)claim2);
        this.checkDuplicate(editor, (Act)claim2, true);
    }

    @Test
    public void testDuplicateAct() {
        FinancialAct invoiceItem1 = this.createInvoiceItem();
        FinancialAct invoiceItem2 = this.createInvoiceItem();
        this.createInvoice("POSTED", invoiceItem1, invoiceItem2);
        FinancialAct claim1 = this.createClaim(this.policyAct, Claim.Status.POSTED, false, invoiceItem1);
        FinancialAct claim2 = this.createClaim(this.policyAct, Claim.Status.PENDING, false, invoiceItem1);
        this.checkDuplicate((Act)claim1, (Act)claim2, false);
        claim2.setStatus(Claim.Status.POSTED.toString());
        this.save((IMObject)claim2);
        this.checkDuplicate((Act)claim1, (Act)claim2, false);
        claim2.setStatus(Claim.Status.ACCEPTED.toString());
        this.save((IMObject)claim2);
        this.checkDuplicate((Act)claim1, (Act)claim2, false);
        claim2.setStatus(Claim.Status.SETTLED.toString());
        this.save((IMObject)claim2);
        this.checkDuplicate((Act)claim1, (Act)claim2, false);
        claim2.setStatus(Claim.Status.DECLINED.toString());
        this.save((IMObject)claim2);
        this.checkDuplicate((Act)claim1, (Act)claim2, false);
        claim2.setStatus(Claim.Status.CANCELLED.toString());
        this.save((IMObject)claim2);
        this.checkDuplicate((Act)claim1, (Act)claim2, true);
    }

    @Test
    public void testPayGapClaim() {
        this.checkPayGapClaim(true);
    }

    @Test
    public void testPayGapClaimNoPreConfiguredTill() {
        this.checkPayGapClaim(false);
    }

    @Test
    public void testPayFullGapClaim() {
        this.checkEquals(BigDecimal.ZERO, this.rules.getBalance(this.customer));
        Context context = this.createContext(this.till);
        FinancialAct invoiceItem1 = this.createInvoiceItem();
        FinancialAct invoiceItem2 = this.createInvoiceItem();
        this.createInvoice("POSTED", invoiceItem1, invoiceItem2);
        FinancialAct claim = this.createClaim(this.policyAct, Claim.Status.POSTED, true, invoiceItem1);
        ClaimSubmitter submitter = this.createSubmitter(context);
        submitter.submit((Act)claim, Assert::assertNull);
        ConfirmationDialog confirm = (ConfirmationDialog)this.findComponent(ConfirmationDialog.class);
        Assert.assertEquals((Object)"Submit Claim", (Object)confirm.getTitle());
        String message = "This claim will be submitted to " + this.insurer.getName() + " using Test Service.\n\nSubmit claim?";
        Assert.assertEquals((Object)message, (Object)confirm.getMessage());
        EchoTestHelper.fireDialogButton((PopupDialog)confirm, (String)"yes");
        BenefitDialog benefit = (BenefitDialog)this.findComponent(BenefitDialog.class);
        Assert.assertEquals((Object)"Waiting for Claim Benefit", (Object)benefit.getTitle());
        Assert.assertEquals((Object)("The claim has been submitted to " + this.insurer.getName() + ".\n\nPlease wait for them to determine the benefit amount."), (Object)benefit.getMessage());
        EchoTestHelper.fireDialogButton((PopupDialog)benefit, (String)"button.payfullclaim");
        GapPaymentPrompt prompt = (GapPaymentPrompt)this.findComponent(GapPaymentPrompt.class);
        Assert.assertEquals((Object)"Pay Claim", (Object)prompt.getTitle());
        prompt.setPayFull(true);
        EchoTestHelper.fireDialogButton((PopupDialog)prompt, (String)"ok");
        CreditActEditDialog payment = this.pay(claim.getTotal());
        EditorTestHelper.assertValid((Modifiable)payment.getEditor());
        EchoTestHelper.fireDialogButton((PopupDialog)payment, (String)"ok");
        Assert.assertEquals((Object)claim.getTotal(), (Object)this.getBean((IMObject)claim).getBigDecimal("paid"));
        Assert.assertEquals((Object)GapClaim.GapStatus.PAID.toString(), (Object)claim.getStatus2());
        this.checkPrintDialog("Print Receipt?");
        ArchetypeQuery query = CustomerAccountQueryFactory.createQuery((Party)this.customer, (List)CustomerAccountArchetypes.ACCOUNT_ACTS);
        List objects = QueryHelper.query((ArchetypeQuery)query, (IArchetypeService)this.getArchetypeService());
        Assert.assertEquals((long)2L, (long)objects.size());
        this.checkAccount("act.customerAccountChargesInvoice", BigDecimal.valueOf(18L), objects);
        this.checkAccount("act.customerAccountPayment", BigDecimal.valueOf(9L), objects);
        claim = (FinancialAct)this.get((IMObject)claim);
        Assert.assertEquals((Object)GapClaim.GapStatus.NOTIFIED.toString(), (Object)claim.getStatus2());
        Assert.assertEquals((long)1L, (long)this.insuranceService.getPaymentNotified());
        this.checkEquals(BigDecimal.valueOf(9L), this.rules.getBalance(this.customer));
    }

    @Test
    public void testUpdateBenefitWhenPayingFullGapClaim() {
        Context context = this.createContext(this.till);
        FinancialAct invoiceItem1 = this.createInvoiceItem();
        FinancialAct invoiceItem2 = this.createInvoiceItem();
        this.createInvoice("POSTED", invoiceItem1, invoiceItem2);
        FinancialAct claim = this.createClaim(this.policyAct, Claim.Status.POSTED, true, invoiceItem1);
        ClaimSubmitter submitter = this.createSubmitter(context);
        submitter.submit((Act)claim, Assert::assertNull);
        ConfirmationDialog confirm = (ConfirmationDialog)this.findComponent(ConfirmationDialog.class);
        Assert.assertEquals((Object)"Submit Claim", (Object)confirm.getTitle());
        String message = "This claim will be submitted to " + this.insurer.getName() + " using Test Service.\n\nSubmit claim?";
        Assert.assertEquals((Object)message, (Object)confirm.getMessage());
        EchoTestHelper.fireDialogButton((PopupDialog)confirm, (String)"yes");
        BenefitDialog benefit = (BenefitDialog)this.findComponent(BenefitDialog.class);
        Assert.assertEquals((Object)"Waiting for Claim Benefit", (Object)benefit.getTitle());
        Assert.assertEquals((Object)("The claim has been submitted to " + this.insurer.getName() + ".\n\nPlease wait for them to determine the benefit amount."), (Object)benefit.getMessage());
        EchoTestHelper.fireDialogButton((PopupDialog)benefit, (String)"button.payfullclaim");
        GapPaymentPrompt prompt = (GapPaymentPrompt)this.findComponent(GapPaymentPrompt.class);
        Assert.assertEquals((Object)"Pay Claim", (Object)prompt.getTitle());
        prompt.setPayFull(true);
        EchoTestHelper.fireDialogButton((PopupDialog)prompt, (String)"ok");
        claim = (FinancialAct)this.get((IMObject)claim);
        claim.setStatus(Claim.Status.ACCEPTED.toString());
        claim.setStatus2(GapClaim.GapStatus.RECEIVED.toString());
        this.save((IMObject)claim);
        CreditActEditDialog payment1 = this.pay(claim.getTotal());
        EditorTestHelper.assertValid((Modifiable)payment1.getEditor());
        EchoTestHelper.fireDialogButton((PopupDialog)payment1, (String)"ok");
        ErrorDialog error = (ErrorDialog)this.findComponent(ErrorDialog.class);
        Assert.assertNotNull((Object)error);
        Assert.assertEquals((Object)"The Insurance Claim could not be saved. It may have been changed by another user.\n\nRetry?", (Object)error.getMessage());
        EchoTestHelper.fireDialogButton((PopupDialog)error, (String)"yes");
        claim = (FinancialAct)this.get((IMObject)claim);
        Assert.assertEquals((Object)claim.getTotal(), (Object)this.getBean((IMObject)claim).getBigDecimal("paid"));
        Assert.assertEquals((Object)GapClaim.GapStatus.PAID.toString(), (Object)claim.getStatus2());
        this.checkPrintDialog("Print Receipt?");
        ArchetypeQuery query = CustomerAccountQueryFactory.createQuery((Party)this.customer, (List)CustomerAccountArchetypes.ACCOUNT_ACTS);
        List objects = QueryHelper.query((ArchetypeQuery)query, (IArchetypeService)this.getArchetypeService());
        Assert.assertEquals((long)2L, (long)objects.size());
        this.checkAccount("act.customerAccountChargesInvoice", BigDecimal.valueOf(18L), objects);
        this.checkAccount("act.customerAccountPayment", BigDecimal.valueOf(9L), objects);
        claim = (FinancialAct)this.get((IMObject)claim);
        Assert.assertEquals((Object)GapClaim.GapStatus.NOTIFIED.toString(), (Object)claim.getStatus2());
        Assert.assertEquals((long)1L, (long)this.insuranceService.getPaymentNotified());
    }

    @Test
    public void testPayGapClaimForPartPaidInvoice() {
        Entity gapTill = this.createTill(true);
        Context context = this.createContext(this.till);
        FinancialAct invoiceItem1 = this.createInvoiceItem();
        FinancialAct invoiceItem2 = this.createInvoiceItem();
        this.createInvoice("POSTED", invoiceItem1, invoiceItem2);
        BigDecimal prepaymentAmount = BigDecimal.valueOf(3L);
        this.createPayment(prepaymentAmount);
        FinancialAct claim = this.createClaim(this.policyAct, Claim.Status.POSTED, true, invoiceItem1);
        BigDecimal benefitAmount = BigDecimal.valueOf(5L);
        BigDecimal gapAmount = BigDecimal.valueOf(4L);
        BigDecimal remainingGap = gapAmount.subtract(prepaymentAmount);
        this.submitAndSelectPayGapClaim(claim, benefitAmount, prepaymentAmount, remainingGap, BigDecimal.ZERO, context);
        CreditActEditDialog paymentDialog = (CreditActEditDialog)this.findComponent(CreditActEditDialog.class);
        Assert.assertEquals((Object)"New Payment", (Object)paymentDialog.getTitle());
        GapPaymentEditor paymentEditor = (GapPaymentEditor)paymentDialog.getEditor();
        this.checkEquals(remainingGap, paymentEditor.getExpectedAmount());
        PaymentItemEditor paymentItemEditor = paymentEditor.getUnsavedItem();
        paymentItemEditor.setAmount(remainingGap);
        Assert.assertEquals((Object)paymentEditor.getGapPaymentTill(), (Object)gapTill);
        EditorTestHelper.assertValid((Modifiable)paymentEditor);
        EchoTestHelper.fireDialogButton((PopupDialog)paymentDialog, (String)"ok");
        claim = (FinancialAct)this.get((IMObject)claim);
        this.checkEquals(gapAmount, this.getBean((IMObject)claim).getBigDecimal("paid"));
        Assert.assertEquals((Object)GapClaim.GapStatus.PAID.toString(), (Object)claim.getStatus2());
        this.checkPrintDialog("Print Receipt?");
        ArchetypeQuery query = CustomerAccountQueryFactory.createQuery((Party)this.customer, (List)CustomerAccountArchetypes.ACCOUNT_ACTS);
        List objects = QueryHelper.query((ArchetypeQuery)query, (IArchetypeService)this.getArchetypeService());
        Assert.assertEquals((long)4L, (long)objects.size());
        this.checkAccount("act.customerAccountChargesInvoice", BigDecimal.valueOf(18L), objects);
        this.checkAccount("act.customerAccountPayment", prepaymentAmount, objects);
        FinancialAct gapPayment = this.checkAccount("act.customerAccountPayment", remainingGap, objects);
        FinancialAct benefitPayment = this.checkAccount("act.customerAccountPayment", benefitAmount, objects);
        this.checkPaymentTill(gapPayment, this.till);
        this.checkPaymentTill(benefitPayment, gapTill);
        claim = (FinancialAct)this.get((IMObject)claim);
        Assert.assertEquals((Object)GapClaim.GapStatus.NOTIFIED.toString(), (Object)claim.getStatus2());
        Assert.assertEquals((long)1L, (long)this.insuranceService.getPaymentNotified());
    }

    @Test
    public void testRefundToMakeGapClaim() {
        this.checkRefundToPayGapClaim(true);
    }

    @Test
    public void testRefundToMakeGapClaimNoPreConfiguredTill() {
        this.checkRefundToPayGapClaim(false);
    }

    @Test
    public void testTwoClaimsForDifferentPatientOnSameInvoice() {
        this.checkEquals(BigDecimal.ZERO, this.rules.getBalance(this.customer));
        Entity gapTill = this.createTill(true);
        Context context = this.createContext(this.till);
        FinancialAct invoiceItem1 = this.createInvoiceItem(this.patient);
        Party patient2 = this.patientFactory.createPatient(this.customer);
        Act policyAct2 = this.testInsuranceFactory.createPolicy(this.customer, patient2, this.insurer, "POL2222");
        FinancialAct invoiceItem2 = this.createInvoiceItem(patient2);
        this.createInvoice("POSTED", invoiceItem1, invoiceItem2);
        FinancialAct claim1 = this.createClaim(this.policyAct, Claim.Status.POSTED, true, invoiceItem1);
        FinancialAct claim2 = this.createClaim(policyAct2, Claim.Status.POSTED, true, invoiceItem2);
        BigDecimal invoiceAmount = BigDecimal.valueOf(18L);
        BigDecimal benefitAmount = BigDecimal.valueOf(5L);
        BigDecimal gapAmount = BigDecimal.valueOf(4L);
        this.submitAndSelectPayGapClaim(claim1, benefitAmount, BigDecimal.ZERO, gapAmount, BigDecimal.ZERO, context);
        this.makeGapPayment(claim1, gapAmount, gapAmount, gapTill, 1);
        Assert.assertEquals((long)1L, (long)this.insuranceService.getPaymentNotified());
        List<IMObject> acts1 = this.getAccountActs(3);
        FinancialAct invoice = this.checkAccount("act.customerAccountChargesInvoice", invoiceAmount, acts1);
        FinancialAct gapPayment1 = this.checkAccount("act.customerAccountPayment", gapAmount, acts1);
        FinancialAct benefitPayment1 = this.checkAccount("act.customerAccountPayment", benefitAmount, acts1);
        this.checkPaymentTill(gapPayment1, this.till);
        this.checkPaymentTill(benefitPayment1, gapTill);
        this.checkEquals(BigDecimal.valueOf(9L), invoice.getAllocatedAmount());
        this.checkEquals(gapAmount, gapPayment1.getAllocatedAmount());
        this.checkEquals(benefitAmount, benefitPayment1.getAllocatedAmount());
        this.checkEquals(BigDecimal.valueOf(9L), this.rules.getBalance(this.customer));
        this.submitAndSelectPayGapClaim(claim2, benefitAmount, BigDecimal.ZERO, gapAmount, BigDecimal.ZERO, context);
        this.makeGapPayment(claim2, gapAmount, gapAmount, gapTill, 2);
        List<IMObject> acts2 = this.getAccountActs(5);
        acts2.remove(invoice);
        acts2.remove(gapPayment1);
        acts2.remove(benefitPayment1);
        Assert.assertEquals((long)2L, (long)acts2.size());
        this.checkAccount("act.customerAccountPayment", gapAmount, acts2);
        this.checkAccount("act.customerAccountPayment", benefitAmount, acts2);
        this.checkEquals(BigDecimal.ZERO, this.rules.getBalance(this.customer));
    }

    @Test
    public void testTwoClaimsForDifferentPatientOnSameInvoiceWithPrepaymentLessThanGap() {
        this.checkEquals(BigDecimal.ZERO, this.rules.getBalance(this.customer));
        Entity gapTill = this.createTill(true);
        BigDecimal depositAmount = BigDecimal.valueOf(3L);
        this.createPayment(depositAmount);
        Context context = this.createContext(this.till);
        FinancialAct invoiceItem1 = this.createInvoiceItem(this.patient);
        Party patient2 = this.patientFactory.createPatient(this.customer);
        Act policyAct2 = this.testInsuranceFactory.createPolicy(this.customer, patient2, this.insurer, "POL2222");
        FinancialAct invoiceItem2 = this.createInvoiceItem(patient2);
        this.createInvoice("POSTED", invoiceItem1, invoiceItem2);
        FinancialAct claim1 = this.createClaim(this.policyAct, Claim.Status.POSTED, true, invoiceItem1);
        FinancialAct claim2 = this.createClaim(policyAct2, Claim.Status.POSTED, true, invoiceItem2);
        BigDecimal invoiceAmount = BigDecimal.valueOf(18L);
        BigDecimal benefitAmount = BigDecimal.valueOf(5L);
        BigDecimal gapAmount = BigDecimal.valueOf(4L);
        this.submitAndSelectPayGapClaim(claim1, benefitAmount, depositAmount, BigDecimal.ONE, BigDecimal.ZERO, context);
        this.makeGapPayment(claim1, gapAmount.subtract(depositAmount), gapAmount, gapTill, 1);
        List<IMObject> objects = this.getAccountActs(4);
        this.checkAccount("act.customerAccountPayment", depositAmount, objects);
        FinancialAct deposit = this.checkAccount("act.customerAccountPayment", depositAmount, objects);
        FinancialAct invoice = this.checkAccount("act.customerAccountChargesInvoice", invoiceAmount, objects);
        FinancialAct gapPayment1 = this.checkAccount("act.customerAccountPayment", gapAmount.subtract(depositAmount), objects);
        FinancialAct benefitPayment1 = this.checkAccount("act.customerAccountPayment", benefitAmount, objects);
        this.checkPaymentTill(gapPayment1, this.till);
        this.checkPaymentTill(benefitPayment1, gapTill);
        this.checkEquals(BigDecimal.valueOf(9L), invoice.getAllocatedAmount());
        this.checkEquals(gapAmount.subtract(depositAmount), gapPayment1.getAllocatedAmount());
        this.checkEquals(benefitAmount, benefitPayment1.getAllocatedAmount());
        this.checkEquals(BigDecimal.valueOf(9L), this.rules.getBalance(this.customer));
        this.submitAndSelectPayGapClaim(claim2, benefitAmount, BigDecimal.ZERO, gapAmount, BigDecimal.ZERO, context);
        this.makeGapPayment(claim2, gapAmount, gapAmount, gapTill, 2);
        List<IMObject> acts2 = this.getAccountActs(6);
        acts2.remove(deposit);
        acts2.remove(invoice);
        acts2.remove(gapPayment1);
        acts2.remove(benefitPayment1);
        Assert.assertEquals((long)2L, (long)acts2.size());
        this.checkAccount("act.customerAccountPayment", gapAmount, acts2);
        this.checkAccount("act.customerAccountPayment", benefitAmount, acts2);
        this.checkEquals(BigDecimal.ZERO, this.rules.getBalance(this.customer));
    }

    @Test
    public void testTwoClaimsForDifferentPatientOnSameInvoiceWithPrepaymentEqualsToGap() {
        this.checkEquals(BigDecimal.ZERO, this.rules.getBalance(this.customer));
        Entity gapTill = this.createTill(true);
        BigDecimal depositAmount = BigDecimal.valueOf(4L);
        FinancialAct deposit = this.createPayment(depositAmount);
        Context context = this.createContext(this.till);
        FinancialAct invoiceItem1 = this.createInvoiceItem(this.patient);
        Party patient2 = this.patientFactory.createPatient(this.customer);
        Act policyAct2 = this.testInsuranceFactory.createPolicy(this.customer, patient2, this.insurer, "POL2222");
        FinancialAct invoiceItem2 = this.createInvoiceItem(patient2);
        this.createInvoice("POSTED", invoiceItem1, invoiceItem2);
        FinancialAct claim1 = this.createClaim(this.policyAct, Claim.Status.POSTED, true, invoiceItem1);
        FinancialAct claim2 = this.createClaim(policyAct2, Claim.Status.POSTED, true, invoiceItem2);
        BigDecimal invoiceAmount = BigDecimal.valueOf(18L);
        BigDecimal benefitAmount = BigDecimal.valueOf(5L);
        BigDecimal gapAmount = BigDecimal.valueOf(4L);
        this.submitAndSelectPayGapClaim(claim1, benefitAmount, depositAmount, BigDecimal.ZERO, BigDecimal.ZERO, context);
        claim1 = (FinancialAct)this.get((IMObject)claim1);
        this.checkEquals(gapAmount, this.getBean((IMObject)claim1).getBigDecimal("paid"));
        Assert.assertEquals((Object)GapClaim.GapStatus.NOTIFIED.toString(), (Object)claim1.getStatus2());
        Assert.assertEquals((long)1L, (long)this.insuranceService.getPaymentNotified());
        List<IMObject> objects = this.getAccountActs(3);
        Assert.assertTrue((boolean)objects.contains(deposit));
        FinancialAct invoice = this.checkAccount("act.customerAccountChargesInvoice", invoiceAmount, objects);
        FinancialAct benefitPayment1 = this.checkAccount("act.customerAccountPayment", benefitAmount, objects);
        this.checkPaymentTill(benefitPayment1, gapTill);
        this.checkEquals(BigDecimal.valueOf(9L), invoice.getAllocatedAmount());
        this.checkEquals(benefitAmount, benefitPayment1.getAllocatedAmount());
        this.checkEquals(BigDecimal.valueOf(9L), this.rules.getBalance(this.customer));
        this.submitAndSelectPayGapClaim(claim2, benefitAmount, BigDecimal.ZERO, gapAmount, BigDecimal.ZERO, context);
        this.makeGapPayment(claim2, depositAmount, depositAmount, gapTill, 2);
        List<IMObject> acts2 = this.getAccountActs(5);
        acts2.remove(deposit);
        acts2.remove(invoice);
        acts2.remove(benefitPayment1);
        Assert.assertEquals((long)2L, (long)acts2.size());
        this.checkAccount("act.customerAccountPayment", gapAmount, acts2);
        this.checkAccount("act.customerAccountPayment", benefitAmount, acts2);
        this.checkEquals(BigDecimal.ZERO, this.rules.getBalance(this.customer));
    }

    @Test
    public void testTwoClaimsForDifferentPatientOnSameInvoiceWithPrepaymentGreaterThanGap() {
        this.checkEquals(BigDecimal.ZERO, this.rules.getBalance(this.customer));
        Entity gapTill = this.createTill(true);
        BigDecimal depositAmount = BigDecimal.valueOf(7L);
        FinancialAct deposit = this.createPayment(depositAmount);
        Context context = this.createContext(this.till);
        FinancialAct invoiceItem1 = this.createInvoiceItem(this.patient);
        Party patient2 = this.patientFactory.createPatient(this.customer);
        Act policyAct2 = this.testInsuranceFactory.createPolicy(this.customer, patient2, this.insurer, "POL2222");
        FinancialAct invoiceItem2 = this.createInvoiceItem(patient2);
        this.createInvoice("POSTED", invoiceItem1, invoiceItem2);
        FinancialAct claim1 = this.createClaim(this.policyAct, Claim.Status.POSTED, true, invoiceItem1);
        FinancialAct claim2 = this.createClaim(policyAct2, Claim.Status.POSTED, true, invoiceItem2);
        BigDecimal invoiceAmount = BigDecimal.valueOf(18L);
        BigDecimal benefitAmount = BigDecimal.valueOf(5L);
        BigDecimal gapAmount = BigDecimal.valueOf(4L);
        BigDecimal refundAmount = depositAmount.subtract(gapAmount);
        this.submitAndSelectPayGapClaim(claim1, benefitAmount, depositAmount, BigDecimal.valueOf(2L), refundAmount, context);
        this.makeGapRefund(claim1, refundAmount, gapAmount, gapTill, 1);
        List<IMObject> objects = this.getAccountActs(4);
        Assert.assertTrue((boolean)objects.contains(deposit));
        FinancialAct invoice = this.checkAccount("act.customerAccountChargesInvoice", invoiceAmount, objects);
        FinancialAct refund = this.checkAccount("act.customerAccountRefund", refundAmount, objects);
        FinancialAct benefitPayment1 = this.checkAccount("act.customerAccountPayment", benefitAmount, objects);
        this.checkPaymentTill(benefitPayment1, gapTill);
        this.checkEquals(BigDecimal.valueOf(12L), invoice.getAllocatedAmount());
        this.checkEquals(benefitAmount, benefitPayment1.getAllocatedAmount());
        this.checkEquals(BigDecimal.valueOf(9L), this.rules.getBalance(this.customer));
        this.submitAndSelectPayGapClaim(claim2, benefitAmount, refundAmount, gapAmount.subtract(refundAmount), BigDecimal.ZERO, context);
        this.makeGapPayment(claim2, gapAmount.subtract(refundAmount), gapAmount, gapTill, 2);
        List<IMObject> acts2 = this.getAccountActs(6);
        acts2.remove(deposit);
        acts2.remove(invoice);
        acts2.remove(refund);
        acts2.remove(benefitPayment1);
        Assert.assertEquals((long)2L, (long)acts2.size());
        this.checkAccount("act.customerAccountPayment", gapAmount.subtract(refundAmount), acts2);
        this.checkAccount("act.customerAccountPayment", benefitAmount, acts2);
        this.checkEquals(refundAmount, this.rules.getBalance(this.customer));
    }

    @Test
    public void testSubmitGapPaymentWithDifferentContextCustomer() {
        this.checkEquals(BigDecimal.ZERO, this.rules.getBalance(this.customer));
        Entity gapTill = this.createTill(true);
        FinancialAct invoiceItem1 = this.createInvoiceItem();
        FinancialAct invoiceItem2 = this.createInvoiceItem();
        this.createInvoice("POSTED", invoiceItem1, invoiceItem2);
        FinancialAct claim = this.createClaim(this.policyAct, Claim.Status.POSTED, true, invoiceItem1, invoiceItem2);
        Context context = this.createContext(this.till);
        context.setCustomer(this.customerFactory.createCustomer());
        ClaimSubmitter submitter = this.createSubmitter(context);
        submitter.submit((Act)claim, Assert::assertNull);
        ConfirmationDialog confirm = (ConfirmationDialog)this.findComponent(ConfirmationDialog.class);
        Assert.assertEquals((Object)"Submit Claim", (Object)confirm.getTitle());
        String message = "This claim will be submitted to " + this.insurer.getName() + " using Test Service.\n\nSubmit claim?";
        Assert.assertEquals((Object)message, (Object)confirm.getMessage());
        EchoTestHelper.fireDialogButton((PopupDialog)confirm, (String)"yes");
        BenefitDialog benefit = (BenefitDialog)this.findComponent(BenefitDialog.class);
        Assert.assertEquals((Object)"Waiting for Claim Benefit", (Object)benefit.getTitle());
        Assert.assertEquals((Object)("The claim has been submitted to " + this.insurer.getName() + ".\n\nPlease wait for them to determine the benefit amount."), (Object)benefit.getMessage());
        BigDecimal invoiceAmount = BigDecimal.valueOf(18L);
        BigDecimal benefitAmount = BigDecimal.valueOf(10L);
        BigDecimal gapAmount = BigDecimal.valueOf(8L);
        benefit.getClaim().setBenefit(benefitAmount, "Approved");
        benefit.refresh();
        GapPaymentPrompt prompt = (GapPaymentPrompt)this.findComponent(GapPaymentPrompt.class);
        Assert.assertEquals((Object)"Pay Claim", (Object)prompt.getTitle());
        prompt.setPayGap(true);
        EchoTestHelper.fireDialogButton((PopupDialog)prompt, (String)"ok");
        CreditActEditDialog payment = (CreditActEditDialog)this.findComponent(CreditActEditDialog.class);
        Assert.assertEquals((Object)"New Payment", (Object)payment.getTitle());
        GapPaymentEditor paymentEditor = (GapPaymentEditor)payment.getEditor();
        Assert.assertEquals((Object)this.customer, (Object)paymentEditor.getCustomer());
        PaymentItemEditor paymentItemEditor = paymentEditor.getUnsavedItem();
        paymentItemEditor.setAmount(gapAmount);
        Assert.assertEquals((Object)paymentEditor.getGapPaymentTill(), (Object)gapTill);
        EditorTestHelper.assertValid((Modifiable)paymentEditor);
        EchoTestHelper.fireDialogButton((PopupDialog)payment, (String)"ok");
        claim = (FinancialAct)this.get((IMObject)claim);
        this.checkEquals(gapAmount, this.getBean((IMObject)claim).getBigDecimal("paid"));
        Assert.assertEquals((Object)GapClaim.GapStatus.PAID.toString(), (Object)claim.getStatus2());
        this.checkPrintDialog("Print Receipt?");
        List<IMObject> objects = this.getAccountActs(3);
        FinancialAct invoice = this.checkAccount("act.customerAccountChargesInvoice", invoiceAmount, objects);
        FinancialAct gapPayment = this.checkAccount("act.customerAccountPayment", gapAmount, objects);
        FinancialAct benefitPayment = this.checkAccount("act.customerAccountPayment", benefitAmount, objects);
        this.checkPaymentTill(gapPayment, this.till);
        this.checkPaymentTill(benefitPayment, gapTill);
        this.checkEquals(invoiceAmount, invoice.getAllocatedAmount());
        this.checkEquals(gapAmount, gapPayment.getAllocatedAmount());
        this.checkEquals(benefitAmount, benefitPayment.getAllocatedAmount());
        claim = (FinancialAct)this.get((IMObject)claim);
        Assert.assertEquals((Object)GapClaim.GapStatus.NOTIFIED.toString(), (Object)claim.getStatus2());
        Assert.assertEquals((long)1L, (long)this.insuranceService.getPaymentNotified());
        this.checkEquals(BigDecimal.ZERO, this.rules.getBalance(this.customer));
    }

    @Test
    public void testPreSettledGapClaim() {
        Entity gapTill = this.createTill(true);
        Context context = this.createContext(this.till);
        FinancialAct invoiceItem1 = this.createInvoiceItem();
        FinancialAct invoiceItem2 = this.createInvoiceItem();
        BigDecimal invoiceAmount = this.createInvoice("POSTED", invoiceItem1, invoiceItem2).getTotal();
        FinancialAct claimAct = this.createClaim(this.policyAct, Claim.Status.POSTED, true, invoiceItem1, invoiceItem2);
        BigDecimal benefitAmount = BigDecimal.valueOf(10L);
        BigDecimal gapAmount = BigDecimal.valueOf(8L);
        GapClaim claim = (GapClaim)this.insuranceFactory.createClaim((Act)claimAct);
        claim.setBenefit(benefitAmount, "Approved");
        this.checkEquals(gapAmount, claim.getGapAmount());
        BigDecimal vetBenefit = claim.getTotal().subtract(BigDecimal.ONE);
        claim.state().vetBenefitAmount(vetBenefit).deposit("1", "actIdentity.insuranceDepositTest", OffsetDateTime.now(), vetBenefit).status(Claim.Status.PRE_SETTLED).update();
        ClaimSubmitter submitter = this.createSubmitter(context);
        submitter.pay((Act)claimAct, Assert::assertNull);
        GapPaymentPrompt prompt = (GapPaymentPrompt)this.findComponent(GapPaymentPrompt.class);
        Assert.assertEquals((Object)"Pay Claim", (Object)prompt.getTitle());
        Assert.assertEquals((Object)"The insurer has pre-settled this claim. The customer must pay the gap.", (Object)prompt.getPrompt());
        EchoTestHelper.fireDialogButton((PopupDialog)prompt, (String)"ok");
        CreditActEditDialog payment = (CreditActEditDialog)this.findComponent(CreditActEditDialog.class);
        Assert.assertEquals((Object)"New Payment", (Object)payment.getTitle());
        GapPaymentEditor paymentEditor = (GapPaymentEditor)payment.getEditor();
        Assert.assertEquals((Object)this.customer, (Object)paymentEditor.getCustomer());
        PaymentItemEditor paymentItemEditor = paymentEditor.getUnsavedItem();
        paymentItemEditor.setAmount(gapAmount);
        Assert.assertEquals((Object)paymentEditor.getGapPaymentTill(), (Object)gapTill);
        EditorTestHelper.assertValid((Modifiable)paymentEditor);
        EchoTestHelper.fireDialogButton((PopupDialog)payment, (String)"ok");
        claimAct = (FinancialAct)this.get((IMObject)claimAct);
        this.checkEquals(gapAmount, this.getBean((IMObject)claimAct).getBigDecimal("paid"));
        Assert.assertEquals((Object)GapClaim.GapStatus.PAID.toString(), (Object)claimAct.getStatus2());
        this.checkPrintDialog("Print Receipt?");
        List<IMObject> objects = this.getAccountActs(3);
        FinancialAct invoice = this.checkAccount("act.customerAccountChargesInvoice", invoiceAmount, objects);
        FinancialAct gapPayment = this.checkAccount("act.customerAccountPayment", gapAmount, objects);
        FinancialAct benefitPayment = this.checkAccount("act.customerAccountPayment", benefitAmount, objects);
        this.checkPaymentTill(gapPayment, this.till);
        this.checkPaymentTill(benefitPayment, gapTill);
        this.checkEquals(invoiceAmount, invoice.getAllocatedAmount());
        this.checkEquals(gapAmount, gapPayment.getAllocatedAmount());
        this.checkEquals(benefitAmount, benefitPayment.getAllocatedAmount());
        claimAct = (FinancialAct)this.get((IMObject)claimAct);
        Assert.assertEquals((Object)Claim.Status.SETTLED.toString(), (Object)claimAct.getStatus());
        Assert.assertEquals((Object)GapClaim.GapStatus.NOTIFIED.toString(), (Object)claimAct.getStatus2());
        Assert.assertEquals((long)1L, (long)this.insuranceService.getPaymentNotified());
        this.checkEquals(BigDecimal.ZERO, this.rules.getBalance(this.customer));
    }

    @Test
    public void testPreSettledAfterPayLessThanGap() {
        Entity gapTill = this.createTill(true);
        Context context = this.createContext(this.till);
        FinancialAct invoiceItem1 = this.createInvoiceItem();
        FinancialAct invoiceItem2 = this.createInvoiceItem();
        BigDecimal invoiceAmount = this.createInvoice("POSTED", invoiceItem1, invoiceItem2).getTotal();
        BigDecimal prepaymentAmount = BigDecimal.valueOf(5L);
        this.createPayment(prepaymentAmount);
        FinancialAct claimAct = this.createClaim(this.policyAct, Claim.Status.POSTED, true, invoiceItem1, invoiceItem2);
        BigDecimal benefitAmount = BigDecimal.valueOf(10L);
        BigDecimal gapAmount = BigDecimal.valueOf(8L);
        BigDecimal remainingGap = gapAmount.subtract(prepaymentAmount);
        GapClaim claim = (GapClaim)this.insuranceFactory.createClaim((Act)claimAct);
        claim.setBenefit(benefitAmount, "Approved");
        this.checkEquals(gapAmount, claim.getGapAmount());
        BigDecimal vetBenefit = claim.getTotal().subtract(BigDecimal.ONE);
        claim.state().vetBenefitAmount(vetBenefit).deposit("1", "actIdentity.insuranceDepositTest", OffsetDateTime.now(), vetBenefit).status(Claim.Status.PRE_SETTLED).update();
        ClaimSubmitter submitter = this.createSubmitter(context);
        submitter.pay((Act)claimAct, Assert::assertNull);
        GapPaymentPrompt prompt = (GapPaymentPrompt)this.findComponent(GapPaymentPrompt.class);
        Assert.assertEquals((Object)"Pay Claim", (Object)prompt.getTitle());
        Assert.assertEquals((Object)"The insurer has pre-settled this claim. The customer must pay the gap.", (Object)prompt.getPrompt());
        EchoTestHelper.fireDialogButton((PopupDialog)prompt, (String)"ok");
        CreditActEditDialog payment = (CreditActEditDialog)this.findComponent(CreditActEditDialog.class);
        Assert.assertEquals((Object)"New Payment", (Object)payment.getTitle());
        GapPaymentEditor paymentEditor = (GapPaymentEditor)payment.getEditor();
        Assert.assertEquals((Object)this.customer, (Object)paymentEditor.getCustomer());
        PaymentItemEditor paymentItemEditor = paymentEditor.getUnsavedItem();
        paymentItemEditor.setAmount(remainingGap);
        Assert.assertEquals((Object)paymentEditor.getGapPaymentTill(), (Object)gapTill);
        EditorTestHelper.assertValid((Modifiable)paymentEditor);
        EchoTestHelper.fireDialogButton((PopupDialog)payment, (String)"ok");
        claimAct = (FinancialAct)this.get((IMObject)claimAct);
        this.checkEquals(gapAmount, this.getBean((IMObject)claimAct).getBigDecimal("paid"));
        Assert.assertEquals((Object)GapClaim.GapStatus.PAID.toString(), (Object)claimAct.getStatus2());
        this.checkPrintDialog("Print Receipt?");
        List<IMObject> objects = this.getAccountActs(4);
        FinancialAct invoice = this.checkAccount("act.customerAccountChargesInvoice", invoiceAmount, objects);
        FinancialAct prepayment = this.checkAccount("act.customerAccountPayment", prepaymentAmount, objects);
        FinancialAct gapPayment = this.checkAccount("act.customerAccountPayment", remainingGap, objects);
        FinancialAct benefitPayment = this.checkAccount("act.customerAccountPayment", benefitAmount, objects);
        this.checkPaymentTill(gapPayment, this.till);
        this.checkPaymentTill(benefitPayment, gapTill);
        this.checkEquals(invoiceAmount, invoice.getAllocatedAmount());
        this.checkEquals(prepaymentAmount, prepayment.getAllocatedAmount());
        this.checkEquals(remainingGap, gapPayment.getAllocatedAmount());
        this.checkEquals(benefitAmount, benefitPayment.getAllocatedAmount());
        claimAct = (FinancialAct)this.get((IMObject)claimAct);
        Assert.assertEquals((Object)Claim.Status.SETTLED.toString(), (Object)claimAct.getStatus());
        Assert.assertEquals((Object)GapClaim.GapStatus.NOTIFIED.toString(), (Object)claimAct.getStatus2());
        Assert.assertEquals((long)1L, (long)this.insuranceService.getPaymentNotified());
        this.checkEquals(BigDecimal.ZERO, this.rules.getBalance(this.customer));
    }

    @Test
    public void testPreSettledAfterPayMoreThanGap() {
        Entity gapTill = this.createTill(true);
        Context context = this.createContext(this.till);
        FinancialAct invoiceItem1 = this.createInvoiceItem();
        FinancialAct invoiceItem2 = this.createInvoiceItem();
        BigDecimal invoiceAmount = this.createInvoice("POSTED", invoiceItem1, invoiceItem2).getTotal();
        BigDecimal prepaymentAmount = BigDecimal.valueOf(12L);
        this.createPayment(prepaymentAmount);
        FinancialAct claimAct = this.createClaim(this.policyAct, Claim.Status.POSTED, true, invoiceItem1, invoiceItem2);
        BigDecimal benefitAmount = BigDecimal.valueOf(10L);
        BigDecimal gapAmount = BigDecimal.valueOf(8L);
        BigDecimal refundAmount = prepaymentAmount.subtract(gapAmount);
        GapClaim claim = (GapClaim)this.insuranceFactory.createClaim((Act)claimAct);
        claim.setBenefit(benefitAmount, "Approved");
        this.checkEquals(gapAmount, claim.getGapAmount());
        BigDecimal vetBenefit = claim.getTotal().subtract(BigDecimal.ONE);
        claim.state().vetBenefitAmount(vetBenefit).deposit("1", "actIdentity.insuranceDepositTest", OffsetDateTime.now(), vetBenefit).status(Claim.Status.PRE_SETTLED).update();
        ClaimSubmitter submitter = this.createSubmitter(context);
        submitter.pay((Act)claimAct, Assert::assertNull);
        GapPaymentPrompt prompt = (GapPaymentPrompt)this.findComponent(GapPaymentPrompt.class);
        Assert.assertEquals((Object)"Pay Claim", (Object)prompt.getTitle());
        String message = "The insurer has pre-settled this claim, but the customer has paid more than the gap.\n\nSelect 'Refund and confirm Gap payment' to refund the difference and confirm payment of the Gap.\nSelect 'Confirm Gap payment' to notify the insurer of the Gap payment and process any refund later.";
        Assert.assertEquals((Object)message, (Object)prompt.getPrompt());
        EchoTestHelper.fireDialogButton((PopupDialog)prompt, (String)"ok");
        CreditActEditDialog refund = (CreditActEditDialog)this.findComponent(CreditActEditDialog.class);
        Assert.assertTrue((boolean)refund.getEditor().getObject().isA("act.customerAccountRefund"));
        Assert.assertEquals((Object)"New Refund", (Object)refund.getTitle());
        GapPaymentEditor refundEditor = (GapPaymentEditor)refund.getEditor();
        Assert.assertEquals((Object)this.customer, (Object)refundEditor.getCustomer());
        PaymentItemEditor paymentItemEditor = refundEditor.getUnsavedItem();
        paymentItemEditor.setAmount(refundAmount);
        Assert.assertEquals((Object)refundEditor.getGapPaymentTill(), (Object)gapTill);
        EditorTestHelper.assertValid((Modifiable)refundEditor);
        EchoTestHelper.fireDialogButton((PopupDialog)refund, (String)"ok");
        claimAct = (FinancialAct)this.get((IMObject)claimAct);
        this.checkEquals(gapAmount, this.getBean((IMObject)claimAct).getBigDecimal("paid"));
        Assert.assertEquals((Object)GapClaim.GapStatus.PAID.toString(), (Object)claimAct.getStatus2());
        this.checkPrintDialog("Print Refund?");
        List<IMObject> objects = this.getAccountActs(4);
        FinancialAct invoice = this.checkAccount("act.customerAccountChargesInvoice", invoiceAmount, objects);
        FinancialAct prepayment = this.checkAccount("act.customerAccountPayment", prepaymentAmount, objects);
        FinancialAct gapRefund = this.checkAccount("act.customerAccountRefund", refundAmount, objects);
        FinancialAct benefitPayment = this.checkAccount("act.customerAccountPayment", benefitAmount, objects);
        this.checkPaymentTill(gapRefund, this.till);
        this.checkPaymentTill(benefitPayment, gapTill);
        this.checkEquals(invoiceAmount, invoice.getAllocatedAmount());
        this.checkEquals(prepaymentAmount, prepayment.getAllocatedAmount());
        this.checkEquals(refundAmount, gapRefund.getAllocatedAmount());
        this.checkEquals(benefitAmount, benefitPayment.getAllocatedAmount());
        claimAct = (FinancialAct)this.get((IMObject)claimAct);
        Assert.assertEquals((Object)Claim.Status.SETTLED.toString(), (Object)claimAct.getStatus());
        Assert.assertEquals((Object)GapClaim.GapStatus.NOTIFIED.toString(), (Object)claimAct.getStatus2());
        Assert.assertEquals((long)1L, (long)this.insuranceService.getPaymentNotified());
        this.checkEquals(BigDecimal.ZERO, this.rules.getBalance(this.customer));
    }

    private Entity createTill(boolean gapBenefitTill) {
        Entity till = this.practiceFactory.createTill();
        TestLocationBuilder builder = this.practiceFactory.updateLocation(this.location).tills(new Entity[]{till});
        if (gapBenefitTill) {
            builder.gapBenefitTill(till);
        }
        builder.build();
        return till;
    }

    private FinancialAct createClaim(Act policy, Claim.Status status, boolean gapClaim, FinancialAct ... invoiceItems) {
        return (FinancialAct)this.newClaim(policy, status, gapClaim).item(invoiceItems).build();
    }

    private TestClaimBuilder newClaim(Act policy, Claim.Status status, boolean gapClaim) {
        return this.testInsuranceFactory.newClaim().policy(policy).location(this.location).clinician(this.clinician).claimHandler(this.clinician).gapClaim(gapClaim).status(status.toString());
    }

    private FinancialAct createPayment(BigDecimal amount) {
        return (FinancialAct)((TestPaymentBuilder)((TestPaymentBuilder)this.accountFactory.newPayment().customer(this.customer)).till(this.till)).cash(amount).build();
    }

    private List<IMObject> getAccountActs(int expected) {
        ArchetypeQuery query = CustomerAccountQueryFactory.createQuery((Party)this.customer, (List)CustomerAccountArchetypes.ACCOUNT_ACTS);
        List objects = QueryHelper.query((ArchetypeQuery)query, (IArchetypeService)this.getArchetypeService());
        Assert.assertEquals((long)expected, (long)objects.size());
        return objects;
    }

    private FinancialAct makeGapPayment(FinancialAct claim, BigDecimal amount, BigDecimal expectedPaidAmount, Entity expectedTill, int notifications) {
        CreditActEditDialog payment = (CreditActEditDialog)this.findComponent(CreditActEditDialog.class);
        Assert.assertEquals((Object)"New Payment", (Object)payment.getTitle());
        claim = this.makePaymentOrRefund((ActEditDialog)payment, claim, amount, expectedPaidAmount, expectedTill);
        this.checkPrintDialog("Print Receipt?");
        claim = (FinancialAct)this.get((IMObject)claim);
        Assert.assertEquals((Object)GapClaim.GapStatus.NOTIFIED.toString(), (Object)claim.getStatus2());
        Assert.assertEquals((long)notifications, (long)this.insuranceService.getPaymentNotified());
        return claim;
    }

    private FinancialAct makeGapRefund(FinancialAct claim, BigDecimal amount, BigDecimal expectedPaidAmount, Entity expectedTill, int notifications) {
        ActEditDialog payment = (ActEditDialog)this.findComponent(ActEditDialog.class);
        Assert.assertEquals((Object)"New Refund", (Object)payment.getTitle());
        claim = this.makePaymentOrRefund(payment, claim, amount, expectedPaidAmount, expectedTill);
        this.checkPrintDialog("Print Refund?");
        claim = (FinancialAct)this.get((IMObject)claim);
        Assert.assertEquals((Object)GapClaim.GapStatus.NOTIFIED.toString(), (Object)claim.getStatus2());
        Assert.assertEquals((long)notifications, (long)this.insuranceService.getPaymentNotified());
        return claim;
    }

    private FinancialAct makePaymentOrRefund(ActEditDialog dialog, FinancialAct claim, BigDecimal amount, BigDecimal expectedPaidAmount, Entity expectedTill) {
        GapPaymentEditor paymentEditor = (GapPaymentEditor)dialog.getEditor();
        PaymentItemEditor paymentItemEditor = paymentEditor.getUnsavedItem();
        paymentItemEditor.setAmount(amount);
        Assert.assertEquals((Object)paymentEditor.getGapPaymentTill(), (Object)expectedTill);
        EditorTestHelper.assertValid((Modifiable)paymentEditor);
        EchoTestHelper.fireDialogButton((PopupDialog)dialog, (String)"ok");
        claim = (FinancialAct)this.get((IMObject)claim);
        this.checkEquals(expectedPaidAmount, this.getBean((IMObject)claim).getBigDecimal("paid"));
        Assert.assertEquals((Object)GapClaim.GapStatus.PAID.toString(), (Object)claim.getStatus2());
        return claim;
    }

    private void checkPrintDialog(String expectedTitle) {
        PrintDialog print = (PrintDialog)this.findComponent(PrintDialog.class);
        Assert.assertEquals((Object)expectedTitle, (Object)print.getTitle());
        EchoTestHelper.fireDialogButton((PopupDialog)print, (String)"cancel");
    }

    private void submitAndSelectPayGapClaim(FinancialAct claim, BigDecimal benefitAmount, BigDecimal expectedPaid, BigDecimal expectedToPay, BigDecimal expectedToRefund, Context context) {
        ClaimSubmitter submitter = this.createSubmitter(context);
        submitter.submit((Act)claim, Assert::assertNull);
        ConfirmationDialog confirm = (ConfirmationDialog)this.findComponent(ConfirmationDialog.class);
        Assert.assertEquals((Object)"Submit Claim", (Object)confirm.getTitle());
        String message = "This claim will be submitted to " + this.insurer.getName() + " using Test Service.\n\nSubmit claim?";
        Assert.assertEquals((Object)message, (Object)confirm.getMessage());
        EchoTestHelper.fireDialogButton((PopupDialog)confirm, (String)"yes");
        BenefitDialog benefit = (BenefitDialog)this.findComponent(BenefitDialog.class);
        Assert.assertEquals((Object)"Waiting for Claim Benefit", (Object)benefit.getTitle());
        Assert.assertEquals((Object)("The claim has been submitted to " + this.insurer.getName() + ".\n\nPlease wait for them to determine the benefit amount."), (Object)benefit.getMessage());
        benefit.getClaim().setBenefit(benefitAmount, "Approved");
        benefit.refresh();
        GapPaymentPrompt prompt = (GapPaymentPrompt)this.findComponent(GapPaymentPrompt.class);
        Assert.assertEquals((Object)"Pay Claim", (Object)prompt.getTitle());
        prompt.setPayGap(true);
        this.checkEquals(expectedPaid, prompt.getPaid());
        this.checkEquals(expectedToPay, prompt.getAmountToPay());
        this.checkEquals(expectedToRefund, prompt.getAmountToRefund());
        EchoTestHelper.fireDialogButton((PopupDialog)prompt, (String)"ok");
    }

    private void checkPayGapClaim(boolean preConfiguredTill) {
        this.checkEquals(BigDecimal.ZERO, this.rules.getBalance(this.customer));
        Entity gapTill = this.createTill(preConfiguredTill);
        Context context = this.createContext(this.till);
        FinancialAct invoiceItem1 = this.createInvoiceItem();
        FinancialAct invoiceItem2 = this.createInvoiceItem();
        this.createInvoice("POSTED", invoiceItem1, invoiceItem2);
        FinancialAct claim = this.createClaim(this.policyAct, Claim.Status.POSTED, true, invoiceItem1, invoiceItem2);
        ClaimSubmitter submitter = this.createSubmitter(context);
        submitter.submit((Act)claim, Assert::assertNull);
        ConfirmationDialog confirm = (ConfirmationDialog)this.findComponent(ConfirmationDialog.class);
        Assert.assertEquals((Object)"Submit Claim", (Object)confirm.getTitle());
        String message = "This claim will be submitted to " + this.insurer.getName() + " using Test Service.\n\nSubmit claim?";
        Assert.assertEquals((Object)message, (Object)confirm.getMessage());
        EchoTestHelper.fireDialogButton((PopupDialog)confirm, (String)"yes");
        BenefitDialog benefit = (BenefitDialog)this.findComponent(BenefitDialog.class);
        Assert.assertEquals((Object)"Waiting for Claim Benefit", (Object)benefit.getTitle());
        Assert.assertEquals((Object)("The claim has been submitted to " + this.insurer.getName() + ".\n\nPlease wait for them to determine the benefit amount."), (Object)benefit.getMessage());
        BigDecimal invoiceAmount = BigDecimal.valueOf(18L);
        BigDecimal benefitAmount = BigDecimal.valueOf(10L);
        BigDecimal gapAmount = BigDecimal.valueOf(8L);
        benefit.getClaim().setBenefit(benefitAmount, "Approved");
        benefit.refresh();
        GapPaymentPrompt prompt = (GapPaymentPrompt)this.findComponent(GapPaymentPrompt.class);
        Assert.assertEquals((Object)"Pay Claim", (Object)prompt.getTitle());
        prompt.setPayGap(true);
        EchoTestHelper.fireDialogButton((PopupDialog)prompt, (String)"ok");
        CreditActEditDialog payment = (CreditActEditDialog)this.findComponent(CreditActEditDialog.class);
        Assert.assertEquals((Object)"New Payment", (Object)payment.getTitle());
        GapPaymentEditor paymentEditor = (GapPaymentEditor)payment.getEditor();
        PaymentItemEditor paymentItemEditor = paymentEditor.getUnsavedItem();
        paymentItemEditor.setAmount(gapAmount);
        if (preConfiguredTill) {
            Assert.assertEquals((Object)paymentEditor.getGapPaymentTill(), (Object)gapTill);
            EditorTestHelper.assertValid((Modifiable)paymentEditor);
            EchoTestHelper.fireDialogButton((PopupDialog)payment, (String)"ok");
        } else {
            Assert.assertNull((Object)paymentEditor.getGapPaymentTill());
            EchoTestHelper.fireDialogButton((PopupDialog)payment, (String)"ok");
            Assert.assertFalse((boolean)paymentEditor.isValid());
            paymentEditor.setGapPaymentTill(gapTill);
            EditorTestHelper.assertValid((Modifiable)paymentEditor);
            EchoTestHelper.fireDialogButton((PopupDialog)payment, (String)"ok");
        }
        claim = (FinancialAct)this.get((IMObject)claim);
        this.checkEquals(gapAmount, this.getBean((IMObject)claim).getBigDecimal("paid"));
        Assert.assertEquals((Object)GapClaim.GapStatus.PAID.toString(), (Object)claim.getStatus2());
        this.checkPrintDialog("Print Receipt?");
        List<IMObject> objects = this.getAccountActs(3);
        FinancialAct invoice = this.checkAccount("act.customerAccountChargesInvoice", invoiceAmount, objects);
        FinancialAct gapPayment = this.checkAccount("act.customerAccountPayment", gapAmount, objects);
        FinancialAct benefitPayment = this.checkAccount("act.customerAccountPayment", benefitAmount, objects);
        this.checkPaymentTill(gapPayment, this.till);
        this.checkPaymentTill(benefitPayment, gapTill);
        this.checkEquals(invoiceAmount, invoice.getAllocatedAmount());
        this.checkEquals(gapAmount, gapPayment.getAllocatedAmount());
        this.checkEquals(benefitAmount, benefitPayment.getAllocatedAmount());
        claim = (FinancialAct)this.get((IMObject)claim);
        Assert.assertEquals((Object)GapClaim.GapStatus.NOTIFIED.toString(), (Object)claim.getStatus2());
        Assert.assertEquals((long)1L, (long)this.insuranceService.getPaymentNotified());
        this.checkEquals(BigDecimal.ZERO, this.rules.getBalance(this.customer));
    }

    private Context createContext(Entity till) {
        LocalContext context = new LocalContext();
        context.setUser(this.clinician);
        context.setTill(till);
        context.setLocation(this.location);
        context.setCustomer(this.customer);
        context.setPractice(this.practice);
        return context;
    }

    private void checkRefundToPayGapClaim(boolean preConfiguredTill) {
        Entity gapTill = this.createTill(preConfiguredTill);
        Context context = this.createContext(this.till);
        FinancialAct invoiceItem1 = this.createInvoiceItem();
        FinancialAct invoiceItem2 = this.createInvoiceItem();
        this.createInvoice("POSTED", invoiceItem1, invoiceItem2);
        this.createPayment(BigDecimal.TEN);
        FinancialAct claim = this.createClaim(this.policyAct, Claim.Status.POSTED, true, invoiceItem1);
        ClaimSubmitter submitter = this.createSubmitter(context);
        submitter.submit((Act)claim, Assert::assertNull);
        ConfirmationDialog confirm = (ConfirmationDialog)this.findComponent(ConfirmationDialog.class);
        Assert.assertEquals((Object)"Submit Claim", (Object)confirm.getTitle());
        String message = "This claim will be submitted to " + this.insurer.getName() + " using Test Service.\n\nSubmit claim?";
        Assert.assertEquals((Object)message, (Object)confirm.getMessage());
        EchoTestHelper.fireDialogButton((PopupDialog)confirm, (String)"yes");
        BenefitDialog benefit = (BenefitDialog)this.findComponent(BenefitDialog.class);
        Assert.assertEquals((Object)"Waiting for Claim Benefit", (Object)benefit.getTitle());
        Assert.assertEquals((Object)("The claim has been submitted to " + this.insurer.getName() + ".\n\nPlease wait for them to determine the benefit amount."), (Object)benefit.getMessage());
        BigDecimal benefitAmount = BigDecimal.valueOf(5L);
        BigDecimal gapAmount = BigDecimal.valueOf(4L);
        benefit.getClaim().setBenefit(benefitAmount, "Approved");
        benefit.refresh();
        GapPaymentPrompt prompt = (GapPaymentPrompt)this.findComponent(GapPaymentPrompt.class);
        Assert.assertEquals((Object)"Pay Claim", (Object)prompt.getTitle());
        prompt.setPayGap(true);
        EchoTestHelper.fireDialogButton((PopupDialog)prompt, (String)"ok");
        ActEditDialog refundDialog = (ActEditDialog)this.findComponent(ActEditDialog.class);
        Assert.assertEquals((Object)"New Refund", (Object)refundDialog.getTitle());
        GapPaymentEditor refundEditor = (GapPaymentEditor)refundDialog.getEditor();
        BigDecimal refundAmount = BigDecimal.valueOf(6L);
        this.checkEquals(refundAmount, refundEditor.getExpectedAmount());
        PaymentItemEditor refundItemEditor = refundEditor.getUnsavedItem();
        refundItemEditor.setAmount(refundAmount);
        if (preConfiguredTill) {
            Assert.assertEquals((Object)refundEditor.getGapPaymentTill(), (Object)gapTill);
            EditorTestHelper.assertValid((Modifiable)refundEditor);
            EchoTestHelper.fireDialogButton((PopupDialog)refundDialog, (String)"ok");
        } else {
            Assert.assertNull((Object)refundEditor.getGapPaymentTill());
            EchoTestHelper.fireDialogButton((PopupDialog)refundDialog, (String)"ok");
            Assert.assertFalse((boolean)refundEditor.isValid());
            refundEditor.setGapPaymentTill(gapTill);
            EditorTestHelper.assertValid((Modifiable)refundEditor);
            EchoTestHelper.fireDialogButton((PopupDialog)refundDialog, (String)"ok");
        }
        claim = (FinancialAct)this.get((IMObject)claim);
        this.checkEquals(gapAmount, this.getBean((IMObject)claim).getBigDecimal("paid"));
        Assert.assertEquals((Object)GapClaim.GapStatus.PAID.toString(), (Object)claim.getStatus2());
        this.checkPrintDialog("Print Refund?");
        ArchetypeQuery query = CustomerAccountQueryFactory.createQuery((Party)this.customer, (List)CustomerAccountArchetypes.ACCOUNT_ACTS);
        List objects = QueryHelper.query((ArchetypeQuery)query, (IArchetypeService)this.getArchetypeService());
        Assert.assertEquals((long)4L, (long)objects.size());
        this.checkAccount("act.customerAccountChargesInvoice", BigDecimal.valueOf(18L), objects);
        this.checkAccount("act.customerAccountPayment", BigDecimal.TEN, objects);
        this.checkAccount("act.customerAccountRefund", refundAmount, objects);
        FinancialAct benefitPayment = this.checkAccount("act.customerAccountPayment", benefitAmount, objects);
        this.checkPaymentTill(benefitPayment, gapTill);
        claim = (FinancialAct)this.get((IMObject)claim);
        Assert.assertEquals((Object)GapClaim.GapStatus.NOTIFIED.toString(), (Object)claim.getStatus2());
        Assert.assertEquals((long)1L, (long)this.insuranceService.getPaymentNotified());
    }

    private void checkPaymentTill(FinancialAct payment, Entity till) {
        IMObjectBean bean = this.getBean((IMObject)payment);
        Assert.assertEquals((Object)till.getObjectReference(), (Object)bean.getTargetRef("till"));
    }

    private CreditActEditDialog pay(BigDecimal amount) {
        CreditActEditDialog payment = (CreditActEditDialog)this.findComponent(CreditActEditDialog.class);
        Assert.assertEquals((Object)"New Payment", (Object)payment.getTitle());
        PaymentEditor paymentEditor = (PaymentEditor)payment.getEditor();
        PaymentItemEditor paymentItemEditor = paymentEditor.getUnsavedItem();
        paymentItemEditor.getProperty("amount").setValue((Object)amount);
        return payment;
    }

    private FinancialAct checkAccount(String archetype, BigDecimal total, List<IMObject> acts) {
        FinancialAct result = null;
        int count = 0;
        for (IMObject object : acts) {
            if (!object.isA(archetype)) continue;
            FinancialAct act = (FinancialAct)object;
            Assert.assertEquals((Object)"POSTED", (Object)act.getStatus());
            if (act.getTotal().compareTo(total) != 0) continue;
            result = act;
            ++count;
        }
        Assert.assertNotNull(result);
        Assert.assertEquals((long)1L, (long)count);
        return result;
    }

    private void initDocumentTemplate(String type, String name) {
        Entity template = new TemplateHelper((ArchetypeService)this.getArchetypeService()).getTemplateForType(type);
        if (template == null) {
            ((TestDocumentTemplateBuilder)((TestDocumentTemplateBuilder)this.documentFactory.newTemplate().name(name)).type(type).blankDocument()).build();
        } else if (!StringUtils.equals((CharSequence)name, (CharSequence)template.getName())) {
            template.setName(name);
            this.save((IMObject)template);
        }
    }

    private void checkDuplicate(ClaimEditor editor, Act duplicate, boolean allowed) {
        this.errors.clear();
        ClaimSubmitter submitter = this.createSubmitter();
        submitter.submit(editor, Assert::assertNull);
        this.checkDuplicate(duplicate, allowed);
    }

    private void checkDuplicate(Act claim, Act duplicate, boolean allowed) {
        this.errors.clear();
        ClaimSubmitter submitter = this.createSubmitter();
        submitter.submit(claim, Assert::assertNull);
        this.checkDuplicate(duplicate, allowed);
    }

    private void checkDuplicate(Act duplicate, boolean allowed) {
        if (!allowed) {
            Assert.assertEquals((long)1L, (long)this.errors.size());
            String error = "Cannot submit this claim. It contains charges already claimed by claim " + NumberFormatter.format((Number)duplicate.getId()) + ", dated " + DateFormatter.formatDate((Date)duplicate.getActivityStartTime(), (boolean)false) + ".";
            Assert.assertEquals((Object)error, (Object)this.errors.get(0));
        } else {
            Assert.assertEquals((long)0L, (long)this.errors.size());
        }
    }

    private ClaimSubmitter createSubmitter() {
        LocalContext context = new LocalContext();
        context.setPractice(this.practice);
        context.setLocation(this.location);
        context.setUser(this.clinician);
        return this.createSubmitter((Context)context);
    }

    private ClaimSubmitter createSubmitter(Context context) {
        InsuranceServices insuranceServices = (InsuranceServices)Mockito.mock(InsuranceServices.class);
        Mockito.when((Object)insuranceServices.canSubmit((Party)Mockito.any())).thenReturn((Object)true);
        Mockito.when((Object)insuranceServices.getService((Party)Mockito.any())).thenReturn((Object)this.insuranceService);
        return new ClaimSubmitter(this.getArchetypeService(), this.insuranceFactory, insuranceServices, context, new HelpContext("foo", null)){

            protected BenefitDialog createBenefitDialog(GapClaimImpl claim) {
                return new BenefitDialog(claim, new HelpContext("foo", null)){

                    protected boolean reload(long now) {
                        return true;
                    }
                };
            }
        };
    }

    private FinancialAct createInvoice(String status, FinancialAct ... items) {
        return (FinancialAct)((TestInvoiceBuilder)((TestInvoiceBuilder)((TestInvoiceBuilder)((TestInvoiceBuilder)this.accountFactory.newInvoice().customer(this.customer)).clinician(this.clinician)).status(status)).add(items)).build();
    }

    private FinancialAct createInvoiceItem() {
        return this.createInvoiceItem(this.patient);
    }

    private FinancialAct createInvoiceItem(Party patient) {
        return (FinancialAct)((TestInvoiceItemBuilder)((TestInvoiceItemBuilder)((TestInvoiceItemBuilder)((TestInvoiceItemBuilder)((TestInvoiceItemBuilder)((TestInvoiceItemBuilder)this.accountFactory.newInvoiceItem().patient(patient)).product(this.productFactory.createMedication())).quantity(1)).unitPrice(10)).discount(1)).tax(new BigDecimal("0.82"))).build();
    }
}

