/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.insurance.claim;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.finance.account.FinancialTestHelper;
import org.openvpms.archetype.rules.insurance.InsuranceTestHelper;
import org.openvpms.archetype.rules.patient.PatientTestHelper;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.business.domain.im.document.Document;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.ActIdentity;
import org.openvpms.component.model.act.ActRelationship;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.AuditableIMObject;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.user.User;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.edit.EditorTestHelper;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.SaveHelper;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.test.AbstractAppTest;
import org.openvpms.web.workspace.patient.insurance.claim.ChargeCollectionEditor;
import org.openvpms.web.workspace.patient.insurance.claim.ClaimEditor;
import org.openvpms.web.workspace.patient.insurance.claim.ClaimItemEditor;
import org.openvpms.web.workspace.patient.insurance.claim.TestClaimEditor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public class ClaimEditorTestCase
extends AbstractAppTest {
    @Autowired
    PlatformTransactionManager transactionManager;
    private Party customer;
    private Party patient;
    private User clinician;
    private Party practice;
    private Party location;
    private User user;
    private Act policyAct;

    @Before
    public void setUp() {
        super.setUp();
        this.practice = TestHelper.getPractice();
        this.customer = TestHelper.createCustomer((String)"MS", (String)"J", (String)"Bloggs", (String)"12 Broadwater Avenue", (String)"CAPE_WOOLAMAI", (String)"VIC", (String)"3925", (String)"9123456", (String)"98765432", (String)"04987654321", (String)"foo@test.com");
        this.location = TestHelper.createLocation((String)"5123456", (String)"vetsrus@test.com", (boolean)false);
        this.clinician = TestHelper.createClinician();
        this.user = TestHelper.createUser((String)"Z", (String)"Smith");
        Date dateOfBirth = DateRules.getDate((Date)DateRules.getToday(), (int)-1, (DateUnits)DateUnits.YEARS);
        this.patient = PatientTestHelper.createPatient((String)"Fido", (String)"CANINE", (String)"PUG", (String)"MALE", (Date)dateOfBirth, (String)"123454321", (String)"BLACK", (Party)this.customer);
        Act note1 = PatientTestHelper.createNote((Date)TestHelper.getDate((String)"2015-05-01"), (Party)this.patient, (User)this.clinician, (String)"Note 1");
        Act note2 = PatientTestHelper.createNote((Date)TestHelper.getDate((String)"2015-05-02"), (Party)this.patient, (User)this.clinician, (String)"Note 2");
        PatientTestHelper.createEvent((Date)TestHelper.getDate((String)"2015-05-01"), (Party)this.patient, (Act[])new Act[]{note1, note2});
        Act note3 = PatientTestHelper.createNote((Date)TestHelper.getDate((String)"2015-07-01"), (Party)this.patient, (User)this.clinician, (String)"Note 3");
        Act addendum1 = PatientTestHelper.createAddendum((Date)TestHelper.getDate((String)"2015-07-03"), (Party)this.patient, (User)this.clinician, (String)"Note 3 addendum 1");
        Act addendum2 = PatientTestHelper.createAddendum((Date)TestHelper.getDate((String)"2015-07-04"), (Party)this.patient, (User)this.clinician, (String)"Note 3 addendum 2");
        PatientTestHelper.addAddendum((Act)note3, (Act)addendum1);
        PatientTestHelper.addAddendum((Act)note3, (Act)addendum2);
        PatientTestHelper.createEvent((Date)TestHelper.getDate((String)"2015-07-01"), (Party)this.patient, (Act[])new Act[]{note3});
        InsuranceTestHelper.createDiagnosis((String)"VENOM_328", (String)"Abcess", (String)"328");
        Party insurer = InsuranceTestHelper.createInsurer((String)TestHelper.randomName((String)"ZInsurer-"));
        this.policyAct = InsuranceTestHelper.createPolicy((Party)this.customer, (Party)this.patient, (Party)insurer, (ActIdentity)TestHelper.createActIdentity((String)"actIdentity.insurancePolicy", (String)"POL123456"));
        this.save((IMObject)this.policyAct);
    }

    @Test
    public void testDelete() {
        Product product1 = TestHelper.createProduct();
        Date itemDate1 = TestHelper.getDatetime((String)"2017-09-27 10:00:00");
        BigDecimal discount1 = new BigDecimal("0.10");
        BigDecimal tax1 = new BigDecimal("0.08");
        FinancialAct invoiceItem1 = this.createInvoiceItem(itemDate1, product1, BigDecimal.ONE, BigDecimal.ONE, discount1, tax1);
        List<FinancialAct> invoice1Acts = this.createInvoice(TestHelper.getDate((String)"2017-09-27"), invoiceItem1);
        this.save(invoice1Acts);
        FinancialAct item1Act = InsuranceTestHelper.createClaimItem((String)"VENOM_328", (Date)itemDate1, (Date)itemDate1, (FinancialAct[])new FinancialAct[]{invoiceItem1});
        final FinancialAct claimAct = InsuranceTestHelper.createClaim((Act)this.policyAct, (Party)this.location, (User)this.clinician, (User)this.user, (FinancialAct[])new FinancialAct[]{item1Act});
        IMObjectBean bean = this.getBean((IMObject)claimAct);
        DocumentAct documentAct1 = PatientTestHelper.createDocumentAttachment((Date)itemDate1, (Party)this.patient);
        DocumentAct attachment1 = InsuranceTestHelper.createAttachment((DocumentAct)documentAct1);
        Document content1 = (Document)this.create("document.other", Document.class);
        content1.setName(documentAct1.getName());
        attachment1.setDocument((Reference)content1.getObjectReference());
        Relationship relationship1 = bean.addTarget("attachments", (IMObject)attachment1);
        attachment1.addActRelationship((ActRelationship)((org.openvpms.component.business.domain.im.act.ActRelationship)relationship1));
        DocumentAct documentAct2 = PatientTestHelper.createDocumentAttachment((Date)itemDate1, (Party)this.patient);
        DocumentAct attachment2 = InsuranceTestHelper.createAttachment((DocumentAct)documentAct2);
        Document content2 = (Document)this.create("document.other", Document.class);
        content2.setName(documentAct2.getName());
        attachment2.setDocument((Reference)content2.getObjectReference());
        Relationship relationship2 = bean.addTarget("attachments", (IMObject)attachment2);
        attachment2.addActRelationship((ActRelationship)((org.openvpms.component.business.domain.im.act.ActRelationship)relationship2));
        this.save((IMObject[])new AuditableIMObject[]{claimAct, item1Act, attachment1, content1, attachment2, content2});
        TransactionTemplate template = new TransactionTemplate(this.transactionManager);
        template.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus transactionStatus) {
                ClaimEditor editor = ClaimEditorTestCase.this.createEditor(claimAct);
                editor.delete();
            }
        });
        Assert.assertNull((Object)this.get((IMObject)claimAct));
        Assert.assertNull((Object)this.get((IMObject)item1Act));
        Assert.assertNull((Object)this.get((IMObject)attachment1));
        Assert.assertNull((Object)this.get((IMObject)content1));
        Assert.assertNull((Object)this.get((IMObject)claimAct));
        Assert.assertNull((Object)this.get((IMObject)attachment2));
        Assert.assertNull((Object)this.get((IMObject)content2));
        Assert.assertNotNull((Object)this.get((IMObject)documentAct1));
        Assert.assertNotNull((Object)this.get((IMObject)documentAct2));
        Assert.assertNotNull((Object)this.get((IMObject)this.policyAct));
        Assert.assertNotNull((Object)this.get((IMObject)invoiceItem1));
        Assert.assertNotNull((Object)this.get((IMObject)invoice1Acts.get(0)));
    }

    @Test
    public void testDeleteClaimItem() {
        Date date1 = TestHelper.getDatetime((String)"2017-09-27 10:00:00");
        FinancialAct invoiceItem1 = this.createInvoiceItem(date1);
        List<FinancialAct> invoice1Acts = this.createInvoice(date1, invoiceItem1);
        FinancialAct invoice1 = invoice1Acts.get(0);
        invoice1.setAllocatedAmount(invoice1.getTotal());
        this.save(invoice1Acts);
        Date date2 = TestHelper.getDatetime((String)"2017-10-27 15:00:00");
        FinancialAct invoiceItem2 = this.createInvoiceItem(date2);
        List<FinancialAct> invoice2Acts = this.createInvoice(date2, invoiceItem2);
        FinancialAct invoice2 = invoice2Acts.get(0);
        invoice2.setAllocatedAmount(invoice1.getTotal());
        this.save(invoice2Acts);
        FinancialAct item1Act = InsuranceTestHelper.createClaimItem((String)"VENOM_328", (Date)date1, (Date)date1, (FinancialAct[])new FinancialAct[]{invoiceItem1});
        FinancialAct item2Act = InsuranceTestHelper.createClaimItem((String)"VENOM_328", (Date)date2, (Date)date2, (FinancialAct[])new FinancialAct[]{invoiceItem2});
        FinancialAct claimAct = InsuranceTestHelper.createClaim((Act)this.policyAct, (Party)this.location, (User)this.clinician, (User)this.user, (FinancialAct[])new FinancialAct[]{item1Act, item2Act});
        this.save((IMObject[])new FinancialAct[]{claimAct, item1Act, item2Act, invoiceItem1, invoiceItem2});
        ClaimEditor editor = this.createEditor(claimAct);
        this.checkClaim(claimAct, new BigDecimal("1.64"), BigDecimal.valueOf(18L));
        editor.getItems().remove((IMObject)item2Act);
        this.checkClaim(claimAct, new BigDecimal("0.82"), BigDecimal.valueOf(9L));
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor));
        Assert.assertNull((Object)this.get((IMObject)item2Act));
        Assert.assertNotNull((Object)this.get((IMObject)invoice1));
        Assert.assertNotNull((Object)this.get((IMObject)invoiceItem1));
        Assert.assertNotNull((Object)this.get((IMObject)invoice2));
        Assert.assertNotNull((Object)this.get((IMObject)invoiceItem2));
        Assert.assertNotNull((Object)item1Act);
    }

    @Test
    public void testDeleteAttachment() {
        Date itemDate1 = TestHelper.getDatetime((String)"2017-09-27 10:00:00");
        FinancialAct invoiceItem1 = this.createInvoiceItem(itemDate1);
        List<FinancialAct> invoice1Acts = this.createInvoice(TestHelper.getDate((String)"2017-09-27"), invoiceItem1);
        FinancialAct invoice1 = invoice1Acts.get(0);
        invoice1.setAllocatedAmount(invoice1.getTotal());
        this.save(invoice1Acts);
        FinancialAct item1Act = InsuranceTestHelper.createClaimItem((String)"VENOM_328", (Date)itemDate1, (Date)itemDate1, (FinancialAct[])new FinancialAct[]{invoiceItem1});
        FinancialAct claimAct = InsuranceTestHelper.createClaim((Act)this.policyAct, (Party)this.location, (User)this.clinician, (User)this.user, (FinancialAct[])new FinancialAct[]{item1Act});
        IMObjectBean bean = this.getBean((IMObject)claimAct);
        DocumentAct documentAct = PatientTestHelper.createDocumentAttachment((Date)itemDate1, (Party)this.patient);
        Document content = (Document)this.create("document.other", Document.class);
        content.setName(documentAct.getName());
        documentAct.setDocument((Reference)content.getObjectReference());
        this.save((IMObject[])new AuditableIMObject[]{documentAct, content});
        DocumentAct attachment = InsuranceTestHelper.createAttachment((DocumentAct)documentAct);
        Document copy = (Document)this.create("document.other", Document.class);
        copy.setName(documentAct.getName());
        attachment.setDocument((Reference)copy.getObjectReference());
        Relationship relationship = bean.addTarget("attachments", (IMObject)attachment);
        attachment.addActRelationship((ActRelationship)((org.openvpms.component.business.domain.im.act.ActRelationship)relationship));
        this.save((IMObject[])new AuditableIMObject[]{claimAct, item1Act, documentAct, content, attachment, copy});
        ClaimEditor editor = this.createEditor(claimAct);
        editor.getAttachments().remove((IMObject)attachment);
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor));
        Assert.assertNull((Object)this.get((IMObject)attachment));
        Assert.assertNull((Object)this.get((IMObject)copy));
        Assert.assertNotNull((Object)this.get((IMObject)documentAct));
        Assert.assertNotNull((Object)this.get((IMObject)content));
    }

    @Test
    public void testDeleteInvoiceItem() {
        Date date1 = TestHelper.getDatetime((String)"2017-09-27 10:00:00");
        FinancialAct invoiceItem1 = this.createInvoiceItem(date1);
        FinancialAct invoiceItem2 = this.createInvoiceItem(date1);
        List<FinancialAct> invoice1Acts = this.createInvoice(date1, invoiceItem1, invoiceItem2);
        FinancialAct invoice1 = invoice1Acts.get(0);
        invoice1.setAllocatedAmount(invoice1.getTotal());
        this.save(invoice1Acts);
        FinancialAct item1Act = InsuranceTestHelper.createClaimItem((String)"VENOM_328", (Date)date1, (Date)date1, (FinancialAct[])new FinancialAct[]{invoiceItem1, invoiceItem2});
        FinancialAct claimAct = InsuranceTestHelper.createClaim((Act)this.policyAct, (Party)this.location, (User)this.clinician, (User)this.user, (FinancialAct[])new FinancialAct[]{item1Act});
        this.save((IMObject[])new FinancialAct[]{claimAct, item1Act, invoiceItem1, invoiceItem2});
        ClaimEditor editor = this.createEditor(claimAct);
        this.checkClaim(claimAct, new BigDecimal("1.64"), BigDecimal.valueOf(18L));
        ClaimItemEditor itemEditor = (ClaimItemEditor)editor.getItems().getEditor((IMObject)item1Act);
        Assert.assertNotNull((Object)itemEditor);
        ChargeCollectionEditor chargeCollectionEditor = itemEditor.getChargeCollectionEditor();
        chargeCollectionEditor.getComponent();
        chargeCollectionEditor.remove((IMObject)invoiceItem1);
        this.checkClaim(claimAct, new BigDecimal("0.82"), BigDecimal.valueOf(9L));
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor));
        Assert.assertNotNull((Object)this.get((IMObject)invoice1));
        Assert.assertNotNull((Object)this.get((IMObject)invoiceItem1));
        Assert.assertNotNull((Object)this.get((IMObject)invoiceItem2));
    }

    @Test
    public void testClaimWithPolicyForDifferentCustomer() {
        Product product1 = TestHelper.createProduct();
        Date itemDate1 = TestHelper.getDatetime((String)"2017-09-27 10:00:00");
        BigDecimal discount1 = new BigDecimal("0.10");
        BigDecimal tax1 = new BigDecimal("0.08");
        FinancialAct invoiceItem1 = this.createInvoiceItem(itemDate1, product1, BigDecimal.ONE, BigDecimal.ONE, discount1, tax1);
        List<FinancialAct> invoice1Acts = this.createInvoice(TestHelper.getDate((String)"2017-09-27"), invoiceItem1);
        FinancialAct invoice1 = invoice1Acts.get(0);
        invoice1.setAllocatedAmount(invoice1.getTotal());
        this.save(invoice1Acts);
        FinancialAct item1Act = InsuranceTestHelper.createClaimItem((String)"VENOM_328", (Date)itemDate1, (Date)itemDate1, (FinancialAct[])new FinancialAct[]{invoiceItem1});
        FinancialAct claimAct = InsuranceTestHelper.createClaim((Act)this.policyAct, (Party)this.location, (User)this.clinician, (User)this.user, (FinancialAct[])new FinancialAct[]{item1Act});
        this.save((IMObject[])new FinancialAct[]{claimAct, item1Act});
        ClaimEditor editor1 = this.createEditor(claimAct);
        Assert.assertTrue((boolean)editor1.isValid());
        IMObjectBean bean = this.getBean((IMObject)this.policyAct);
        Party customer2 = TestHelper.createCustomer();
        bean.setTarget("customer", (IMObject)customer2);
        bean.save();
        ClaimEditor editor2 = this.createEditor(claimAct);
        EditorTestHelper.assertInvalid((Modifiable)editor2, (String)("Cannot make a claim with this policy.\n\nIt belongs to a different customer: " + customer2.getName() + "."));
    }

    @Test
    public void testCannotMakeGapClaimWhenInvoiceFullyPaid() {
        Date date1 = new Date();
        FinancialAct invoiceItem1 = this.createInvoiceItem(date1);
        FinancialAct invoiceItem2 = this.createInvoiceItem(date1);
        List<FinancialAct> invoice1Acts = this.createInvoice(date1, invoiceItem1, invoiceItem2);
        FinancialAct invoice1 = invoice1Acts.get(0);
        invoice1.setAllocatedAmount(invoice1.getTotal());
        this.save(invoice1Acts);
        FinancialAct item1Act = InsuranceTestHelper.createClaimItem((String)"VENOM_328", (Date)date1, (Date)date1, (FinancialAct[])new FinancialAct[]{invoiceItem1, invoiceItem2});
        FinancialAct claimAct = InsuranceTestHelper.createClaim((Act)this.policyAct, (Party)this.location, (User)this.clinician, (User)this.user, (boolean)true, (FinancialAct[])new FinancialAct[]{item1Act});
        this.save((IMObject[])new FinancialAct[]{claimAct, item1Act, invoiceItem1, invoiceItem2});
        ClaimEditor editor = this.createEditor(claimAct);
        EditorTestHelper.assertInvalid((Modifiable)editor, (String)"Cannot make a gap claim as all invoices in this claim have been fully paid.");
    }

    private ClaimEditor createEditor(FinancialAct claim) {
        LocalContext context = new LocalContext();
        context.setPatient(this.patient);
        context.setCustomer(this.customer);
        context.setPractice(this.practice);
        context.setLocation(this.location);
        context.setUser(this.user);
        DefaultLayoutContext layout = new DefaultLayoutContext(true, (Context)context, new HelpContext("foo", null));
        TestClaimEditor editor = new TestClaimEditor(claim, (LayoutContext)layout);
        editor.getComponent();
        return editor;
    }

    private void checkClaim(FinancialAct claim, BigDecimal tax, BigDecimal total) {
        this.checkEquals(tax, claim.getTaxAmount());
        this.checkEquals(total, claim.getTotal());
    }

    private FinancialAct createInvoiceItem(Date date) {
        BigDecimal discount = BigDecimal.ONE;
        BigDecimal tax = new BigDecimal("0.82");
        return this.createInvoiceItem(date, TestHelper.createProduct(), BigDecimal.ONE, BigDecimal.TEN, discount, tax);
    }

    private FinancialAct createInvoiceItem(Date date, Product product, BigDecimal quantity, BigDecimal price, BigDecimal discount, BigDecimal tax) {
        return FinancialTestHelper.createInvoiceItem((Date)date, (Party)this.patient, (User)this.clinician, (Product)product, (BigDecimal)quantity, (BigDecimal)BigDecimal.ZERO, (BigDecimal)price, (BigDecimal)discount, (BigDecimal)tax);
    }

    private List<FinancialAct> createInvoice(Date date, FinancialAct ... items) {
        List invoice = FinancialTestHelper.createChargesInvoice((Party)this.customer, (User)this.clinician, (String)"POSTED", (FinancialAct[])items);
        ((FinancialAct)invoice.get(0)).setActivityStartTime(date);
        this.save(invoice);
        return invoice;
    }
}

